/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.intern.theme;

import bibliothek.extension.gui.dock.theme.EclipseTheme;
import bibliothek.gui.DockController;
import bibliothek.gui.DockTheme;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.intern.color.BasicButtonTitleTransmitter;
import bibliothek.gui.dock.common.intern.color.EclipseTabTransmitter;
import bibliothek.gui.dock.common.intern.font.FontBridgeFactory;
import bibliothek.gui.dock.common.intern.font.TabTitleFontTransmitter;
import bibliothek.gui.dock.common.intern.theme.CDockTheme;
import bibliothek.gui.dock.themes.ColorBridgeFactory;
import bibliothek.gui.dock.themes.NoStackTheme;
import bibliothek.gui.dock.themes.color.TabColor;
import bibliothek.gui.dock.themes.color.TitleColor;
import bibliothek.gui.dock.themes.font.TitleFont;
import bibliothek.gui.dock.util.DockUtilities;
import bibliothek.gui.dock.util.IconManager;
import bibliothek.gui.dock.util.color.ColorBridge;
import bibliothek.gui.dock.util.color.ColorManager;
import bibliothek.gui.dock.util.font.FontBridge;
import bibliothek.gui.dock.util.font.FontManager;
import java.util.Map;
import javax.swing.Icon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CEclipseTheme
extends CDockTheme<EclipseTheme> {
    public CEclipseTheme(CControl cControl, EclipseTheme eclipseTheme) {
        super(eclipseTheme);
        this.init(cControl);
    }

    public CEclipseTheme(CControl cControl) {
        this(new EclipseTheme());
        this.init(cControl);
    }

    private CEclipseTheme(EclipseTheme eclipseTheme) {
        super(eclipseTheme, (DockTheme)new NoStackTheme((DockTheme)eclipseTheme));
    }

    private void init(final CControl cControl) {
        this.putColorBridgeFactory(TabColor.KIND_TAB_COLOR, new ColorBridgeFactory(){

            public ColorBridge create(ColorManager colorManager) {
                EclipseTabTransmitter eclipseTabTransmitter = new EclipseTabTransmitter(colorManager);
                eclipseTabTransmitter.setControl(cControl);
                return eclipseTabTransmitter;
            }
        });
        this.putColorBridgeFactory(TitleColor.KIND_FLAP_BUTTON_COLOR, new ColorBridgeFactory(){

            public ColorBridge create(ColorManager colorManager) {
                BasicButtonTitleTransmitter basicButtonTitleTransmitter = new BasicButtonTitleTransmitter(colorManager);
                basicButtonTitleTransmitter.setControl(cControl);
                return basicButtonTitleTransmitter;
            }
        });
        this.initDefaultFontBridges(cControl);
        this.putFontBridgeFactory(TitleFont.KIND_TAB_TITLE_FONT, new FontBridgeFactory(){

            public FontBridge create(FontManager fontManager) {
                TabTitleFontTransmitter tabTitleFontTransmitter = new TabTitleFontTransmitter(fontManager);
                tabTitleFontTransmitter.setControl(cControl);
                return tabTitleFontTransmitter;
            }
        });
    }

    @Override
    public void install(DockController dockController) {
        super.install(dockController);
        IconManager iconManager = dockController.getIcons();
        Map map = DockUtilities.loadIcons((String)"data/bibliothek/gui/dock/icons/eclipse/icons.ini", (String)"data/bibliothek/gui/dock/icons/eclipse/", (ClassLoader)CEclipseTheme.class.getClassLoader());
        for (Map.Entry entry : map.entrySet()) {
            iconManager.setIconTheme((String)entry.getKey(), (Icon)entry.getValue());
        }
    }

    @Override
    public void uninstall(DockController dockController) {
        super.uninstall(dockController);
        dockController.getIcons().clearThemeIcons();
    }
}

