/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.intern.theme;

import bibliothek.extension.gui.dock.util.Path;
import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.DockTheme;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.intern.font.ButtonFontTransmitter;
import bibliothek.gui.dock.common.intern.font.FontBridgeFactory;
import bibliothek.gui.dock.common.intern.font.TabFontTransmitter;
import bibliothek.gui.dock.common.intern.font.TitleFontTransmitter;
import bibliothek.gui.dock.dockable.DockableMovingImageFactory;
import bibliothek.gui.dock.focus.DockableSelection;
import bibliothek.gui.dock.station.Combiner;
import bibliothek.gui.dock.station.DisplayerFactory;
import bibliothek.gui.dock.station.StationPaint;
import bibliothek.gui.dock.themes.ColorBridgeFactory;
import bibliothek.gui.dock.themes.font.TabFont;
import bibliothek.gui.dock.themes.font.TitleFont;
import bibliothek.gui.dock.title.DockTitleFactory;
import bibliothek.gui.dock.util.Priority;
import bibliothek.gui.dock.util.UIBridge;
import bibliothek.gui.dock.util.color.ColorBridge;
import bibliothek.gui.dock.util.color.ColorManager;
import bibliothek.gui.dock.util.font.FontBridge;
import bibliothek.gui.dock.util.font.FontManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDockTheme<D extends DockTheme>
implements DockTheme {
    private D theme;
    private DockTheme delegate;
    private Map<Path, ColorBridgeFactory> colorBridgeFactories = new HashMap<Path, ColorBridgeFactory>();
    private Map<Path, FontBridgeFactory> fontBridgeFactories = new HashMap<Path, FontBridgeFactory>();
    private List<Controller> controllers = new ArrayList<Controller>();

    public CDockTheme(D d) {
        this(d, (DockTheme)d);
    }

    public CDockTheme(D d, DockTheme dockTheme) {
        if (d == null) {
            throw new IllegalArgumentException("theme must not be null");
        }
        if (dockTheme == null) {
            throw new IllegalArgumentException("delegate must not be null");
        }
        this.theme = d;
        this.delegate = dockTheme;
    }

    protected void initDefaultFontBridges(final CControl cControl) {
        this.putFontBridgeFactory(TitleFont.KIND_TITLE_FONT, new FontBridgeFactory(){

            public FontBridge create(FontManager fontManager) {
                TitleFontTransmitter titleFontTransmitter = new TitleFontTransmitter(fontManager);
                titleFontTransmitter.setControl(cControl);
                return titleFontTransmitter;
            }
        });
        this.putFontBridgeFactory(TitleFont.KIND_FLAP_BUTTON_FONT, new FontBridgeFactory(){

            public FontBridge create(FontManager fontManager) {
                ButtonFontTransmitter buttonFontTransmitter = new ButtonFontTransmitter(fontManager);
                buttonFontTransmitter.setControl(cControl);
                return buttonFontTransmitter;
            }
        });
        this.putFontBridgeFactory(TabFont.KIND_TAB_FONT, new FontBridgeFactory(){

            public FontBridge create(FontManager fontManager) {
                TabFontTransmitter tabFontTransmitter = new TabFontTransmitter(fontManager);
                tabFontTransmitter.setControl(cControl);
                return tabFontTransmitter;
            }
        });
    }

    public D intern() {
        return this.theme;
    }

    public Combiner getCombiner(DockStation dockStation) {
        return this.delegate.getCombiner(dockStation);
    }

    public DisplayerFactory getDisplayFactory(DockStation dockStation) {
        return this.delegate.getDisplayFactory(dockStation);
    }

    public DockableMovingImageFactory getMovingImageFactory(DockController dockController) {
        return this.delegate.getMovingImageFactory(dockController);
    }

    public StationPaint getPaint(DockStation dockStation) {
        return this.delegate.getPaint(dockStation);
    }

    public DockTitleFactory getTitleFactory(DockController dockController) {
        return this.delegate.getTitleFactory(dockController);
    }

    public DockableSelection getDockableSelection(DockController dockController) {
        return this.delegate.getDockableSelection(dockController);
    }

    public void putColorBridgeFactory(Path path, ColorBridgeFactory colorBridgeFactory) {
        this.colorBridgeFactories.put(path, colorBridgeFactory);
        for (Controller controller : this.controllers) {
            ColorBridge colorBridge;
            ColorManager colorManager = controller.controller.getColors();
            ColorBridge colorBridge2 = controller.colors.remove(path);
            ColorBridge colorBridge3 = colorBridge = colorBridgeFactory == null ? null : colorBridgeFactory.create(colorManager);
            if (colorBridge == null) {
                controller.colors.remove(path);
                if (colorBridge2 == null) continue;
                colorManager.unpublish(Priority.DEFAULT, path);
                continue;
            }
            controller.colors.put(path, colorBridge);
            colorManager.publish(Priority.DEFAULT, path, (UIBridge)colorBridge);
        }
    }

    public void putFontBridgeFactory(Path path, FontBridgeFactory fontBridgeFactory) {
        this.fontBridgeFactories.put(path, fontBridgeFactory);
        for (Controller controller : this.controllers) {
            FontBridge fontBridge;
            FontManager fontManager = controller.controller.getFonts();
            FontBridge fontBridge2 = controller.fonts.remove(path);
            FontBridge fontBridge3 = fontBridge = fontBridgeFactory == null ? null : fontBridgeFactory.create(fontManager);
            if (fontBridge == null) {
                controller.fonts.remove(path);
                if (fontBridge2 == null) continue;
                fontManager.unpublish(Priority.DEFAULT, path);
                continue;
            }
            controller.fonts.put(path, fontBridge);
            fontManager.publish(Priority.DEFAULT, path, (UIBridge)fontBridge);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void install(DockController dockController) {
        this.delegate.install(dockController);
        Controller controller = new Controller();
        controller.controller = dockController;
        ColorManager colorManager = dockController.getColors();
        try {
            colorManager.lockUpdate();
            for (Map.Entry<Path, ColorBridgeFactory> object : this.colorBridgeFactories.entrySet()) {
                ColorBridge colorBridge = object.getValue().create(colorManager);
                colorManager.publish(Priority.DEFAULT, object.getKey(), (UIBridge)colorBridge);
                controller.colors.put(object.getKey(), colorBridge);
            }
        }
        finally {
            colorManager.unlockUpdate();
        }
        FontManager fontManager = dockController.getFonts();
        try {
            fontManager.lockUpdate();
            for (Map.Entry<Path, FontBridgeFactory> entry : this.fontBridgeFactories.entrySet()) {
                FontBridge fontBridge = entry.getValue().create(fontManager);
                fontManager.publish(Priority.DEFAULT, entry.getKey(), (UIBridge)fontBridge);
                controller.fonts.put(entry.getKey(), fontBridge);
            }
        }
        finally {
            fontManager.unlockUpdate();
        }
        this.controllers.add(controller);
    }

    public void uninstall(DockController dockController) {
        this.delegate.uninstall(dockController);
        int n = this.controllers.size();
        for (int i = 0; i < n; ++i) {
            Controller controller = this.controllers.get(i);
            if (controller.controller != dockController) continue;
            this.controllers.remove(i);
            ColorManager colorManager = dockController.getColors();
            for (ColorBridge colorBridge : controller.colors.values()) {
                colorManager.unpublish(Priority.DEFAULT, (UIBridge)colorBridge);
            }
            FontManager fontManager = dockController.getFonts();
            for (FontBridge fontBridge : controller.fonts.values()) {
                fontManager.unpublish(Priority.DEFAULT, (UIBridge)fontBridge);
            }
        }
    }

    private class Controller {
        public DockController controller;
        public Map<Path, ColorBridge> colors = new HashMap<Path, ColorBridge>();
        public Map<Path, FontBridge> fonts = new HashMap<Path, FontBridge>();

        private Controller() {
        }
    }
}

