/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.intern.theme;

import bibliothek.extension.gui.dock.theme.BubbleTheme;
import bibliothek.gui.DockController;
import bibliothek.gui.DockTheme;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.intern.color.BubbleButtonTitleTransmitter;
import bibliothek.gui.dock.common.intern.color.BubbleDisplayerTransmitter;
import bibliothek.gui.dock.common.intern.color.BubbleTabTransmitter;
import bibliothek.gui.dock.common.intern.color.BubbleTitleTransmitter;
import bibliothek.gui.dock.common.intern.theme.CDockTheme;
import bibliothek.gui.dock.themes.ColorBridgeFactory;
import bibliothek.gui.dock.themes.NoStackTheme;
import bibliothek.gui.dock.themes.color.DisplayerColor;
import bibliothek.gui.dock.themes.color.TabColor;
import bibliothek.gui.dock.themes.color.TitleColor;
import bibliothek.gui.dock.util.DockUtilities;
import bibliothek.gui.dock.util.IconManager;
import bibliothek.gui.dock.util.color.ColorBridge;
import bibliothek.gui.dock.util.color.ColorManager;
import java.util.Map;
import javax.swing.Icon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CBubbleTheme
extends CDockTheme<BubbleTheme> {
    public CBubbleTheme(CControl cControl, BubbleTheme bubbleTheme) {
        super(bubbleTheme);
        this.init(cControl);
    }

    public CBubbleTheme(CControl cControl) {
        this(new BubbleTheme());
        this.init(cControl);
    }

    private CBubbleTheme(BubbleTheme bubbleTheme) {
        super(bubbleTheme, (DockTheme)new NoStackTheme((DockTheme)bubbleTheme));
    }

    private void init(final CControl cControl) {
        this.putColorBridgeFactory(TabColor.KIND_TAB_COLOR, new ColorBridgeFactory(){

            public ColorBridge create(ColorManager colorManager) {
                BubbleTabTransmitter bubbleTabTransmitter = new BubbleTabTransmitter(colorManager);
                bubbleTabTransmitter.setControl(cControl);
                return bubbleTabTransmitter;
            }
        });
        this.putColorBridgeFactory(TitleColor.KIND_TITLE_COLOR, new ColorBridgeFactory(){

            public ColorBridge create(ColorManager colorManager) {
                BubbleTitleTransmitter bubbleTitleTransmitter = new BubbleTitleTransmitter(colorManager);
                bubbleTitleTransmitter.setControl(cControl);
                return bubbleTitleTransmitter;
            }
        });
        this.putColorBridgeFactory(DisplayerColor.KIND_DISPLAYER_COLOR, new ColorBridgeFactory(){

            public ColorBridge create(ColorManager colorManager) {
                BubbleDisplayerTransmitter bubbleDisplayerTransmitter = new BubbleDisplayerTransmitter(colorManager);
                bubbleDisplayerTransmitter.setControl(cControl);
                return bubbleDisplayerTransmitter;
            }
        });
        this.putColorBridgeFactory(TitleColor.KIND_FLAP_BUTTON_COLOR, new ColorBridgeFactory(){

            public ColorBridge create(ColorManager colorManager) {
                BubbleButtonTitleTransmitter bubbleButtonTitleTransmitter = new BubbleButtonTitleTransmitter(colorManager);
                bubbleButtonTitleTransmitter.setControl(cControl);
                return bubbleButtonTitleTransmitter;
            }
        });
        this.initDefaultFontBridges(cControl);
    }

    @Override
    public void install(DockController dockController) {
        super.install(dockController);
        IconManager iconManager = dockController.getIcons();
        Map map = DockUtilities.loadIcons((String)"data/bibliothek/gui/dock/icons/bubble/icons.ini", (String)"data/bibliothek/gui/dock/icons/bubble/", (ClassLoader)CBubbleTheme.class.getClassLoader());
        for (Map.Entry entry : map.entrySet()) {
            iconManager.setIconTheme((String)entry.getKey(), (Icon)entry.getValue());
        }
    }

    @Override
    public void uninstall(DockController dockController) {
        super.uninstall(dockController);
        dockController.getIcons().clearThemeIcons();
    }
}

