/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.intern.color;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.common.ColorMap;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.common.intern.CommonDockable;
import bibliothek.gui.dock.common.intern.color.ColorTransmitter;
import bibliothek.gui.dock.themes.color.DisplayerColor;
import bibliothek.gui.dock.util.color.ColorManager;
import bibliothek.gui.dock.util.color.DockColor;
import bibliothek.util.Colors;
import java.awt.Color;

public class BubbleDisplayerTransmitter
extends ColorTransmitter {
    private static final String[] KEYS = new String[]{"displayer.border.high.active", "displayer.border.high.active.mouse", "displayer.border.high.inactive", "displayer.border.high.inactive.mouse", "displayer.border.low.active", "displayer.border.low.active.mouse", "displayer.border.low.inactive", "displayer.border.low.inactive.mouse"};
    private ColorManager manager;

    public BubbleDisplayerTransmitter(ColorManager colorManager) {
        super(KEYS);
        this.manager = colorManager;
    }

    protected Color get(Color color, String string, DockColor dockColor) {
        CDockable cDockable = this.getDockable(dockColor);
        return this.get(color, string, cDockable);
    }

    protected Color get(Color color, String string, CDockable cDockable) {
        if (cDockable == null) {
            return color;
        }
        ColorMap colorMap = cDockable.getColors();
        Color color2 = null;
        if (string.contains("active") && !string.contains("inactive") && (color2 = colorMap.getColor("title.background.focused")) != null) {
            color2 = this.convertFocused(color2, string);
        }
        if (color2 == null && (color2 = colorMap.getColor("title.background")) != null) {
            color2 = this.convert(color2, string);
        }
        if (color2 != null) {
            return color2;
        }
        return color;
    }

    protected void update(CDockable cDockable, String string, Color color) {
        boolean bl;
        boolean bl2 = bl = "title.background".equals(string) || "title.background.focused".equals(string);
        if (bl) {
            for (String string2 : KEYS) {
                this.set(string2, this.get((Color)this.manager.get(string2), string2, cDockable), cDockable);
            }
        }
    }

    protected Color convert(Color color, String string) {
        if (string.contains("active") && !string.contains("inactive")) {
            return this.convertFocused(Colors.diffMirror((Color)color, (double)0.2), string);
        }
        if ("displayer.border.low.inactive".equals(string)) {
            return Colors.darker((Color)color, (double)0.3);
        }
        if ("displayer.border.high.inactive".equals(string)) {
            return Colors.brighter((Color)color, (double)0.3);
        }
        if ("displayer.border.low.inactive.mouse".equals(string)) {
            return Colors.fuller((Color)Colors.darker((Color)color, (double)0.3), (double)0.3);
        }
        if ("displayer.border.high.inactive.mouse".equals(string)) {
            return Colors.fuller((Color)Colors.brighter((Color)color, (double)0.3), (double)0.3);
        }
        return color;
    }

    protected Color convertFocused(Color color, String string) {
        if ("displayer.border.low.active".equals(string)) {
            return Colors.darker((Color)color, (double)0.3);
        }
        if ("displayer.border.high.active".equals(string)) {
            return Colors.brighter((Color)color, (double)0.3);
        }
        if ("displayer.border.low.active.mouse".equals(string)) {
            return Colors.fuller((Color)Colors.darker((Color)color, (double)0.3), (double)0.3);
        }
        if ("displayer.border.high.active.mouse".equals(string)) {
            return Colors.fuller((Color)Colors.brighter((Color)color, (double)0.3), (double)0.3);
        }
        return color;
    }

    protected CDockable getDockable(DockColor dockColor) {
        Dockable dockable = ((DisplayerColor)dockColor).getDisplayer().getDockable();
        if (dockable == null) {
            return null;
        }
        if (dockable instanceof CommonDockable) {
            return ((CommonDockable)dockable).getDockable();
        }
        return null;
    }
}

