/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.intern.action;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.actions.SimpleButtonAction;
import bibliothek.gui.dock.action.actions.SimpleDropDownItemAction;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.common.intern.CommonDockable;
import bibliothek.gui.dock.common.intern.action.CDropDownItem;
import bibliothek.gui.dock.event.IconManagerListener;
import bibliothek.gui.dock.support.util.Resources;
import bibliothek.gui.dock.util.IconManager;
import bibliothek.gui.dock.util.PropertyKey;
import bibliothek.gui.dock.util.PropertyValue;
import java.awt.event.KeyEvent;
import javax.swing.Icon;
import javax.swing.KeyStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CExtendedModeAction
extends CDropDownItem {
    private CDockable.ExtendedMode mode;
    private String iconKey;
    private String defaultIconKey;
    private IconManagerListener iconListener = new IconManagerListener(){

        public void iconChanged(String string, Icon icon) {
            CExtendedModeAction.this.setIcon(icon);
        }
    };
    private PropertyValue<KeyStroke> stroke;
    private CControl control;
    private Action action = new Action();
    private DockController controller;

    protected CExtendedModeAction(CControl cControl, CDockable.ExtendedMode extendedMode, String string, String string2, PropertyKey<KeyStroke> propertyKey) {
        super((SimpleDropDownItemAction)null);
        this.init((SimpleDropDownItemAction)this.action);
        if (cControl == null) {
            throw new NullPointerException("control is null");
        }
        if (extendedMode == null) {
            throw new NullPointerException("mode is null");
        }
        if (string == null) {
            throw new NullPointerException("defaultIconKey is null");
        }
        if (string2 == null) {
            throw new NullPointerException("iconKey is null");
        }
        if (propertyKey == null) {
            throw new NullPointerException("gotoStroke is null");
        }
        this.control = cControl;
        this.mode = extendedMode;
        this.iconKey = string2;
        this.defaultIconKey = string;
        this.stroke = new PropertyValue<KeyStroke>(propertyKey){

            protected void valueChanged(KeyStroke keyStroke, KeyStroke keyStroke2) {
                CExtendedModeAction.this.setAccelerator(keyStroke2);
            }
        };
    }

    @Override
    public void setIcon(Icon icon) {
        if (icon == null) {
            icon = Resources.getIcon(this.defaultIconKey);
        }
        super.setIcon(icon);
    }

    protected void setController(DockController dockController) {
        IconManager iconManager;
        if (this.controller != null) {
            iconManager = this.controller.getIcons();
            iconManager.remove(this.iconKey, this.iconListener);
            this.setIcon(null);
        }
        this.controller = dockController;
        this.stroke.setProperties(dockController);
        if (dockController != null) {
            iconManager = dockController.getIcons();
            iconManager.add(this.iconKey, this.iconListener);
            this.setIcon(iconManager.getIcon(this.iconKey));
        }
    }

    protected DockController getController() {
        return this.controller;
    }

    protected boolean checkTrigger(KeyEvent keyEvent) {
        return true;
    }

    public void action(CDockable cDockable) {
        cDockable.setExtendedMode(this.mode);
    }

    private class Action
    extends SimpleButtonAction {
        private int count = 0;

        private Action() {
        }

        protected boolean trigger(KeyEvent keyEvent, Dockable dockable) {
            if (CExtendedModeAction.this.checkTrigger(keyEvent)) {
                return super.trigger(keyEvent, dockable);
            }
            return false;
        }

        public void action(Dockable dockable) {
            if (dockable instanceof CommonDockable) {
                CExtendedModeAction.this.action(((CommonDockable)dockable).getDockable());
            }
        }

        protected void bound(Dockable dockable) {
            super.bound(dockable);
            if (this.count == 0) {
                CExtendedModeAction.this.setController(CExtendedModeAction.this.control.intern().getController());
            }
            ++this.count;
        }

        protected void unbound(Dockable dockable) {
            super.unbound(dockable);
            --this.count;
            if (this.count == 0) {
                CExtendedModeAction.this.setController(null);
            }
        }
    }
}

