/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.intern;

import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.accept.DockAcceptance;
import bibliothek.gui.dock.common.CStation;
import bibliothek.gui.dock.common.intern.CControlAccess;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.common.intern.CommonDockable;
import java.util.HashMap;

public class WorkingAreaAcceptance
implements DockAcceptance {
    private CControlAccess control;

    public WorkingAreaAcceptance(CControlAccess cControlAccess) {
        this.control = cControlAccess;
    }

    public boolean accept(DockStation dockStation, Dockable dockable) {
        if (this.control.getStateManager().isOnTransition()) {
            return true;
        }
        if (this.control.getStateManager().childsExtendedMode(dockStation) == CDockable.ExtendedMode.NORMALIZED) {
            CStation cStation = this.searchArea((DockElement)dockStation);
            return this.match(cStation, dockable);
        }
        return true;
    }

    public boolean accept(DockStation dockStation, Dockable dockable, Dockable dockable2) {
        if (this.control.getStateManager().isOnTransition()) {
            return true;
        }
        if (this.control.getStateManager().childsExtendedMode(dockStation) == CDockable.ExtendedMode.NORMALIZED) {
            CStation cStation = this.searchArea((DockElement)dockStation);
            return this.match(cStation, dockable2);
        }
        return true;
    }

    private CStation searchArea(DockElement dockElement) {
        CStation cStation2;
        HashMap<DockStation, CStation> hashMap = new HashMap<DockStation, CStation>();
        for (CStation cStation2 : this.control.getOwner().getStations()) {
            if (!cStation2.isWorkingArea()) continue;
            hashMap.put(cStation2.getStation(), cStation2);
        }
        DockStation dockStation = dockElement.asDockStation();
        cStation2 = dockElement.asDockable();
        while (cStation2 != null || dockStation != null) {
            CStation cStation3;
            if (dockStation != null && (cStation3 = (CStation)hashMap.get(dockStation)) != null) {
                return cStation3;
            }
            cStation2 = dockStation == null ? null : dockStation.asDockable();
            dockStation = cStation2 == null ? null : cStation2.getDockParent();
        }
        return null;
    }

    private boolean match(CStation cStation, Dockable dockable) {
        Object object;
        CStation cStation2;
        if (dockable instanceof CommonDockable && (cStation2 = (object = ((CommonDockable)dockable).getDockable()).getWorkingArea()) != cStation) {
            return false;
        }
        object = dockable.asDockStation();
        if (object != null) {
            if (dockable instanceof CommonDockable && (cStation2 = ((CommonDockable)dockable).getStation()) != null && cStation2.isWorkingArea()) {
                return true;
            }
            return this.match(cStation, (DockStation)object);
        }
        return true;
    }

    private boolean match(CStation cStation, DockStation dockStation) {
        int n = dockStation.getDockableCount();
        for (int i = 0; i < n; ++i) {
            boolean bl = this.match(cStation, dockStation.getDockable(i));
            if (bl) continue;
            return false;
        }
        return true;
    }
}

