/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.intern;

import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.common.action.CAction;
import bibliothek.gui.dock.common.intern.AbstractCDockable;
import bibliothek.gui.dock.common.intern.CControlAccess;
import bibliothek.gui.dock.common.intern.DefaultCommonDockable;
import bibliothek.gui.dock.common.intern.action.CSeparator;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import javax.swing.Icon;

public class DefaultCDockable
extends AbstractCDockable {
    private boolean minimizable;
    private boolean maximizable;
    private boolean externalizable;
    private boolean closeable;
    private boolean stackable;
    private DefaultCommonDockable dockable = new DefaultCommonDockable(this, new DockActionSource[]{this.getClose()});

    public DefaultCDockable() {
        this(Permissions.DEFAULT);
    }

    public DefaultCDockable(Permissions permissions) {
        super(null);
        this.init(this.dockable);
        this.setMinimizable(permissions.isMinimizable());
        this.setMaximizable(permissions.isMaximizable());
        this.setExternalizable(permissions.isExternalizable());
        this.setStackable(permissions.isStackable());
        this.setCloseable(permissions.isCloseable());
    }

    public Container getContentPane() {
        return this.dockable.getContentPane();
    }

    public void setLayout(LayoutManager layoutManager) {
        this.getContentPane().setLayout(layoutManager);
    }

    public void add(Component component) {
        this.getContentPane().add(component);
    }

    public void add(Component component, Object object) {
        this.getContentPane().add(component, object);
    }

    public void remove(Component component) {
        this.getContentPane().remove(component);
    }

    public void setTitleText(String string) {
        this.dockable.setTitleText(string);
    }

    public String getTitleText() {
        return this.dockable.getTitleText();
    }

    public void setTitleToolTip(String string) {
        this.dockable.setTitleToolTip(string);
    }

    public String getTitleToolTip() {
        return this.dockable.getTitleToolTip();
    }

    public void setTitleIcon(Icon icon) {
        this.dockable.setTitleIcon(icon);
    }

    public Icon getTitleIcon() {
        return this.dockable.getTitleIcon();
    }

    public boolean isMinimizable() {
        return this.minimizable;
    }

    public void setMinimizable(boolean bl) {
        if (this.minimizable != bl) {
            this.minimizable = bl;
            this.listenerCollection.getCDockablePropertyListener().minimizableChanged(this);
            CControlAccess cControlAccess = this.control();
            if (cControlAccess != null) {
                cControlAccess.getStateManager().rebuild(this.dockable);
                cControlAccess.getStateManager().ensureValidLocation(this);
            }
        }
    }

    public boolean isMaximizable() {
        return this.maximizable;
    }

    public void setMaximizable(boolean bl) {
        if (this.maximizable != bl) {
            this.maximizable = bl;
            this.listenerCollection.getCDockablePropertyListener().maximizableChanged(this);
            CControlAccess cControlAccess = this.control();
            if (cControlAccess != null) {
                cControlAccess.getStateManager().rebuild(this.dockable);
                cControlAccess.getStateManager().ensureValidLocation(this);
            }
        }
    }

    public boolean isExternalizable() {
        return this.externalizable;
    }

    public void setExternalizable(boolean bl) {
        if (this.externalizable != bl) {
            this.externalizable = bl;
            this.listenerCollection.getCDockablePropertyListener().externalizableChanged(this);
            CControlAccess cControlAccess = this.control();
            if (cControlAccess != null) {
                cControlAccess.getStateManager().rebuild(this.dockable);
                cControlAccess.getStateManager().ensureValidLocation(this);
            }
        }
    }

    public boolean isCloseable() {
        return this.closeable;
    }

    public void setStackable(boolean bl) {
        this.stackable = bl;
    }

    public boolean isStackable() {
        return this.stackable;
    }

    public void setCloseable(boolean bl) {
        if (this.closeable != bl) {
            this.closeable = bl;
            this.listenerCollection.getCDockablePropertyListener().closeableChanged(this);
        }
    }

    public void addAction(CAction cAction) {
        this.dockable.getActions().add(new DockAction[]{cAction.intern()});
    }

    public void insertAction(int n, CAction cAction) {
        this.dockable.getActions().add(n, new DockAction[]{cAction.intern()});
    }

    public void addSeparator() {
        this.addAction(CSeparator.SEPARATOR);
    }

    public void insertSeparator(int n) {
        this.insertAction(n, CSeparator.SEPARATOR);
    }

    public void removeAction(int n) {
        this.dockable.getActions().remove(n);
    }

    public void removeAction(CAction cAction) {
        this.dockable.getActions().remove(cAction.intern());
    }

    public DefaultCommonDockable intern() {
        return this.dockable;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Permissions {
        NONE(false, false, false, false, false),
        ALL(true, true, true, true, true),
        DEFAULT(true, true, true, true, false),
        MIN(true, false, false, false, false),
        MAX(false, true, false, false, false),
        EXT(false, false, true, false, false),
        STACK(false, false, false, true, false),
        CLOSE(false, false, false, false, true),
        MIN_MAX(true, true, false, false, false),
        MIN_EXT(true, false, true, false, false),
        MIN_STACK(true, false, false, true, false),
        MIN_CLOSE(true, false, false, false, true),
        MAX_EXT(false, true, true, false, false),
        MAX_STACK(false, true, false, true, false),
        MAX_CLOSE(false, true, false, false, true),
        EXT_STACK(false, false, true, true, false),
        EXT_CLOSE(false, false, true, false, true),
        STACK_CLOSE(false, false, false, true, true),
        MIN_MAX_EXT(true, true, true, false, false),
        MIN_MAX_STACK(true, true, false, true, true),
        MIN_MAX_CLOSE(true, true, false, false, true),
        MIN_EXT_STACK(true, false, true, true, false),
        MIN_EXT_CLOSE(true, false, true, false, true),
        MIN_STACK_CLOSE(true, false, false, true, true),
        MAX_EXT_STACK(false, true, true, true, false),
        MAX_EXT_CLOSE(false, true, true, false, true),
        MAX_STACK_CLOSE(false, true, false, true, true),
        MIN_MAX_EXT_STACK(true, true, true, true, false),
        MIN_MAX_EXT_CLOSE(true, true, true, false, true),
        MIN_MAX_STACK_CLOSE(true, true, false, true, true),
        MIN_EXT_STACK_CLOSE(true, false, true, true, true),
        MAX_EXT_STACK_CLOSE(false, true, true, true, true),
        MIN_MAX_EXT_STACK_CLOSE(true, true, true, true, true);

        private boolean minimizable;
        private boolean maximizable;
        private boolean externalizable;
        private boolean stackable;
        private boolean closeable;

        private Permissions(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
            this.minimizable = bl;
            this.maximizable = bl2;
            this.externalizable = bl3;
            this.stackable = bl4;
            this.closeable = bl5;
        }

        public boolean isCloseable() {
            return this.closeable;
        }

        public boolean isExternalizable() {
            return this.externalizable;
        }

        public boolean isMaximizable() {
            return this.maximizable;
        }

        public boolean isMinimizable() {
            return this.minimizable;
        }

        public boolean isStackable() {
            return this.stackable;
        }
    }
}

