/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.intern;

import bibliothek.gui.dock.common.CContentArea;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.CStation;
import bibliothek.gui.dock.common.MultipleCDockable;
import bibliothek.gui.dock.common.MultipleCDockableFactory;
import bibliothek.gui.dock.common.SingleCDockable;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.common.intern.CommonMultipleDockableFactory;
import bibliothek.gui.dock.common.intern.CommonSingleDockableFactory;
import bibliothek.gui.dock.common.intern.MutableCControlRegister;
import bibliothek.gui.dock.frontend.FrontendEntry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultCControlRegister
implements MutableCControlRegister {
    private CControl control;
    private CContentArea content;
    private List<CContentArea> contents = new ArrayList<CContentArea>();
    private CommonSingleDockableFactory backupFactory;
    private Map<String, CommonMultipleDockableFactory> factories = new HashMap<String, CommonMultipleDockableFactory>();
    private List<CDockable> dockables = new ArrayList<CDockable>();
    private List<SingleCDockable> singleDockables = new ArrayList<SingleCDockable>();
    private List<MultipleCDockable> multiDockables = new ArrayList<MultipleCDockable>();
    private List<CStation> stations = new ArrayList<CStation>();

    public DefaultCControlRegister(CControl cControl) {
        this.control = cControl;
        this.backupFactory = new CommonSingleDockableFactory(cControl);
    }

    @Override
    public CControl getControl() {
        return this.control;
    }

    @Override
    public List<CDockable> getDockables() {
        return Collections.unmodifiableList(this.dockables);
    }

    @Override
    public List<MultipleCDockable> getMultipleDockables() {
        return Collections.unmodifiableList(this.multiDockables);
    }

    @Override
    public List<SingleCDockable> getSingleDockables() {
        return Collections.unmodifiableList(this.singleDockables);
    }

    @Override
    public List<CStation> getStations() {
        return Collections.unmodifiableList(this.stations);
    }

    @Override
    public List<CContentArea> getContentAreas() {
        return Collections.unmodifiableList(this.contents);
    }

    @Override
    public void addContentArea(CContentArea cContentArea) {
        if (cContentArea == null) {
            throw new NullPointerException("area is null");
        }
        if (this.contents.contains(cContentArea)) {
            throw new IllegalArgumentException("area already registered");
        }
    }

    @Override
    public Set<String> listSingleBackupFactories() {
        return this.backupFactory.getFactoryIds();
    }

    @Override
    public Set<String> listMultipleDockableFactories() {
        return this.factories.keySet();
    }

    @Override
    public List<MultipleCDockable> listMultipleDockables(MultipleCDockableFactory<?, ?> multipleCDockableFactory) {
        ArrayList<MultipleCDockable> arrayList = new ArrayList<MultipleCDockable>();
        for (MultipleCDockable multipleCDockable : this.multiDockables) {
            if (multipleCDockable.getFactory() != multipleCDockableFactory) continue;
            arrayList.add(multipleCDockable);
        }
        return arrayList;
    }

    @Override
    public List<CDockable> listDockablesInMode(CDockable.ExtendedMode extendedMode) {
        ArrayList<CDockable> arrayList = new ArrayList<CDockable>();
        for (CDockable cDockable : this.dockables) {
            if (!cDockable.isVisible() || cDockable.getExtendedMode() != extendedMode) continue;
            arrayList.add(cDockable);
        }
        return arrayList;
    }

    @Override
    public Set<String> listSingleDockables() {
        HashSet<String> hashSet = new HashSet<String>();
        for (FrontendEntry frontendEntry : this.control.intern().listFrontendEntries()) {
            String string = frontendEntry.getKey();
            if (!this.isSingleId(string)) continue;
            hashSet.add(this.singleToNormalId(string));
        }
        return hashSet;
    }

    @Override
    public String toSingleId(String string) {
        return "single " + string;
    }

    @Override
    public boolean isSingleId(String string) {
        return string.startsWith("single ");
    }

    @Override
    public String singleToNormalId(String string) {
        return string.substring(7);
    }

    @Override
    public String toMultiId(String string) {
        return "multi " + string;
    }

    @Override
    public boolean isMultiId(String string) {
        return string.startsWith("multi ");
    }

    @Override
    public String multiToNormalId(String string) {
        return string.substring(6);
    }

    @Override
    public void addMultipleDockable(MultipleCDockable multipleCDockable) {
        this.dockables.add(multipleCDockable);
        this.multiDockables.add(multipleCDockable);
    }

    @Override
    public void addSingleDockable(SingleCDockable singleCDockable) {
        this.dockables.add(singleCDockable);
        this.singleDockables.add(singleCDockable);
    }

    @Override
    public void addStation(CStation cStation) {
        this.stations.add(cStation);
    }

    @Override
    public CommonSingleDockableFactory getBackupFactory() {
        return this.backupFactory;
    }

    @Override
    public CommonMultipleDockableFactory getCommonMultipleDockableFactory(String string) {
        return this.factories.get(string);
    }

    @Override
    public CContentArea getDefaultContentArea() {
        return this.content;
    }

    @Override
    public void putCommonMultipleDockableFactory(String string, CommonMultipleDockableFactory commonMultipleDockableFactory) {
        this.factories.put(string, commonMultipleDockableFactory);
    }

    @Override
    public CommonMultipleDockableFactory removeCommonMultipleDockableFactory(String string) {
        return this.factories.remove(string);
    }

    @Override
    public boolean removeContentArea(CContentArea cContentArea) {
        return this.contents.remove(cContentArea);
    }

    @Override
    public boolean removeMultipleDockable(MultipleCDockable multipleCDockable) {
        if (this.dockables.remove(multipleCDockable)) {
            this.multiDockables.remove(multipleCDockable);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeSingleDockable(SingleCDockable singleCDockable) {
        if (this.dockables.remove(singleCDockable)) {
            this.singleDockables.remove(singleCDockable);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeStation(CStation cStation) {
        return this.stations.remove(cStation);
    }

    @Override
    public void setDefaultContentArea(CContentArea cContentArea) {
        this.content = cContentArea;
    }

    @Override
    public CDockable getDockable(int n) {
        return this.dockables.get(n);
    }

    @Override
    public int getDockableCount() {
        return this.dockables.size();
    }

    @Override
    public Map<String, MultipleCDockableFactory<?, ?>> getFactories() {
        HashMap hashMap = new HashMap();
        for (Map.Entry<String, CommonMultipleDockableFactory> entry : this.factories.entrySet()) {
            hashMap.put(entry.getKey(), entry.getValue().getFactory());
        }
        return hashMap;
    }

    @Override
    public MultipleCDockableFactory<?, ?> getFactory(String string) {
        CommonMultipleDockableFactory commonMultipleDockableFactory = this.factories.get(string);
        if (commonMultipleDockableFactory == null) {
            return null;
        }
        return commonMultipleDockableFactory.getFactory();
    }
}

