/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.intern;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockFactory;
import bibliothek.gui.dock.common.CWorkingArea;
import bibliothek.gui.dock.common.MultipleCDockable;
import bibliothek.gui.dock.common.MultipleCDockableFactory;
import bibliothek.gui.dock.common.MultipleCDockableLayout;
import bibliothek.gui.dock.common.intern.CControlAccess;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.common.intern.CommonDockable;
import bibliothek.gui.dock.common.intern.CommonDockableLayout;
import bibliothek.gui.dock.layout.DockLayoutInfo;
import bibliothek.util.Version;
import bibliothek.util.xml.XElement;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommonMultipleDockableFactory
implements DockFactory<CommonDockable, CommonDockableLayout> {
    private String id;
    private MultipleCDockableFactory<MultipleCDockable, MultipleCDockableLayout> delegate;
    private CControlAccess access;

    public CommonMultipleDockableFactory(String string, MultipleCDockableFactory<?, ?> multipleCDockableFactory, CControlAccess cControlAccess) {
        this.id = string;
        this.delegate = multipleCDockableFactory;
        this.access = cControlAccess;
    }

    public String getID() {
        return this.id;
    }

    public MultipleCDockableFactory<?, ?> getFactory() {
        return this.delegate;
    }

    public void estimateLocations(CommonDockableLayout commonDockableLayout, Map<Integer, DockLayoutInfo> map) {
    }

    public CommonDockableLayout getLayout(CommonDockable commonDockable, Map<Dockable, Integer> map) {
        MultipleCDockable multipleCDockable = (MultipleCDockable)commonDockable.getDockable();
        MultipleCDockableLayout multipleCDockableLayout = this.delegate.write(multipleCDockable);
        CommonDockableLayout commonDockableLayout = new CommonDockableLayout();
        commonDockableLayout.setLayout(multipleCDockableLayout);
        String string = this.access.access(commonDockable.getDockable()).getUniqueId();
        string = this.access.getRegister().multiToNormalId(string);
        commonDockableLayout.setId(string);
        if (commonDockable.getDockable().getWorkingArea() != null) {
            commonDockableLayout.setArea(commonDockable.getDockable().getWorkingArea().getUniqueId());
        }
        return commonDockableLayout;
    }

    public CommonDockable layout(CommonDockableLayout commonDockableLayout, Map<Integer, Dockable> map) {
        return this.layout(commonDockableLayout);
    }

    public CommonDockable layout(CommonDockableLayout commonDockableLayout) {
        MultipleCDockable multipleCDockable = this.delegate.read(commonDockableLayout.getLayout());
        if (multipleCDockable == null) {
            return null;
        }
        String string = commonDockableLayout.getId();
        MultipleCDockable multipleCDockable2 = this.access.getOwner().getMultipleDockable(string);
        if (multipleCDockable2 != null) {
            this.access.getOwner().remove(multipleCDockable2);
        }
        this.access.getOwner().add(multipleCDockable, string);
        String string2 = commonDockableLayout.getArea();
        if (string2 != null) {
            int n = this.access.getOwner().getCDockableCount();
            for (int i = 0; i < n; ++i) {
                CWorkingArea cWorkingArea;
                CDockable cDockable = this.access.getOwner().getCDockable(i);
                if (!(cDockable instanceof CWorkingArea) || !(cWorkingArea = (CWorkingArea)cDockable).getUniqueId().equals(string2)) continue;
                multipleCDockable.setWorkingArea(cWorkingArea);
                break;
            }
        }
        return multipleCDockable.intern();
    }

    public void setLayout(CommonDockable commonDockable, CommonDockableLayout commonDockableLayout, Map<Integer, Dockable> map) {
    }

    public void setLayout(CommonDockable commonDockable, CommonDockableLayout commonDockableLayout) {
    }

    public CommonDockableLayout read(DataInputStream dataInputStream) throws IOException {
        Version version = Version.read((DataInputStream)dataInputStream);
        version.checkCurrent();
        CommonDockableLayout commonDockableLayout = new CommonDockableLayout();
        commonDockableLayout.setLayout(this.delegate.create());
        commonDockableLayout.getLayout().readStream(dataInputStream);
        commonDockableLayout.setId(dataInputStream.readUTF());
        if (dataInputStream.readBoolean()) {
            commonDockableLayout.setArea(dataInputStream.readUTF());
        }
        return commonDockableLayout;
    }

    public CommonDockableLayout read(XElement xElement) {
        CommonDockableLayout commonDockableLayout = new CommonDockableLayout();
        commonDockableLayout.setLayout(this.delegate.create());
        commonDockableLayout.getLayout().readXML(xElement.getElement("multiple"));
        commonDockableLayout.setId(xElement.getElement("id").getString());
        XElement xElement2 = xElement.getElement("area");
        if (xElement2 != null) {
            commonDockableLayout.setArea(xElement2.getString());
        }
        return commonDockableLayout;
    }

    public void write(CommonDockableLayout commonDockableLayout, DataOutputStream dataOutputStream) throws IOException {
        Version.write((DataOutputStream)dataOutputStream, (Version)Version.VERSION_1_0_4);
        commonDockableLayout.getLayout().writeStream(dataOutputStream);
        dataOutputStream.writeUTF(commonDockableLayout.getId());
        if (commonDockableLayout.getArea() == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            dataOutputStream.writeUTF(commonDockableLayout.getArea());
        }
    }

    public void write(CommonDockableLayout commonDockableLayout, XElement xElement) {
        xElement.addElement("id").setString(commonDockableLayout.getId());
        if (commonDockableLayout.getArea() != null) {
            xElement.addElement("area").setString(commonDockableLayout.getArea());
        }
        commonDockableLayout.getLayout().writeXML(xElement.addElement("multiple"));
    }
}

