/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.intern;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.ScreenDockStation;
import bibliothek.gui.dock.accept.DockAcceptance;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.action.actions.SimpleButtonAction;
import bibliothek.gui.dock.common.CContentArea;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.CLocation;
import bibliothek.gui.dock.common.CMaximizeBehavior;
import bibliothek.gui.dock.common.CStation;
import bibliothek.gui.dock.common.action.CAction;
import bibliothek.gui.dock.common.event.CDockableAdapter;
import bibliothek.gui.dock.common.event.CDockablePropertyListener;
import bibliothek.gui.dock.common.intern.CControlAccess;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.common.intern.CDockableAccess;
import bibliothek.gui.dock.common.intern.CommonDockable;
import bibliothek.gui.dock.common.location.CMaximizedLocation;
import bibliothek.gui.dock.event.DockRegisterAdapter;
import bibliothek.gui.dock.event.DockRegisterListener;
import bibliothek.gui.dock.event.DoubleClickListener;
import bibliothek.gui.dock.event.KeyboardListener;
import bibliothek.gui.dock.facile.state.StateManager;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.util.DockUtilities;
import bibliothek.gui.dock.util.PropertyValue;
import bibliothek.util.container.Single;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.KeyStroke;

public class CStateManager
extends StateManager {
    private CControlAccess control;
    private CMaximizeBehavior maximizeBehavior = CMaximizeBehavior.STACKED;
    private PropertyValue<KeyStroke> keyStrokeMaximizeChange = new PropertyValue<KeyStroke>(CControl.KEY_MAXIMIZE_CHANGE){

        protected void valueChanged(KeyStroke keyStroke, KeyStroke keyStroke2) {
            if (CStateManager.this.keyStrokeMaximized.getValue() == null) {
                CStateManager.this.getIngoingAction("maxi").setAccelerator(keyStroke2);
            }
        }
    };
    private CDockablePropertyListener actionChangeListener = new CDockableAdapter(){

        public void actionChanged(CDockable cDockable, String string, CAction cAction, CAction cAction2) {
            if ("cdockable.externalize".equals(string) || "cdockable.maximize".equals(string) || "cdockable.minimize".equals(string) || "cdockable.normalize".equals(string)) {
                CStateManager.this.rebuild(cDockable.intern());
            }
        }
    };
    private PropertyValue<KeyStroke> keyStrokeMaximized = new PropertyValue<KeyStroke>(CControl.KEY_GOTO_MAXIMIZED){

        protected void valueChanged(KeyStroke keyStroke, KeyStroke keyStroke2) {
            if (keyStroke2 == null) {
                CStateManager.this.getIngoingAction("maxi").setAccelerator((KeyStroke)CStateManager.this.keyStrokeMaximizeChange.getValue());
            } else {
                CStateManager.this.getIngoingAction("maxi").setAccelerator(keyStroke2);
            }
        }
    };

    public CStateManager(CControlAccess cControlAccess) {
        super(cControlAccess.getOwner().intern().getController(), false);
        this.putIngoingAction("maxi", new SimpleButtonAction(){

            public void action(Dockable dockable) {
                super.action(dockable);
                CStateManager.this.goIn("maxi", dockable);
            }

            protected boolean trigger(KeyEvent keyEvent, Dockable dockable) {
                if (!KeyStroke.getKeyStrokeForEvent(keyEvent).equals(CStateManager.this.keyStrokeMaximizeChange.getValue())) {
                    return super.trigger(keyEvent, dockable);
                }
                return false;
            }
        });
        this.init();
        this.control = cControlAccess;
        DockController dockController = cControlAccess.getOwner().intern().getController();
        dockController.getRegister().addDockRegisterListener((DockRegisterListener)new DockRegisterAdapter(){

            public void dockableRegistered(DockController dockController, Dockable dockable) {
                new KeyHook(dockable);
            }
        });
        this.keyStrokeMaximizeChange.setProperties(dockController);
        this.keyStrokeMaximized.setProperties(dockController);
        new PropertyValue<KeyStroke>(CControl.KEY_GOTO_EXTERNALIZED, dockController){

            protected void valueChanged(KeyStroke keyStroke, KeyStroke keyStroke2) {
                CStateManager.this.getIngoingAction("extern").setAccelerator(keyStroke2);
            }
        };
        new PropertyValue<KeyStroke>(CControl.KEY_GOTO_MAXIMIZED, dockController){

            protected void valueChanged(KeyStroke keyStroke, KeyStroke keyStroke2) {
                CStateManager.this.getIngoingAction("maxi").setAccelerator(keyStroke2);
            }
        };
        new PropertyValue<KeyStroke>(CControl.KEY_GOTO_MINIMIZED, dockController){

            protected void valueChanged(KeyStroke keyStroke, KeyStroke keyStroke2) {
                CStateManager.this.getIngoingAction("mini").setAccelerator(keyStroke2);
            }
        };
        new PropertyValue<KeyStroke>(CControl.KEY_GOTO_NORMALIZED, dockController){

            protected void valueChanged(KeyStroke keyStroke, KeyStroke keyStroke2) {
                CStateManager.this.getIngoingAction("normal").setAccelerator(keyStroke2);
            }
        };
        dockController.addAcceptance(new DockAcceptance(){

            public boolean accept(DockStation dockStation, Dockable dockable) {
                if (dockStation instanceof ScreenDockStation) {
                    return this.externalizable(dockable);
                }
                return true;
            }

            public boolean accept(DockStation dockStation, Dockable dockable, Dockable dockable2) {
                if (dockStation instanceof ScreenDockStation) {
                    return this.externalizable(dockable2);
                }
                return true;
            }

            private boolean externalizable(Dockable dockable) {
                final Single single = new Single((Object)true);
                DockUtilities.visit((Dockable)dockable, (DockUtilities.DockVisitor)new DockUtilities.DockVisitor(){

                    public void handleDockable(Dockable dockable) {
                        if (dockable instanceof CommonDockable && !((CommonDockable)dockable).getDockable().isExternalizable()) {
                            single.setA((Object)false);
                        }
                    }
                });
                return (Boolean)single.getA();
            }
        });
        cControlAccess.getOwner().intern().getController().getDoubleClickController().addListener(new DoubleClickListener(){

            public DockElement getTreeLocation() {
                return null;
            }

            public boolean process(Dockable dockable, MouseEvent mouseEvent) {
                if (mouseEvent.isConsumed()) {
                    return false;
                }
                if (dockable instanceof CommonDockable) {
                    CDockable cDockable = ((CommonDockable)dockable).getDockable();
                    if (cDockable.getExtendedMode() != CDockable.ExtendedMode.MAXIMIZED) {
                        if (cDockable.isMaximizable()) {
                            cDockable.setExtendedMode(CDockable.ExtendedMode.MAXIMIZED);
                            mouseEvent.consume();
                            return true;
                        }
                    } else {
                        CStateManager.this.goOut("maxi", dockable);
                        CStateManager.this.ensureValidLocation(cDockable);
                        mouseEvent.consume();
                        return true;
                    }
                }
                return false;
            }
        });
    }

    protected Dockable getMaximizingElement(Dockable dockable) {
        return this.maximizeBehavior.getMaximizingElement(dockable);
    }

    protected Dockable getMaximizingElement(Dockable dockable, Dockable dockable2) {
        return this.maximizeBehavior.getMaximizingElement(dockable, dockable2);
    }

    protected void added(Dockable dockable) {
        super.added(dockable);
        if (dockable instanceof CommonDockable) {
            ((CommonDockable)dockable).getDockable().addCDockablePropertyListener(this.actionChangeListener);
        }
    }

    protected void removed(Dockable dockable) {
        super.removed(dockable);
        if (dockable instanceof CommonDockable) {
            ((CommonDockable)dockable).getDockable().removeCDockablePropertyListener(this.actionChangeListener);
        }
    }

    protected boolean createEntryDuringRead(String string) {
        return this.control.shouldStore(string);
    }

    public void setMaximizeBehavior(CMaximizeBehavior cMaximizeBehavior) {
        if (cMaximizeBehavior == null) {
            throw new NullPointerException("maximizeBehavior must not be null");
        }
        this.maximizeBehavior = cMaximizeBehavior;
    }

    public CMaximizeBehavior getMaximizeBehavior() {
        return this.maximizeBehavior;
    }

    public void setLocation(Dockable dockable, CDockable.ExtendedMode extendedMode, CLocation cLocation) {
        if (dockable == null) {
            throw new IllegalArgumentException("dockable must not be null");
        }
        if (extendedMode == null) {
            throw new IllegalArgumentException("mode must not be null");
        }
        if (cLocation == null) {
            throw new IllegalArgumentException("location must not be null");
        }
        String string = cLocation.findRoot();
        if (string == null) {
            throw new IllegalArgumentException("the location is not sufficient to find the root station");
        }
        DockableProperty dockableProperty = cLocation.findProperty();
        if (dockableProperty == null) {
            throw new IllegalArgumentException("the location does not carry enough information to find the location of dockable");
        }
        this.setProperties(this.convertMode(extendedMode), dockable, new StateManager.Location(string, dockableProperty));
    }

    public CLocation getLocation(Dockable dockable, CDockable.ExtendedMode extendedMode) {
        if (dockable == null) {
            throw new IllegalArgumentException("dockable must not be null");
        }
        if (extendedMode == null) {
            throw new IllegalArgumentException("mode must not be null");
        }
        if (extendedMode == CDockable.ExtendedMode.MAXIMIZED) {
            return CLocation.maximized();
        }
        StateManager.Location location = (StateManager.Location)this.getProperties(this.convertMode(extendedMode), dockable);
        if (location == null) {
            return null;
        }
        List<CStation> list = this.control.getOwner().getStations();
        for (CStation cStation : list) {
            if (!cStation.getUniqueId().equals(location.getRoot())) continue;
            CLocation cLocation = cStation.getStationLocation();
            return cLocation.expandProperty(location.getLocation());
        }
        return null;
    }

    public void setMode(Dockable dockable, CDockable.ExtendedMode extendedMode) {
        switch (extendedMode) {
            case EXTERNALIZED: {
                this.setMode(dockable, "extern");
                break;
            }
            case MAXIMIZED: {
                this.setMode(dockable, "maxi");
                break;
            }
            case MINIMIZED: {
                this.setMode(dockable, "mini");
                break;
            }
            case NORMALIZED: {
                this.setMode(dockable, "normal");
            }
        }
    }

    public CDockable.ExtendedMode getMode(Dockable dockable) {
        String string = this.currentMode(dockable);
        if ("extern".equals(string)) {
            return CDockable.ExtendedMode.EXTERNALIZED;
        }
        if ("mini".equals(string)) {
            return CDockable.ExtendedMode.MINIMIZED;
        }
        if ("maxi".equals(string)) {
            return CDockable.ExtendedMode.MAXIMIZED;
        }
        if ("normal".equals(string)) {
            return CDockable.ExtendedMode.NORMALIZED;
        }
        return null;
    }

    public CDockable.ExtendedMode childsExtendedMode(DockStation dockStation) {
        String string = this.childsMode(dockStation);
        if ("extern".equals(string)) {
            return CDockable.ExtendedMode.EXTERNALIZED;
        }
        if ("mini".equals(string)) {
            return CDockable.ExtendedMode.MINIMIZED;
        }
        if ("normal".equals(string)) {
            return CDockable.ExtendedMode.NORMALIZED;
        }
        return null;
    }

    public void setLocation(CommonDockable commonDockable, CLocation cLocation) {
        String string = cLocation.findRoot();
        DockableProperty dockableProperty = cLocation.findProperty();
        CDockable.ExtendedMode extendedMode = cLocation.findMode();
        String string2 = null;
        if (string != null && extendedMode != null) {
            CStation cStation;
            Object object;
            string2 = this.convertMode(extendedMode);
            boolean bl = false;
            if (string != null && (object = this.getStation(string)) != null && (cStation = this.control.getOwner().getStation((DockStation)object)) != null && cStation.isWorkingArea()) {
                commonDockable.getDockable().setWorkingArea(cStation);
                bl = true;
                CDockable.ExtendedMode extendedMode2 = cStation.getStationLocation().findMode();
                if (extendedMode2 != null) {
                    string2 = this.convertMode(extendedMode2);
                }
            }
            if (!bl && "normal".equals(string2)) {
                commonDockable.getDockable().setWorkingArea(null);
            }
            if (extendedMode == CDockable.ExtendedMode.MAXIMIZED || dockableProperty != null) {
                object = this.currentMode(commonDockable);
                this.store((String)object, commonDockable);
                this.setProperties(string2, commonDockable, new StateManager.Location(string, dockableProperty));
                this.transition(null, string2, commonDockable);
            }
        }
    }

    protected String convertMode(CDockable.ExtendedMode extendedMode) {
        switch (extendedMode) {
            case EXTERNALIZED: {
                return "extern";
            }
            case MAXIMIZED: {
                return "maxi";
            }
            case MINIMIZED: {
                return "mini";
            }
            case NORMALIZED: {
                return "normal";
            }
        }
        return null;
    }

    protected CDockable.ExtendedMode convertMode(String string) {
        if ("extern".equals(string)) {
            return CDockable.ExtendedMode.EXTERNALIZED;
        }
        if ("maxi".equals(string)) {
            return CDockable.ExtendedMode.MAXIMIZED;
        }
        if ("normal".equals(string)) {
            return CDockable.ExtendedMode.NORMALIZED;
        }
        if ("mini".equals(string)) {
            return CDockable.ExtendedMode.MINIMIZED;
        }
        throw new IllegalArgumentException("Not the name of a mode: " + string);
    }

    public CLocation getLocation(Dockable dockable) {
        if (this.getMode(dockable) == CDockable.ExtendedMode.MAXIMIZED) {
            return new CMaximizedLocation();
        }
        List<CStation> list = this.control.getOwner().getStations();
        CStation object2 = null;
        Dockable dockable2 = dockable;
        DockStation dockStation = dockable.asDockStation();
        if (dockStation == null) {
            dockStation = dockable2.getDockParent();
        }
        block0: while (dockStation != null) {
            for (CStation object3 : list) {
                if (object3.getStation() != dockStation) continue;
                object2 = object3;
                break block0;
            }
            dockable2 = dockStation.asDockable();
            if (dockable2 == null) {
                dockStation = null;
                continue;
            }
            dockStation = dockable2.getDockParent();
        }
        if (object2 == null) {
            return null;
        }
        DockableProperty dockableProperty = DockUtilities.getPropertyChain((DockStation)object2.getStation(), (Dockable)dockable);
        CLocation cLocation = object2.getStationLocation();
        return cLocation.expandProperty(dockableProperty);
    }

    protected CStation getAreaOf(Dockable dockable) {
        CStation cStation;
        HashMap<DockStation, CStation> hashMap = new HashMap<DockStation, CStation>();
        Object object = this.control.getOwner().getStations().iterator();
        while (object.hasNext()) {
            cStation = object.next();
            if (!cStation.isWorkingArea()) continue;
            hashMap.put(cStation.getStation(), cStation);
        }
        if (dockable.asDockStation() != null && (object = (CStation)hashMap.get(dockable.asDockStation())) != null) {
            return object;
        }
        object = dockable;
        while (object != null) {
            cStation = object.getDockParent();
            object = cStation == null ? null : cStation.asDockable();
            CStation cStation2 = (CStation)hashMap.get(cStation);
            if (cStation2 == null) continue;
            return cStation2;
        }
        return null;
    }

    protected boolean isValidNormalized(Dockable dockable) {
        if (!super.isValidNormalized(dockable)) {
            return false;
        }
        if (dockable instanceof CommonDockable) {
            CStation cStation;
            CDockable cDockable = ((CommonDockable)dockable).getDockable();
            CStation cStation2 = this.getAreaOf(dockable);
            return cStation2 == (cStation = cDockable.getWorkingArea());
        }
        return true;
    }

    protected CContentArea getCenterOf(Dockable dockable) {
        DockStation dockStation = DockUtilities.getRoot((DockElement)dockable);
        if (dockStation == null) {
            return null;
        }
        for (CContentArea cContentArea : this.control.getOwner().getContentAreas()) {
            if (cContentArea.getCenter() == dockStation) {
                return cContentArea;
            }
            if (cContentArea.getEast() == dockStation) {
                return cContentArea;
            }
            if (cContentArea.getWest() == dockStation) {
                return cContentArea;
            }
            if (cContentArea.getNorth() == dockStation) {
                return cContentArea;
            }
            if (cContentArea.getSouth() != dockStation) continue;
            return cContentArea;
        }
        return null;
    }

    protected String[] availableModes(String string, Dockable dockable) {
        if (!(dockable instanceof CommonDockable)) {
            return new String[0];
        }
        CDockable cDockable = ((CommonDockable)dockable).getDockable();
        ArrayList<String> arrayList = new ArrayList<String>(4);
        if (!"mini".equals(string) && cDockable.isMinimizable()) {
            arrayList.add("mini");
        }
        if (!"normal".equals(string)) {
            arrayList.add("normal");
        }
        if (!"maxi".equals(string) && cDockable.isMaximizable()) {
            arrayList.add("maxi");
        }
        if (!"extern".equals(string) && cDockable.isExternalizable()) {
            arrayList.add("extern");
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public void ensureValidLocation(CDockable cDockable) {
        boolean bl;
        CDockable.ExtendedMode extendedMode = this.getMode(cDockable.intern());
        if (extendedMode == CDockable.ExtendedMode.NORMALIZED) {
            CStation cStation;
            CStation cStation2 = cDockable.getWorkingArea();
            if (cStation2 != (cStation = this.findFirstParentWorkingArea(cDockable.intern()))) {
                if (cStation2 == null) {
                    cDockable.setLocation(CLocation.base().normalRectangle(0.25, 0.25, 0.5, 0.5));
                } else {
                    cDockable.setLocation(cStation2.getStationLocation());
                }
            }
            extendedMode = this.getMode(cDockable.intern());
        }
        boolean bl2 = bl = extendedMode == CDockable.ExtendedMode.EXTERNALIZED && !cDockable.isExternalizable() || extendedMode == CDockable.ExtendedMode.MAXIMIZED && !cDockable.isMaximizable() || extendedMode == CDockable.ExtendedMode.MINIMIZED && !cDockable.isMinimizable();
        if (bl) {
            this.setMode((Dockable)cDockable.intern(), CDockable.ExtendedMode.NORMALIZED);
        }
    }

    private CStation findFirstParentWorkingArea(Dockable dockable) {
        DockStation dockStation = dockable.getDockParent();
        Dockable dockable2 = dockable = dockStation == null ? null : dockStation.asDockable();
        if (dockable != null) {
            return this.getAreaOf(dockable);
        }
        return null;
    }

    public void normalizeAllWorkingAreaChildren() {
        for (Dockable dockable : this.control.getOwner().intern().getController().getRegister().listDockables()) {
            CDockable cDockable;
            if (!(dockable instanceof CommonDockable) || (cDockable = ((CommonDockable)dockable).getDockable()).getWorkingArea() == null) continue;
            CDockable.ExtendedMode extendedMode = cDockable.getWorkingArea().getStationLocation().findMode();
            if (extendedMode == null) {
                extendedMode = CDockable.ExtendedMode.NORMALIZED;
            }
            if (extendedMode.equals((Object)cDockable.getExtendedMode())) continue;
            cDockable.setExtendedMode(extendedMode);
        }
    }

    protected void modeChanged(Dockable dockable, String string, String string2) {
        CDockable cDockable;
        CDockableAccess cDockableAccess;
        if (string2 != null && !string2.equals(string) && dockable instanceof CommonDockable && (cDockableAccess = this.control.access(cDockable = ((CommonDockable)dockable).getDockable())) != null) {
            CDockable.ExtendedMode extendedMode = this.convertMode(string2);
            cDockableAccess.informMode(extendedMode);
        }
    }

    protected DockStation getDefaultNormal(Dockable dockable) {
        CDockable cDockable;
        if (dockable instanceof CommonDockable && (cDockable = ((CommonDockable)dockable).getDockable()).getWorkingArea() != null) {
            CDockable.ExtendedMode extendedMode = cDockable.getWorkingArea().getStationLocation().findMode();
            if (extendedMode != CDockable.ExtendedMode.NORMALIZED) {
                return null;
            }
            return cDockable.getWorkingArea().getStation();
        }
        return super.getDefaultNormal(dockable);
    }

    public DockAction getIngoingAction(String string, Dockable dockable) {
        if (dockable instanceof CommonDockable) {
            CDockable cDockable = ((CommonDockable)dockable).getDockable();
            CAction cAction = null;
            if ("mini".equals(string)) {
                cAction = cDockable.getAction("cdockable.minimize");
            } else if ("maxi".equals(string)) {
                cAction = cDockable.getAction("cdockable.maximize");
            } else if ("extern".equals(string)) {
                cAction = cDockable.getAction("cdockable.externalize");
            } else if ("normal".equals(string)) {
                cAction = cDockable.getAction("cdockable.normalize");
            }
            if (cAction != null) {
                return cAction.intern();
            }
        }
        return super.getIngoingAction(string, dockable);
    }

    public void rebuild(Dockable dockable) {
        super.rebuild(dockable);
    }

    protected boolean process(Dockable dockable, KeyEvent keyEvent) {
        if (dockable instanceof CommonDockable) {
            CDockable cDockable = ((CommonDockable)dockable).getDockable();
            KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(keyEvent);
            if (keyStroke.equals(this.keyStrokeMaximizeChange.getValue())) {
                if (cDockable.getExtendedMode() == CDockable.ExtendedMode.MAXIMIZED) {
                    this.goOut("maxi", dockable);
                    return true;
                }
                if (cDockable.isMaximizable()) {
                    cDockable.setExtendedMode(CDockable.ExtendedMode.MAXIMIZED);
                    return true;
                }
            }
        }
        return false;
    }

    private class KeyHook
    extends DockRegisterAdapter
    implements KeyboardListener {
        private Dockable dockable;

        public KeyHook(Dockable dockable) {
            this.dockable = dockable;
            DockController dockController = CStateManager.this.control.getOwner().intern().getController();
            dockController.getKeyboardController().addListener((KeyboardListener)this);
            dockController.getRegister().addDockRegisterListener((DockRegisterListener)this);
        }

        public void dockableUnregistered(DockController dockController, Dockable dockable) {
            if (this.dockable == dockable) {
                dockController.getKeyboardController().removeListener((KeyboardListener)this);
                dockController.getRegister().removeDockRegisterListener((DockRegisterListener)this);
            }
        }

        public DockElement getTreeLocation() {
            return this.dockable;
        }

        public boolean keyPressed(DockElement dockElement, KeyEvent keyEvent) {
            return CStateManager.this.process(this.dockable, keyEvent);
        }

        public boolean keyReleased(DockElement dockElement, KeyEvent keyEvent) {
            return CStateManager.this.process(this.dockable, keyEvent);
        }

        public boolean keyTyped(DockElement dockElement, KeyEvent keyEvent) {
            return CStateManager.this.process(this.dockable, keyEvent);
        }
    }
}

