/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.intern;

import bibliothek.gui.DockStation;
import bibliothek.gui.dock.common.CLocation;
import bibliothek.gui.dock.common.CStation;
import bibliothek.gui.dock.common.intern.CControlAccess;
import bibliothek.gui.dock.common.intern.CDockable;

public abstract class AbstractCStation
implements CStation {
    private CLocation location;
    private String id;
    private DockStation station;
    private CControlAccess control;

    public AbstractCStation(DockStation dockStation, String string, CLocation cLocation) {
        this.init(dockStation, string, cLocation);
    }

    protected AbstractCStation() {
    }

    protected void init(DockStation dockStation, String string, CLocation cLocation) {
        if (dockStation == null) {
            throw new IllegalArgumentException("station must not be null");
        }
        if (string == null) {
            throw new IllegalArgumentException("id must not be null");
        }
        if (cLocation == null) {
            throw new IllegalArgumentException("location must not be null");
        }
        this.station = dockStation;
        this.id = string;
        this.location = cLocation;
    }

    public CLocation getStationLocation() {
        return this.location;
    }

    public String getUniqueId() {
        return this.id;
    }

    public DockStation getStation() {
        return this.station;
    }

    public void setControl(CControlAccess cControlAccess) {
        if (this.control != cControlAccess) {
            if (this.control != null) {
                this.uninstall(this.control);
            }
            this.control = cControlAccess;
            if (this.control != null) {
                this.install(this.control);
            }
        }
    }

    protected CControlAccess getControl() {
        return this.control;
    }

    public boolean isWorkingArea() {
        return false;
    }

    public CDockable asDockable() {
        return null;
    }

    protected abstract void install(CControlAccess var1);

    protected abstract void uninstall(CControlAccess var1);
}

