/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.intern;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.common.CLocation;
import bibliothek.gui.dock.common.CStation;
import bibliothek.gui.dock.common.ColorMap;
import bibliothek.gui.dock.common.FontMap;
import bibliothek.gui.dock.common.action.CAction;
import bibliothek.gui.dock.common.event.CDockablePropertyListener;
import bibliothek.gui.dock.common.event.CDockableStateListener;
import bibliothek.gui.dock.common.event.CDoubleClickListener;
import bibliothek.gui.dock.common.event.CFocusListener;
import bibliothek.gui.dock.common.event.CKeyboardListener;
import bibliothek.gui.dock.common.intern.CControlAccess;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.common.intern.CDockableAccess;
import bibliothek.gui.dock.common.intern.CListenerCollection;
import bibliothek.gui.dock.common.intern.CStateManager;
import bibliothek.gui.dock.common.intern.CommonDockable;
import bibliothek.gui.dock.common.intern.action.CloseActionSource;
import bibliothek.gui.dock.common.layout.RequestDimension;
import java.awt.Dimension;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractCDockable
implements CDockable {
    private CLocation location = null;
    private CommonDockable dockable;
    private CStation workingArea;
    private CControlAccess control;
    private String uniqueId;
    private boolean resizeLockedVertically = false;
    private boolean resizeLockedHorizontally = false;
    private boolean minimizeHold = false;
    private Dimension minimizeSize = new Dimension(-1, -1);
    private RequestDimension resizeRequest;
    private ColorMap colors = new ColorMap(this);
    private FontMap fonts = new FontMap(this);
    private Map<String, CAction> actions = new HashMap<String, CAction>();
    private boolean titleShown = true;
    protected CListenerCollection listenerCollection = new CListenerCollection();
    private CloseActionSource close = new CloseActionSource(this);
    private Map<CDockable.ExtendedMode, CLocation> defaultLocations = new HashMap<CDockable.ExtendedMode, CLocation>(4);

    protected AbstractCDockable(CommonDockable commonDockable) {
        this.dockable = commonDockable;
    }

    protected void init(CommonDockable commonDockable) {
        if (this.dockable != null) {
            throw new IllegalStateException("dockable already set");
        }
        if (commonDockable == null) {
            throw new NullPointerException("dockable is null");
        }
        this.dockable = commonDockable;
    }

    protected CloseActionSource getClose() {
        return this.close;
    }

    protected CControlAccess control() {
        return this.control;
    }

    public void addCDockableStateListener(CDockableStateListener cDockableStateListener) {
        this.listenerCollection.addCDockableStateListener(cDockableStateListener);
    }

    public void addCDockablePropertyListener(CDockablePropertyListener cDockablePropertyListener) {
        this.listenerCollection.addCDockablePropertyListener(cDockablePropertyListener);
    }

    public void removeCDockableStateListener(CDockableStateListener cDockableStateListener) {
        this.listenerCollection.removeCDockableStateListener(cDockableStateListener);
    }

    public void removeCDockablePropertyListener(CDockablePropertyListener cDockablePropertyListener) {
        this.listenerCollection.removeCDockablePropertyListener(cDockablePropertyListener);
    }

    public void addFocusListener(CFocusListener cFocusListener) {
        this.listenerCollection.addFocusListener(cFocusListener);
    }

    public void removeFocusListener(CFocusListener cFocusListener) {
        this.listenerCollection.removeFocusListener(cFocusListener);
    }

    public void addKeyboardListener(CKeyboardListener cKeyboardListener) {
        this.listenerCollection.addKeyboardListener(cKeyboardListener);
    }

    public void removeKeyboardListener(CKeyboardListener cKeyboardListener) {
        this.listenerCollection.removeKeyboardListener(cKeyboardListener);
    }

    public void addDoubleClickListener(CDoubleClickListener cDoubleClickListener) {
        this.listenerCollection.addDoubleClickListener(cDoubleClickListener);
    }

    public void removeDoubleClickListener(CDoubleClickListener cDoubleClickListener) {
        this.listenerCollection.removeDoubleClickListener(cDoubleClickListener);
    }

    @Deprecated
    protected CDockableStateListener[] stateListeners() {
        return this.listenerCollection.getCDockableStateListeners();
    }

    @Deprecated
    protected CDockablePropertyListener[] propertyListeners() {
        return this.listenerCollection.getCDockablePropertyListeners();
    }

    public void setVisible(boolean bl) {
        if (this.control == null) {
            throw new IllegalStateException("This CDockable does not know its CControl. Call CControl.add(...) to connect this CDockable befor calling setVisible(...).");
        }
        if (bl) {
            this.control.show(this);
        } else {
            this.control.hide(this);
        }
    }

    public boolean isVisible() {
        if (this.control == null) {
            return false;
        }
        return this.control.isVisible(this);
    }

    public void toFront() {
        if (this.isVisible()) {
            this.control.getOwner().intern().getController().setFocusedDockable((Dockable)this.intern(), false);
        }
    }

    public void setLocation(CLocation cLocation) {
        this.location = cLocation;
        if (cLocation != null && this.control != null && this.isVisible()) {
            this.control.getStateManager().setLocation(this.dockable, cLocation);
            this.location = null;
        }
    }

    public CLocation getBaseLocation() {
        if (this.control != null && this.isVisible()) {
            return this.control.getStateManager().getLocation(this.dockable);
        }
        return this.location;
    }

    public void setExtendedMode(CDockable.ExtendedMode extendedMode) {
        if (extendedMode == null) {
            throw new NullPointerException("extendedMode must not be null");
        }
        switch (extendedMode) {
            case EXTERNALIZED: {
                if (this.isExternalizable()) break;
                return;
            }
            case MAXIMIZED: {
                if (this.isMaximizable()) break;
                return;
            }
            case MINIMIZED: {
                if (this.isMinimizable()) break;
                return;
            }
        }
        CControlAccess cControlAccess = this.control();
        if (cControlAccess != null) {
            cControlAccess.getStateManager().setMode((Dockable)this.dockable, extendedMode);
        }
    }

    public CDockable.ExtendedMode getExtendedMode() {
        CControlAccess cControlAccess = this.control();
        if (cControlAccess == null) {
            return null;
        }
        return cControlAccess.getStateManager().getMode(this.dockable);
    }

    public void setWorkingArea(CStation cStation) {
        this.workingArea = cStation;
    }

    public CStation getWorkingArea() {
        return this.workingArea;
    }

    public boolean isResizeLocked() {
        return this.resizeLockedVertically && this.resizeLockedHorizontally;
    }

    public boolean isResizeLockedVertically() {
        return this.resizeLockedVertically;
    }

    public boolean isResizeLockedHorizontally() {
        return this.resizeLockedHorizontally;
    }

    public void setResizeRequest(Dimension dimension, boolean bl) {
        RequestDimension requestDimension = this.resizeRequest = dimension == null ? null : new RequestDimension(dimension);
        if (bl && this.control != null) {
            this.control.getOwner().handleResizeRequests();
        }
    }

    public void setResizeRequest(RequestDimension requestDimension, boolean bl) {
        RequestDimension requestDimension2 = this.resizeRequest = requestDimension == null ? null : new RequestDimension(requestDimension);
        if (bl && this.control != null) {
            this.control.getOwner().handleResizeRequests();
        }
    }

    public RequestDimension getAndClearResizeRequest() {
        RequestDimension requestDimension = this.resizeRequest;
        this.resizeRequest = null;
        return requestDimension;
    }

    public void setResizeLocked(boolean bl) {
        if (this.isResizeLocked() != bl) {
            this.resizeLockedHorizontally = bl;
            this.resizeLockedVertically = bl;
            this.listenerCollection.getCDockablePropertyListener().resizeLockedChanged(this);
        }
    }

    public void setResizeLockedHorizontally(boolean bl) {
        if (this.resizeLockedHorizontally != bl) {
            this.resizeLockedHorizontally = bl;
            this.listenerCollection.getCDockablePropertyListener().resizeLockedChanged(this);
        }
    }

    public void setResizeLockedVertically(boolean bl) {
        if (this.resizeLockedVertically != bl) {
            this.resizeLockedVertically = bl;
            this.listenerCollection.getCDockablePropertyListener().resizeLockedChanged(this);
        }
    }

    public void setMinimizedHold(boolean bl) {
        if (this.minimizeHold != bl) {
            this.minimizeHold = bl;
            this.listenerCollection.getCDockablePropertyListener().minimizedHoldChanged(this);
        }
    }

    public boolean isMinimizedHold() {
        return this.minimizeHold;
    }

    public void setMinimizedSize(Dimension dimension) {
        this.minimizeSize = new Dimension(dimension.width, dimension.height);
        this.listenerCollection.getCDockablePropertyListener().minimizeSizeChanged(this);
    }

    public Dimension getMinimizedSize() {
        return new Dimension(this.minimizeSize.width, this.minimizeSize.height);
    }

    public void setTitleShown(boolean bl) {
        if (this.titleShown != bl) {
            this.titleShown = bl;
            this.listenerCollection.getCDockablePropertyListener().titleShownChanged(this);
        }
    }

    public boolean isTitleShown() {
        return this.titleShown;
    }

    public CommonDockable intern() {
        return this.dockable;
    }

    public void setDefaultLocation(CDockable.ExtendedMode extendedMode, CLocation cLocation) {
        if (cLocation == null) {
            this.defaultLocations.remove((Object)extendedMode);
        } else {
            CStateManager cStateManager;
            this.defaultLocations.put(extendedMode, cLocation);
            if (this.control != null && (cStateManager = this.control.getStateManager()).getLocation(this.dockable, extendedMode) == null) {
                cStateManager.setLocation(this.dockable, extendedMode, cLocation);
            }
        }
    }

    public CLocation getDefaultLocation(CDockable.ExtendedMode extendedMode) {
        return this.defaultLocations.get((Object)extendedMode);
    }

    public void setControl(CControlAccess cControlAccess) {
        if (this.control != null) {
            this.control.getStateManager().remove(this.dockable);
            this.control.link(this, null);
        }
        this.control = cControlAccess;
        if (cControlAccess != null) {
            cControlAccess.link(this, new CDockableAccess(){

                public void informVisibility(boolean bl) {
                    AbstractCDockable.this.listenerCollection.getCDockableStateListener().visibilityChanged(AbstractCDockable.this);
                }

                public void informMode(CDockable.ExtendedMode extendedMode) {
                    CDockableStateListener cDockableStateListener = AbstractCDockable.this.listenerCollection.getCDockableStateListener();
                    switch (extendedMode) {
                        case EXTERNALIZED: {
                            cDockableStateListener.externalized(AbstractCDockable.this);
                            break;
                        }
                        case MINIMIZED: {
                            cDockableStateListener.minimized(AbstractCDockable.this);
                            break;
                        }
                        case MAXIMIZED: {
                            cDockableStateListener.maximized(AbstractCDockable.this);
                            break;
                        }
                        case NORMALIZED: {
                            cDockableStateListener.normalized(AbstractCDockable.this);
                        }
                    }
                }

                public CFocusListener getFocusListener() {
                    return AbstractCDockable.this.listenerCollection.getFocusListener();
                }

                public CKeyboardListener getKeyboardListener() {
                    return AbstractCDockable.this.listenerCollection.getKeyboardListener();
                }

                public CDoubleClickListener getDoubleClickListener() {
                    return AbstractCDockable.this.listenerCollection.getDoubleClickListener();
                }

                public void setUniqueId(String string) {
                    AbstractCDockable.this.uniqueId = string;
                    if (AbstractCDockable.this.control != null && string != null) {
                        CStateManager cStateManager = AbstractCDockable.this.control.getStateManager();
                        cStateManager.put(AbstractCDockable.this.uniqueId, AbstractCDockable.this.dockable);
                        for (Map.Entry entry : AbstractCDockable.this.defaultLocations.entrySet()) {
                            if (cStateManager.getLocation(AbstractCDockable.this.dockable, (CDockable.ExtendedMode)((Object)entry.getKey())) != null) continue;
                            cStateManager.setLocation(AbstractCDockable.this.dockable, (CDockable.ExtendedMode)((Object)entry.getKey()), (CLocation)entry.getValue());
                        }
                    }
                }

                public String getUniqueId() {
                    return AbstractCDockable.this.uniqueId;
                }

                public CLocation internalLocation() {
                    CLocation cLocation = AbstractCDockable.this.location;
                    AbstractCDockable.this.location = null;
                    return cLocation;
                }
            });
        }
        this.close.setControl(cControlAccess);
    }

    public void putAction(String string, CAction cAction) {
        CAction cAction2 = this.actions.put(string, cAction);
        if (cAction2 != cAction) {
            this.listenerCollection.getCDockablePropertyListener().actionChanged(this, string, cAction2, cAction);
        }
    }

    public CAction getAction(String string) {
        return this.actions.get(string);
    }

    public ColorMap getColors() {
        return this.colors;
    }

    public FontMap getFonts() {
        return this.fonts;
    }

    public CControlAccess getControl() {
        return this.control;
    }
}

