/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common;

import bibliothek.gui.dock.common.event.FontMapListener;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.util.font.ConstantFontModifier;
import bibliothek.gui.dock.util.font.FontModifier;
import bibliothek.gui.dock.util.font.GenericFontModifier;
import java.awt.Font;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FontMap {
    public static final String FONT_KEY_TITLE = "dock.title";
    public static final String FONT_KEY_TITLE_FOCUSED = "dock.title.focused";
    public static final String FONT_KEY_MINIMIZED_BUTTON = "dock.minimized";
    public static final String FONT_KEY_MINIMIZED_BUTTON_FOCUSED = "dock.minimized.focused";
    public static final String FONT_KEY_TAB = "dock.tab";
    public static final String FONT_KEY_TAB_SELECTED = "dock.tab.selected";
    public static final String FONT_KEY_TAB_FOCUSED = "dock.tab.focused";
    private Map<String, FontModifier> fonts = new HashMap<String, FontModifier>();
    private List<FontMapListener> listeners = new ArrayList<FontMapListener>();
    private CDockable dockable;

    public FontMap(CDockable cDockable) {
        if (cDockable == null) {
            throw new IllegalArgumentException("Dockable must not be null");
        }
        this.dockable = cDockable;
    }

    public CDockable getDockable() {
        return this.dockable;
    }

    public void addListener(FontMapListener fontMapListener) {
        if (fontMapListener == null) {
            throw new NullPointerException("listener must not be null");
        }
        this.listeners.add(fontMapListener);
    }

    public void removeListener(FontMapListener fontMapListener) {
        this.listeners.remove(fontMapListener);
    }

    public FontModifier getFont(String string) {
        return this.fonts.get(string);
    }

    public void setFont(String string, Font font) {
        if (font == null) {
            this.setFont(string, (FontModifier)null);
        } else {
            this.setFont(string, (FontModifier)new ConstantFontModifier(font));
        }
    }

    public void setFont(String string, String ... stringArray) {
        if (stringArray.length == 0) {
            this.setFont(string, (FontModifier)null);
        } else {
            GenericFontModifier genericFontModifier = new GenericFontModifier();
            for (String string2 : stringArray) {
                Object object;
                String[] stringArray2 = this.split(string2);
                String string3 = stringArray2[0];
                String string4 = stringArray2[1];
                boolean bl = "i".equals(string3);
                boolean bl2 = "b".equals(string3);
                boolean bl3 = "s".equals(string3);
                if (bl || bl2) {
                    if ("+".equals(string4)) {
                        object = GenericFontModifier.Modify.ON;
                    } else if ("-".equals(string4)) {
                        object = GenericFontModifier.Modify.OFF;
                    } else if ("!".equals(string4)) {
                        object = GenericFontModifier.Modify.REVERSE;
                    } else {
                        throw new IllegalArgumentException("illegal value, must be one of '+', '-' or '!': " + string2);
                    }
                    if (bl) {
                        genericFontModifier.setItalic(object);
                        continue;
                    }
                    genericFontModifier.setBold(object);
                    continue;
                }
                if (bl3) {
                    if (string4.startsWith("+")) {
                        genericFontModifier.setSizeDelta(true);
                        object = string4.substring(1).trim();
                    } else if (string4.startsWith("-")) {
                        genericFontModifier.setSizeDelta(true);
                        object = string4.substring(1).trim();
                    } else {
                        genericFontModifier.setSizeDelta(false);
                        object = string4;
                    }
                    int n = Integer.parseInt((String)object);
                    if (string4.startsWith("-")) {
                        n = -n;
                    }
                    genericFontModifier.setSize(n);
                    continue;
                }
                throw new IllegalArgumentException("unknown key: " + string2);
            }
            this.setFont(string, (FontModifier)genericFontModifier);
        }
    }

    private String[] split(String string) {
        int n = string.indexOf(61);
        if (n < 0) {
            throw new IllegalArgumentException("not in the form 'key'='value': " + string);
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        string2 = string2.trim();
        string3 = string3.trim();
        if (string2.length() == 0) {
            throw new IllegalArgumentException("missing key in: " + string);
        }
        if (string3.length() == 0) {
            throw new IllegalArgumentException("missing value in: " + string);
        }
        return new String[]{string2, string3};
    }

    public void removeFont(String string) {
        this.setFont(string, (FontModifier)null);
    }

    public void setFont(String string, FontModifier fontModifier) {
        FontModifier fontModifier2 = fontModifier == null ? this.fonts.remove(string) : this.fonts.put(string, fontModifier);
        if (fontModifier2 == null && fontModifier != null || fontModifier2 != null && !fontModifier2.equals(fontModifier)) {
            for (FontMapListener fontMapListener : this.listeners.toArray(new FontMapListener[this.listeners.size()])) {
                fontMapListener.fontChanged(this, string, fontModifier);
            }
        }
    }
}

