/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common;

import bibliothek.gui.dock.FlapDockStation;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.CLocation;
import bibliothek.gui.dock.common.CStation;
import bibliothek.gui.dock.common.event.ResizeRequestListener;
import bibliothek.gui.dock.common.intern.CControlAccess;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.common.intern.station.FlapResizeRequestHandler;
import bibliothek.gui.dock.common.location.CMinimizeAreaLocation;
import java.awt.BorderLayout;
import javax.swing.JPanel;

public class CMinimizeArea
extends JPanel
implements CStation {
    private FlapDockStation station;
    private ResizeRequestListener request;
    private CControlAccess access;
    private String uniqueId;

    public CMinimizeArea(CControl cControl, String string) {
        this.uniqueId = string;
        this.setLayout(new BorderLayout());
        this.station = cControl.getFactory().createFlapDockStation(this);
        this.request = new FlapResizeRequestHandler(this.station);
        this.add(this.station.getComponent(), "Center");
        this.setDirection(null);
    }

    public void setControl(CControlAccess cControlAccess) {
        if (this.access != null) {
            this.access.getOwner().removeResizeRequestListener(this.request);
            this.access.getStateManager().remove(this.uniqueId);
        }
        this.access = cControlAccess;
        if (this.access != null) {
            this.access.getOwner().addResizeRequestListener(this.request);
            this.access.getStateManager().add(this.uniqueId, this.station);
        }
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public FlapDockStation getStation() {
        return this.station;
    }

    public CLocation getStationLocation() {
        return new CMinimizeAreaLocation(this);
    }

    public boolean isWorkingArea() {
        return false;
    }

    public CDockable asDockable() {
        return null;
    }

    public void setDirection(FlapDockStation.Direction direction) {
        if (direction == null) {
            this.station.setAutoDirection(true);
        } else {
            this.station.setAutoDirection(false);
            this.station.setDirection(direction);
        }
    }
}

