/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common;

import bibliothek.gui.dock.SplitDockStation;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.CGrid;
import bibliothek.gui.dock.common.CLocation;
import bibliothek.gui.dock.common.CStation;
import bibliothek.gui.dock.common.SingleCDockable;
import bibliothek.gui.dock.common.intern.AbstractDockableCStation;
import bibliothek.gui.dock.common.intern.CControlAccess;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.common.intern.station.CommonStation;
import bibliothek.gui.dock.common.intern.station.CommonStationDelegate;
import bibliothek.gui.dock.common.intern.station.SplitResizeRequestHandler;
import bibliothek.gui.dock.common.location.CGridAreaLocation;
import bibliothek.gui.dock.facile.state.MaximizeArea;
import bibliothek.gui.dock.facile.state.MaximizeSplitDockStation;
import bibliothek.gui.dock.title.DockTitleVersion;
import javax.swing.Icon;
import javax.swing.JComponent;

public class CGridArea
extends AbstractDockableCStation
implements SingleCDockable {
    private String uniqueId;
    private SplitDockStation station;
    private SplitResizeRequestHandler resizeRequestHandler;
    private MaximizeArea maximizingArea;

    public CGridArea(CControl cControl, String string) {
        this.init(cControl, string);
    }

    protected CGridArea() {
    }

    protected void init(CControl cControl, String string) {
        if (string == null) {
            throw new NullPointerException("id must not be null");
        }
        this.uniqueId = string;
        CommonStation<SplitDockStation> commonStation = cControl.getFactory().createSplitDockStation(new Delegate());
        this.station = commonStation.asDockStation();
        this.init(commonStation);
        this.setTitleShown(false);
        this.station.setExpandOnDoubleclick(false);
        this.resizeRequestHandler = new SplitResizeRequestHandler(this.station);
        this.setMaximizingArea(true);
    }

    public void deploy(CGrid cGrid) {
        this.station.dropTree(cGrid.toTree());
    }

    public SplitDockStation getStation() {
        return this.station;
    }

    public CDockable asDockable() {
        return this;
    }

    public JComponent getComponent() {
        return this.station;
    }

    public CLocation getStationLocation() {
        return new CGridAreaLocation(this);
    }

    public void setTitleText(String string) {
        this.station.setTitleText(string);
    }

    public String getTitleText() {
        return this.station.getTitleText();
    }

    public void setTitleIcon(Icon icon) {
        this.station.setTitleIcon(icon);
    }

    public Icon getTitleIcon() {
        return this.station.getTitleIcon();
    }

    public void setMaximizingArea(boolean bl) {
        if (bl) {
            if (this.maximizingArea == null) {
                this.maximizingArea = new MaximizeSplitDockStation(this.getUniqueId(), this.station);
                CControlAccess cControlAccess = this.getControl();
                if (cControlAccess != null) {
                    cControlAccess.getStateManager().addMaximizingArea(this.maximizingArea);
                }
            }
        } else if (this.maximizingArea != null) {
            CControlAccess cControlAccess = this.getControl();
            if (cControlAccess != null) {
                cControlAccess.getStateManager().removeMaximizingArea(this.maximizingArea);
            }
            this.maximizingArea = null;
        }
    }

    public boolean isMaximizingArea() {
        return this.maximizingArea != null;
    }

    protected void install(CControlAccess cControlAccess) {
        cControlAccess.getStateManager().add(this.uniqueId, this.station, false);
        cControlAccess.getOwner().addResizeRequestListener(this.resizeRequestHandler);
        if (this.maximizingArea != null) {
            cControlAccess.getStateManager().addMaximizingArea(this.maximizingArea);
        }
    }

    protected void uninstall(CControlAccess cControlAccess) {
        cControlAccess.getStateManager().remove(this.uniqueId);
        cControlAccess.getOwner().removeResizeRequestListener(this.resizeRequestHandler);
        if (this.maximizingArea != null) {
            cControlAccess.getStateManager().removeMaximizingArea(this.maximizingArea);
        }
    }

    public boolean isCloseable() {
        return false;
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public boolean isExternalizable() {
        return false;
    }

    public boolean isMaximizable() {
        return false;
    }

    public boolean isMinimizable() {
        return false;
    }

    public boolean isStackable() {
        return false;
    }

    public boolean isWorkingArea() {
        return false;
    }

    protected boolean suppressTitle(DockTitleVersion dockTitleVersion) {
        if (!this.isTitleShown()) {
            if (dockTitleVersion.getID().equals("split")) {
                return true;
            }
            if (dockTitleVersion.getID().equals("flap window")) {
                return true;
            }
            if (dockTitleVersion.getID().equals("screen dock")) {
                return true;
            }
            if (dockTitleVersion.getID().equals("stack")) {
                return true;
            }
        }
        return false;
    }

    private class Delegate
    implements CommonStationDelegate {
        private Delegate() {
        }

        public CDockable getDockable() {
            return CGridArea.this;
        }

        public DockActionSource[] getSources() {
            return new DockActionSource[]{CGridArea.this.getClose()};
        }

        public CStation getStation() {
            return CGridArea.this;
        }

        public boolean isTitleDisplayed(DockTitleVersion dockTitleVersion) {
            return !CGridArea.this.suppressTitle(dockTitleVersion);
        }
    }
}

