/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common;

import bibliothek.extension.gui.dock.preference.PreferenceModel;
import bibliothek.extension.gui.dock.preference.PreferenceStorage;
import bibliothek.gui.DockController;
import bibliothek.gui.DockFrontend;
import bibliothek.gui.DockStation;
import bibliothek.gui.DockTheme;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.DockFactory;
import bibliothek.gui.dock.FlapDockStation;
import bibliothek.gui.dock.ScreenDockStation;
import bibliothek.gui.dock.SplitDockStation;
import bibliothek.gui.dock.accept.DockAcceptance;
import bibliothek.gui.dock.action.ActionOffer;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.common.CContentArea;
import bibliothek.gui.dock.common.CControlRegister;
import bibliothek.gui.dock.common.CGridArea;
import bibliothek.gui.dock.common.CLocation;
import bibliothek.gui.dock.common.CMaximizeBehavior;
import bibliothek.gui.dock.common.CMinimizeArea;
import bibliothek.gui.dock.common.CStation;
import bibliothek.gui.dock.common.CWorkingArea;
import bibliothek.gui.dock.common.DestroyHook;
import bibliothek.gui.dock.common.MissingCDockableStrategy;
import bibliothek.gui.dock.common.MultipleCDockable;
import bibliothek.gui.dock.common.MultipleCDockableFactory;
import bibliothek.gui.dock.common.SingleCDockable;
import bibliothek.gui.dock.common.SingleCDockableBackupFactory;
import bibliothek.gui.dock.common.action.predefined.CCloseAction;
import bibliothek.gui.dock.common.event.CControlListener;
import bibliothek.gui.dock.common.event.CDockablePropertyListener;
import bibliothek.gui.dock.common.event.CDockableStateListener;
import bibliothek.gui.dock.common.event.CDoubleClickListener;
import bibliothek.gui.dock.common.event.CFocusListener;
import bibliothek.gui.dock.common.event.CKeyboardListener;
import bibliothek.gui.dock.common.event.ResizeRequestListener;
import bibliothek.gui.dock.common.intern.AbstractCStation;
import bibliothek.gui.dock.common.intern.CControlAccess;
import bibliothek.gui.dock.common.intern.CControlFactory;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.common.intern.CDockableAccess;
import bibliothek.gui.dock.common.intern.CListenerCollection;
import bibliothek.gui.dock.common.intern.CSetting;
import bibliothek.gui.dock.common.intern.CSingleParentRemover;
import bibliothek.gui.dock.common.intern.CStateManager;
import bibliothek.gui.dock.common.intern.CommonDockable;
import bibliothek.gui.dock.common.intern.CommonDockableLayout;
import bibliothek.gui.dock.common.intern.CommonMultipleDockableFactory;
import bibliothek.gui.dock.common.intern.CommonSingleDockableFactory;
import bibliothek.gui.dock.common.intern.EfficientControlFactory;
import bibliothek.gui.dock.common.intern.ExtendedModeAcceptance;
import bibliothek.gui.dock.common.intern.MutableCControlRegister;
import bibliothek.gui.dock.common.intern.SecureControlFactory;
import bibliothek.gui.dock.common.intern.StackableAcceptance;
import bibliothek.gui.dock.common.intern.WorkingAreaAcceptance;
import bibliothek.gui.dock.common.intern.action.CActionOffer;
import bibliothek.gui.dock.common.intern.station.CFlapLayoutManager;
import bibliothek.gui.dock.common.intern.station.CLockedResizeLayoutManager;
import bibliothek.gui.dock.common.intern.station.ScreenResizeRequestHandler;
import bibliothek.gui.dock.common.layout.RequestDimension;
import bibliothek.gui.dock.common.layout.ThemeMap;
import bibliothek.gui.dock.common.location.CExternalizedLocation;
import bibliothek.gui.dock.control.DockRegister;
import bibliothek.gui.dock.control.SingleParentRemover;
import bibliothek.gui.dock.event.DockAdapter;
import bibliothek.gui.dock.event.DockRegisterListener;
import bibliothek.gui.dock.event.DockableFocusEvent;
import bibliothek.gui.dock.event.DockableFocusListener;
import bibliothek.gui.dock.event.DoubleClickListener;
import bibliothek.gui.dock.event.KeyboardListener;
import bibliothek.gui.dock.facile.station.screen.WindowProviderVisibility;
import bibliothek.gui.dock.facile.station.split.ConflictResolver;
import bibliothek.gui.dock.facile.station.split.DefaultConflictResolver;
import bibliothek.gui.dock.frontend.FrontendEntry;
import bibliothek.gui.dock.frontend.MissingDockableStrategy;
import bibliothek.gui.dock.layout.DockSituationIgnore;
import bibliothek.gui.dock.support.util.ApplicationResource;
import bibliothek.gui.dock.support.util.ApplicationResourceManager;
import bibliothek.gui.dock.util.DirectWindowProvider;
import bibliothek.gui.dock.util.NullWindowProvider;
import bibliothek.gui.dock.util.PropertyKey;
import bibliothek.gui.dock.util.WindowProvider;
import bibliothek.gui.dock.util.WindowProviderWrapper;
import bibliothek.gui.dock.util.property.ConstantPropertyFactory;
import bibliothek.gui.dock.util.property.PropertyFactory;
import bibliothek.util.Version;
import bibliothek.util.xml.XElement;
import bibliothek.util.xml.XIO;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JFrame;
import javax.swing.KeyStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CControl {
    public static final PropertyKey<KeyStroke> KEY_MAXIMIZE_CHANGE = new PropertyKey("ccontrol.maximize_change");
    public static final PropertyKey<KeyStroke> KEY_GOTO_MAXIMIZED = new PropertyKey("ccontrol.goto_maximized");
    public static final PropertyKey<KeyStroke> KEY_GOTO_NORMALIZED = new PropertyKey("ccontrol.goto_normalized");
    public static final PropertyKey<KeyStroke> KEY_GOTO_MINIMIZED = new PropertyKey("ccontrol.goto_minimized");
    public static final PropertyKey<KeyStroke> KEY_GOTO_EXTERNALIZED = new PropertyKey("ccontrol.goto_externalized");
    public static final PropertyKey<KeyStroke> KEY_CLOSE = new PropertyKey("ccontrol.close");
    public static final PropertyKey<ConflictResolver<RequestDimension>> RESIZE_LOCK_CONFLICT_RESOLVER = new PropertyKey("ccontrol.resize_lock_conflict_resolver", (PropertyFactory)new ConstantPropertyFactory(new DefaultConflictResolver()), true);
    public static final String EXTERNALIZED_STATION_ID = "external";
    public static final String CONTENT_AREA_STATIONS_ID = "ccontrol";
    private DockFrontend frontend;
    private MissingCDockableStrategy missingStrategy = MissingCDockableStrategy.PURGE;
    private Map<CDockable, CDockableAccess> accesses = new HashMap<CDockable, CDockableAccess>();
    private CStateManager stateManager;
    private CLocation defaultLocation;
    private ThemeMap themes;
    private CControlAccess access = new Access();
    private ApplicationResourceManager resources = new ApplicationResourceManager();
    private List<DestroyHook> hooks = new ArrayList<DestroyHook>();
    private CControlFactory factory;
    private MutableCControlRegister register;
    private List<CControlListener> listeners = new ArrayList<CControlListener>();
    private List<ResizeRequestListener> resizeListeners = new ArrayList<ResizeRequestListener>();
    private CListenerCollection listenerCollection = new CListenerCollection();
    private PreferenceStorage preferences = new PreferenceStorage();
    private PreferenceModel preferenceModel;

    public CControl() {
        this((WindowProvider)new NullWindowProvider(), false);
    }

    public CControl(JFrame jFrame) {
        this(jFrame, false);
    }

    public CControl(boolean bl) {
        this((WindowProvider)new NullWindowProvider(), bl);
    }

    public CControl(WindowProvider windowProvider) {
        this(windowProvider, false);
    }

    public CControl(JFrame jFrame, boolean bl) {
        this((WindowProvider)(jFrame == null ? new NullWindowProvider() : new DirectWindowProvider((Window)jFrame)), bl);
    }

    public CControl(WindowProvider windowProvider, boolean bl) {
        this(windowProvider, (CControlFactory)(bl ? new SecureControlFactory() : new EfficientControlFactory()));
    }

    public CControl(JFrame jFrame, CControlFactory cControlFactory) {
        this((WindowProvider)(jFrame == null ? new NullWindowProvider() : new DirectWindowProvider((Window)jFrame)), cControlFactory);
    }

    public CControl(WindowProvider windowProvider, CControlFactory cControlFactory) {
        if (windowProvider == null) {
            throw new IllegalArgumentException("window must not be null, however its search method may return null");
        }
        this.factory = cControlFactory;
        this.register = cControlFactory.createRegister(this);
        DockController dockController = cControlFactory.createController(this);
        dockController.setSingleParentRemover((SingleParentRemover)new CSingleParentRemover(this));
        this.initFocusListeners(dockController);
        this.initInputListener(dockController);
        this.frontend = cControlFactory.createFrontend(this.access, dockController);
        this.frontend.setOwner(windowProvider);
        this.frontend.setMissingDockableStrategy(new MissingDockableStrategy(){

            public boolean shouldStoreHidden(String string) {
                return CControl.this.shouldStore(string);
            }

            public boolean shouldStoreShown(String string) {
                return CControl.this.shouldStore(string);
            }

            public boolean shouldCreate(DockFactory<?, ?> dockFactory) {
                if (dockFactory instanceof CommonMultipleDockableFactory) {
                    return CControl.this.shouldCreate(((CommonMultipleDockableFactory)dockFactory).getFactory());
                }
                return false;
            }

            public <L> boolean shouldCreate(DockFactory<?, L> dockFactory, L l) {
                if (dockFactory instanceof CommonMultipleDockableFactory && l instanceof CommonDockableLayout) {
                    return CControl.this.shouldCreate(((CommonMultipleDockableFactory)dockFactory).getFactory(), (CommonDockableLayout)l);
                }
                return false;
            }
        });
        this.frontend.setIgnoreForEntry(new DockSituationIgnore(){

            public boolean ignoreChildren(DockStation dockStation) {
                CStation cStation = CControl.this.getStation(dockStation);
                if (cStation != null) {
                    return cStation.isWorkingArea();
                }
                return false;
            }

            public boolean ignoreElement(DockElement dockElement) {
                CDockable cDockable;
                return dockElement instanceof CommonDockable && (cDockable = ((CommonDockable)dockElement).getDockable()).getWorkingArea() != null;
            }
        });
        this.frontend.setShowHideAction(false);
        this.frontend.getController().addActionOffer((ActionOffer)new CActionOffer(this));
        this.frontend.getController().getRegister().addDockRegisterListener((DockRegisterListener)new DockAdapter(){

            public void dockableRegistered(DockController dockController, Dockable dockable) {
                if (dockable instanceof CommonDockable) {
                    CDockable cDockable = ((CommonDockable)dockable).getDockable();
                    CDockableAccess cDockableAccess = (CDockableAccess)CControl.this.accesses.get(cDockable);
                    if (cDockableAccess != null) {
                        cDockableAccess.informVisibility(true);
                    }
                    for (CControlListener cControlListener : CControl.this.listeners()) {
                        cControlListener.opened(CControl.this, cDockable);
                    }
                }
            }

            public void dockableUnregistered(DockController dockController, Dockable dockable) {
                if (dockable instanceof CommonDockable) {
                    CDockable cDockable = ((CommonDockable)dockable).getDockable();
                    CDockableAccess cDockableAccess = (CDockableAccess)CControl.this.accesses.get(cDockable);
                    if (cDockableAccess != null) {
                        cDockableAccess.informVisibility(false);
                    }
                    Object object = CControl.this.listeners();
                    int n = ((CControlListener[])object).length;
                    for (int i = 0; i < n; ++i) {
                        CControlListener cControlListener = object[i];
                        cControlListener.closed(CControl.this, cDockable);
                    }
                    if (cDockable instanceof MultipleCDockable && (object = (MultipleCDockable)cDockable).isRemoveOnClose()) {
                        CControl.this.remove((MultipleCDockable)object);
                    }
                }
            }
        });
        this.frontend.getController().addAcceptance((DockAcceptance)new StackableAcceptance());
        this.frontend.getController().addAcceptance((DockAcceptance)new WorkingAreaAcceptance(this.access));
        this.frontend.getController().addAcceptance((DockAcceptance)new ExtendedModeAcceptance(this.access));
        CommonSingleDockableFactory commonSingleDockableFactory = this.register.getBackupFactory();
        this.frontend.registerFactory((DockFactory)commonSingleDockableFactory);
        this.frontend.registerBackupFactory((DockFactory)commonSingleDockableFactory);
        this.themes = new ThemeMap(this);
        try {
            this.resources.put("ccontrol.frontend", new ApplicationResource(){

                public void write(DataOutputStream dataOutputStream) throws IOException {
                    Version.write((DataOutputStream)dataOutputStream, (Version)Version.VERSION_1_0_4);
                    CControl.this.writeWorkingAreas(dataOutputStream);
                    CControl.this.frontend.write(dataOutputStream);
                }

                public void read(DataInputStream dataInputStream) throws IOException {
                    Version version = Version.read((DataInputStream)dataInputStream);
                    version.checkCurrent();
                    CControl.this.readWorkingAreas(dataInputStream);
                    CControl.this.frontend.read(dataInputStream);
                }

                public void writeXML(XElement xElement) {
                    CControl.this.writeWorkingAreasXML(xElement.addElement("areas"));
                    CControl.this.frontend.writeXML(xElement.addElement("frontend"));
                }

                public void readXML(XElement xElement) {
                    CControl.this.readWorkingAreasXML(xElement.getElement("areas"));
                    CControl.this.frontend.readXML(xElement.getElement("frontend"));
                }
            });
            this.resources.put("ccontrol.preferences", new ApplicationResource(){

                public void read(DataInputStream dataInputStream) throws IOException {
                    Version version = Version.read((DataInputStream)dataInputStream);
                    version.checkCurrent();
                    CControl.this.preferences.read(dataInputStream);
                    if (CControl.this.preferenceModel != null) {
                        CControl.this.preferences.load(CControl.this.preferenceModel, false);
                        CControl.this.preferenceModel.write();
                    }
                }

                public void readXML(XElement xElement) {
                    CControl.this.preferences.readXML(xElement);
                    if (CControl.this.preferenceModel != null) {
                        CControl.this.preferences.load(CControl.this.preferenceModel, false);
                        CControl.this.preferenceModel.write();
                    }
                }

                public void write(DataOutputStream dataOutputStream) throws IOException {
                    if (CControl.this.preferenceModel != null) {
                        CControl.this.preferenceModel.read();
                        CControl.this.preferences.store(CControl.this.preferenceModel);
                    }
                    Version.write((DataOutputStream)dataOutputStream, (Version)Version.VERSION_1_0_6);
                    CControl.this.preferences.write(dataOutputStream);
                }

                public void writeXML(XElement xElement) {
                    if (CControl.this.preferenceModel != null) {
                        CControl.this.preferenceModel.read();
                        CControl.this.preferences.store(CControl.this.preferenceModel);
                    }
                    CControl.this.preferences.writeXML(xElement);
                }
            });
        }
        catch (IOException iOException) {
            System.err.println("Non lethal IO-error:");
            iOException.printStackTrace();
        }
        this.initExtendedModes();
        this.initProperties();
        this.setTheme("smooth");
    }

    private void initFocusListeners(DockController dockController) {
        dockController.addDockableFocusListener(new DockableFocusListener(){

            public void dockableFocused(DockableFocusEvent dockableFocusEvent) {
                CDockableAccess cDockableAccess;
                CDockable cDockable;
                Dockable dockable = dockableFocusEvent.getOldFocusOwner();
                Dockable dockable2 = dockableFocusEvent.getNewFocusOwner();
                if (dockable != null && dockable instanceof CommonDockable) {
                    cDockable = ((CommonDockable)dockable).getDockable();
                    cDockableAccess = (CDockableAccess)CControl.this.accesses.get(cDockable);
                    if (cDockableAccess != null) {
                        cDockableAccess.getFocusListener().focusLost(cDockable);
                    }
                    CControl.this.listenerCollection.getFocusListener().focusLost(cDockable);
                }
                if (dockable2 != null && dockable2 instanceof CommonDockable) {
                    cDockable = ((CommonDockable)dockable2).getDockable();
                    cDockableAccess = (CDockableAccess)CControl.this.accesses.get(cDockable);
                    if (cDockableAccess != null) {
                        cDockableAccess.getFocusListener().focusGained(cDockable);
                    }
                    CControl.this.listenerCollection.getFocusListener().focusGained(cDockable);
                }
            }
        });
    }

    private void initInputListener(DockController dockController) {
        dockController.getKeyboardController().addListener(new KeyboardListener(){

            public boolean keyPressed(DockElement dockElement, KeyEvent keyEvent) {
                if (dockElement instanceof CommonDockable) {
                    CDockable cDockable = ((CommonDockable)dockElement).getDockable();
                    CDockableAccess cDockableAccess = (CDockableAccess)CControl.this.accesses.get(cDockable);
                    if (cDockableAccess != null && cDockableAccess.getKeyboardListener().keyPressed(cDockable, keyEvent)) {
                        return true;
                    }
                    return CControl.this.listenerCollection.getKeyboardListener().keyPressed(cDockable, keyEvent);
                }
                return false;
            }

            public boolean keyReleased(DockElement dockElement, KeyEvent keyEvent) {
                if (dockElement instanceof CommonDockable) {
                    CDockable cDockable = ((CommonDockable)dockElement).getDockable();
                    CDockableAccess cDockableAccess = (CDockableAccess)CControl.this.accesses.get(cDockable);
                    if (cDockableAccess != null && cDockableAccess.getKeyboardListener().keyReleased(cDockable, keyEvent)) {
                        return true;
                    }
                    return CControl.this.listenerCollection.getKeyboardListener().keyReleased(cDockable, keyEvent);
                }
                return false;
            }

            public boolean keyTyped(DockElement dockElement, KeyEvent keyEvent) {
                if (dockElement instanceof CommonDockable) {
                    CDockable cDockable = ((CommonDockable)dockElement).getDockable();
                    CDockableAccess cDockableAccess = (CDockableAccess)CControl.this.accesses.get(cDockable);
                    if (cDockableAccess != null && cDockableAccess.getKeyboardListener().keyTyped(cDockable, keyEvent)) {
                        return true;
                    }
                    return CControl.this.listenerCollection.getKeyboardListener().keyTyped(cDockable, keyEvent);
                }
                return false;
            }

            public DockElement getTreeLocation() {
                return null;
            }
        });
        dockController.getDoubleClickController().addListener(new DoubleClickListener(){

            public boolean process(Dockable dockable, MouseEvent mouseEvent) {
                if (dockable instanceof CommonDockable) {
                    CDockable cDockable = ((CommonDockable)dockable).getDockable();
                    CDockableAccess cDockableAccess = (CDockableAccess)CControl.this.accesses.get(cDockable);
                    if (cDockableAccess != null && cDockableAccess.getDoubleClickListener().clicked(cDockable, mouseEvent)) {
                        return true;
                    }
                    return CControl.this.listenerCollection.getDoubleClickListener().clicked(cDockable, mouseEvent);
                }
                return false;
            }

            public DockElement getTreeLocation() {
                return null;
            }
        });
    }

    private void initExtendedModes() {
        this.stateManager = new CStateManager(this.access);
        WindowProviderWrapper windowProviderWrapper = this.frontend.getController().getRootWindowProvider();
        final ScreenDockStation screenDockStation = this.factory.createScreenDockStation((WindowProvider)windowProviderWrapper);
        AbstractCStation abstractCStation = new AbstractCStation((DockStation)screenDockStation, EXTERNALIZED_STATION_ID, CExternalizedLocation.STATION){
            private ScreenResizeRequestHandler handler;
            {
                super(dockStation, string, cLocation);
                this.handler = new ScreenResizeRequestHandler(screenDockStation);
            }

            protected void install(CControlAccess cControlAccess) {
                cControlAccess.getOwner().addResizeRequestListener(this.handler);
                cControlAccess.getStateManager().add(CControl.EXTERNALIZED_STATION_ID, screenDockStation);
            }

            protected void uninstall(CControlAccess cControlAccess) {
                cControlAccess.getOwner().removeResizeRequestListener(this.handler);
                cControlAccess.getStateManager().remove(CControl.EXTERNALIZED_STATION_ID);
            }
        };
        this.add(abstractCStation, true);
        WindowProviderVisibility windowProviderVisibility = new WindowProviderVisibility(screenDockStation);
        windowProviderVisibility.setProvider((WindowProvider)windowProviderWrapper);
    }

    private void initProperties() {
        this.putProperty(KEY_MAXIMIZE_CHANGE, KeyStroke.getKeyStroke(77, 2));
        this.putProperty(KEY_GOTO_EXTERNALIZED, KeyStroke.getKeyStroke(69, 2));
        this.putProperty(KEY_GOTO_NORMALIZED, KeyStroke.getKeyStroke(78, 2));
        this.putProperty(KEY_CLOSE, KeyStroke.getKeyStroke(115, 2));
        this.putProperty(SplitDockStation.LAYOUT_MANAGER, new CLockedResizeLayoutManager(this));
        this.putProperty(FlapDockStation.LAYOUT_MANAGER, new CFlapLayoutManager());
    }

    private void fillMultiFactories(CSetting cSetting) {
        for (String string : this.register.listMultipleDockableFactories()) {
            MultipleCDockableFactory<?, ?> multipleCDockableFactory = this.register.getFactory(string);
            List<MultipleCDockable> list = this.register.listMultipleDockables(multipleCDockableFactory);
            if (list.isEmpty()) continue;
            ArrayList<String> arrayList = new ArrayList<String>(list.size());
            for (MultipleCDockable multipleCDockable : list) {
                String string2 = this.accesses.get(multipleCDockable).getUniqueId();
                arrayList.add(this.register.multiToNormalId(string2));
            }
            cSetting.putMultipleFactoryDockables(string, arrayList);
        }
    }

    public void addControlListener(CControlListener cControlListener) {
        if (cControlListener == null) {
            throw new IllegalArgumentException("Listener must not be null");
        }
        this.listeners.add(cControlListener);
    }

    public void removeControlListener(CControlListener cControlListener) {
        this.listeners.remove(cControlListener);
    }

    public void addFocusListener(CFocusListener cFocusListener) {
        this.listenerCollection.addFocusListener(cFocusListener);
    }

    public void removeFocusListener(CFocusListener cFocusListener) {
        this.listenerCollection.removeFocusListener(cFocusListener);
    }

    public void addStateListener(CDockableStateListener cDockableStateListener) {
        this.listenerCollection.addCDockableStateListener(cDockableStateListener);
    }

    public void removeStateListener(CDockableStateListener cDockableStateListener) {
        this.listenerCollection.removeCDockableStateListener(cDockableStateListener);
    }

    public void addPropertyListener(CDockablePropertyListener cDockablePropertyListener) {
        this.listenerCollection.addCDockablePropertyListener(cDockablePropertyListener);
    }

    public void removePropertyListener(CDockablePropertyListener cDockablePropertyListener) {
        this.listenerCollection.removeCDockablePropertyListener(cDockablePropertyListener);
    }

    public void addKeyboardListener(CKeyboardListener cKeyboardListener) {
        this.listenerCollection.addKeyboardListener(cKeyboardListener);
    }

    public void removeKeybaordListener(CKeyboardListener cKeyboardListener) {
        this.listenerCollection.removeKeyboardListener(cKeyboardListener);
    }

    public void addGlobalKeyListener(KeyListener keyListener) {
        this.intern().getController().getKeyboardController().addGlobalListener(keyListener);
    }

    public void removeGlobalKeyListener(KeyListener keyListener) {
        this.intern().getController().getKeyboardController().removeGlobalListener(keyListener);
    }

    public void addDoubleClickListener(CDoubleClickListener cDoubleClickListener) {
        this.listenerCollection.addDoubleClickListener(cDoubleClickListener);
    }

    public void removeDoubleClickListener(CDoubleClickListener cDoubleClickListener) {
        this.listenerCollection.removeDoubleClickListener(cDoubleClickListener);
    }

    private CControlListener[] listeners() {
        return this.listeners.toArray(new CControlListener[this.listeners.size()]);
    }

    private void writeWorkingAreas(DataOutputStream dataOutputStream) throws IOException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (SingleCDockable object : this.register.getSingleDockables()) {
            CStation cStation = object.getWorkingArea();
            if (cStation == null) continue;
            hashMap.put(object.getUniqueId(), cStation.getUniqueId());
        }
        dataOutputStream.writeInt(hashMap.size());
        for (Map.Entry entry : hashMap.entrySet()) {
            dataOutputStream.writeUTF((String)entry.getKey());
            dataOutputStream.writeUTF((String)entry.getValue());
        }
    }

    private void writeWorkingAreasXML(XElement xElement) {
        for (SingleCDockable singleCDockable : this.register.getSingleDockables()) {
            CStation cStation = singleCDockable.getWorkingArea();
            if (cStation == null) continue;
            XElement xElement2 = xElement.addElement("area");
            xElement2.addString("id", cStation.getUniqueId());
            xElement2.addString("child", singleCDockable.getUniqueId());
        }
    }

    private void readWorkingAreas(DataInputStream dataInputStream) throws IOException {
        HashMap<String, SingleCDockable> hashMap = new HashMap<String, SingleCDockable>();
        HashMap<String, CStation> hashMap2 = new HashMap<String, CStation>();
        for (CStation object : this.register.getStations()) {
            if (!object.isWorkingArea()) continue;
            hashMap2.put(object.getUniqueId(), object);
        }
        for (SingleCDockable singleCDockable : this.register.getSingleDockables()) {
            hashMap.put(singleCDockable.getUniqueId(), singleCDockable);
        }
        int n = dataInputStream.readInt();
        for (int i = 0; i < n; ++i) {
            String string = dataInputStream.readUTF();
            String string2 = dataInputStream.readUTF();
            CDockable cDockable = (CDockable)hashMap.get(string);
            if (cDockable == null) continue;
            CStation cStation = (CStation)hashMap2.get(string2);
            cDockable.setWorkingArea(cStation);
        }
    }

    private void readWorkingAreasXML(XElement xElement) {
        HashMap<String, SingleCDockable> hashMap = new HashMap<String, SingleCDockable>();
        HashMap<String, CStation> hashMap2 = new HashMap<String, CStation>();
        for (CStation object : this.register.getStations()) {
            if (!object.isWorkingArea()) continue;
            hashMap2.put(object.getUniqueId(), object);
        }
        for (SingleCDockable singleCDockable : this.register.getSingleDockables()) {
            hashMap.put(singleCDockable.getUniqueId(), singleCDockable);
        }
        for (Iterator<Object> iterator : xElement.getElements("area")) {
            String string = iterator.getString("child");
            String string2 = iterator.getString("id");
            CDockable cDockable = (CDockable)hashMap.get(string);
            if (cDockable == null) continue;
            CStation cStation = (CStation)hashMap2.get(string2);
            cDockable.setWorkingArea(cStation);
        }
    }

    public void destroy() {
        this.frontend.kill();
        for (DestroyHook destroyHook : this.hooks) {
            destroyHook.destroy();
        }
    }

    public CWorkingArea createWorkingArea(String string) {
        CWorkingArea cWorkingArea = new CWorkingArea(this, string);
        this.add((MultipleCDockable)((Object)cWorkingArea));
        this.add(cWorkingArea, true);
        return cWorkingArea;
    }

    public CMinimizeArea createMinimizeArea(String string) {
        CMinimizeArea cMinimizeArea = new CMinimizeArea(this, string);
        this.add(cMinimizeArea, true);
        return cMinimizeArea;
    }

    public CGridArea createGridArea(String string) {
        CGridArea cGridArea = new CGridArea(this, string);
        this.add(cGridArea, true);
        if (this.frontend.getDefaultStation() == null) {
            this.frontend.setDefaultStation((DockStation)cGridArea.getStation());
        }
        return cGridArea;
    }

    private void checkStationIdentifierUniqueness(String string) {
        if (string == null) {
            throw new NullPointerException("uniqueId must not be null");
        }
        if (CContentArea.getCenterIdentifier(CONTENT_AREA_STATIONS_ID).equals(string)) {
            throw new IllegalArgumentException("The id " + string + " is reserved for special purposes");
        }
        if (CContentArea.getEastIdentifier(CONTENT_AREA_STATIONS_ID).equals(string)) {
            throw new IllegalArgumentException("The id " + string + " is reserved for special purposes");
        }
        if (CContentArea.getWestIdentifier(CONTENT_AREA_STATIONS_ID).equals(string)) {
            throw new IllegalArgumentException("The id " + string + " is reserved for special purposes");
        }
        if (CContentArea.getSouthIdentifier(CONTENT_AREA_STATIONS_ID).equals(string)) {
            throw new IllegalArgumentException("The id " + string + " is reserved for special purposes");
        }
        if (CContentArea.getNorthIdentifier(CONTENT_AREA_STATIONS_ID).equals(string)) {
            throw new IllegalArgumentException("The id " + string + " is reserved for special purposes");
        }
        for (CStation cStation : this.register.getStations()) {
            if (!cStation.getUniqueId().equals(string)) continue;
            throw new IllegalArgumentException("There exists already a station with id: " + string);
        }
    }

    public CContentArea createContentArea(String string) {
        if (string == null) {
            throw new NullPointerException("uniqueId must not be null");
        }
        for (CContentArea cContentArea : this.register.getContentAreas()) {
            if (!cContentArea.getUniqueId().equals(string)) continue;
            throw new IllegalArgumentException("There exists already a CContentArea with the unique id " + string);
        }
        DockStation dockStation = this.frontend.getDefaultStation();
        boolean bl = dockStation == null || dockStation instanceof ScreenDockStation;
        CContentArea cContentArea = new CContentArea(this, string);
        this.addContentArea(cContentArea);
        if (bl) {
            this.frontend.setDefaultStation((DockStation)cContentArea.getCenter());
        }
        return cContentArea;
    }

    @Deprecated
    public void addContentArea(CContentArea cContentArea) {
        if (cContentArea == null) {
            throw new NullPointerException("content is null");
        }
        if (cContentArea.getControl() != this) {
            throw new IllegalArgumentException("content was not created using this CControl");
        }
        this.register.addContentArea(cContentArea);
        CContentArea cContentArea2 = this.register.getDefaultContentArea();
        boolean bl = cContentArea2 != null && cContentArea == cContentArea2;
        for (CStation cStation : cContentArea.getStations()) {
            this.add(cStation, true, bl);
        }
    }

    public void removeContentArea(CContentArea cContentArea) {
        if (cContentArea == null) {
            throw new NullPointerException("content must not be null");
        }
        if (this.register.getDefaultContentArea() == cContentArea) {
            throw new IllegalArgumentException("The default-contentarea can't be removed");
        }
        if (this.register.removeContentArea(cContentArea)) {
            for (CStation cStation : cContentArea.getStations()) {
                this.remove(cStation);
            }
        }
    }

    public CControlRegister getRegister() {
        return this.register;
    }

    public List<CContentArea> getContentAreas() {
        return this.register.getContentAreas();
    }

    public CControlFactory getFactory() {
        return this.factory;
    }

    public CStateManager getStateManager() {
        return this.stateManager;
    }

    public void addDestroyHook(DestroyHook destroyHook) {
        if (destroyHook == null) {
            throw new NullPointerException("hook must not be null");
        }
        this.hooks.add(destroyHook);
    }

    public void removeDestroyHook(DestroyHook destroyHook) {
        this.hooks.remove(destroyHook);
    }

    public ApplicationResourceManager getResources() {
        return this.resources;
    }

    public <A> void putProperty(PropertyKey<A> propertyKey, A a) {
        this.frontend.getController().getProperties().set(propertyKey, a);
    }

    public <A> A getProperty(PropertyKey<A> propertyKey) {
        return (A)this.frontend.getController().getProperties().get(propertyKey);
    }

    public CContentArea getContentArea() {
        CContentArea cContentArea = this.register.getDefaultContentArea();
        if (cContentArea == null) {
            cContentArea = this.createContentArea(CONTENT_AREA_STATIONS_ID);
            this.register.setDefaultContentArea(cContentArea);
        }
        return cContentArea;
    }

    public void add(CStation cStation, boolean bl) {
        this.add(cStation, bl, true);
    }

    private void add(CStation cStation, boolean bl, boolean bl2) {
        String string = cStation.getUniqueId();
        if (bl2) {
            this.checkStationIdentifierUniqueness(string);
        }
        if (bl) {
            this.frontend.addRoot(string, cStation.getStation());
        }
        cStation.setControl(this.access);
        this.register.addStation(cStation);
    }

    public void remove(CStation cStation) {
        if (this.register.removeStation(cStation)) {
            this.frontend.removeRoot(cStation.getStation());
            cStation.setControl(null);
        }
    }

    public List<CStation> getStations() {
        return this.register.getStations();
    }

    public CStation getStation(DockStation dockStation) {
        for (CStation cStation : this.register.getStations()) {
            if (cStation.getStation() != dockStation) continue;
            return cStation;
        }
        return null;
    }

    public <S extends SingleCDockable> S add(S s) {
        if (s == null) {
            throw new NullPointerException("dockable must not be null");
        }
        if (s.getControl() != null) {
            throw new IllegalStateException("dockable is already part of a control");
        }
        s.setControl(this.access);
        String string = this.register.toSingleId(s.getUniqueId());
        this.accesses.get(s).setUniqueId(string);
        this.frontend.addDockable(string, (Dockable)s.intern());
        this.frontend.setHideable((Dockable)s.intern(), true);
        this.register.addSingleDockable(s);
        for (CControlListener cControlListener : this.listeners()) {
            cControlListener.added(this, s);
        }
        return s;
    }

    public SingleCDockable getSingleDockable(String string) {
        for (SingleCDockable singleCDockable : this.register.getSingleDockables()) {
            if (!singleCDockable.getUniqueId().equals(string)) continue;
            return singleCDockable;
        }
        return null;
    }

    public boolean removeSingleDockable(String string) {
        for (SingleCDockable singleCDockable : this.register.getSingleDockables()) {
            if (!singleCDockable.getUniqueId().equals(string)) continue;
            return this.remove(singleCDockable);
        }
        return false;
    }

    public boolean remove(SingleCDockable singleCDockable) {
        if (singleCDockable == null) {
            throw new NullPointerException("dockable must not be null");
        }
        if (singleCDockable.getControl() == this.access) {
            singleCDockable.setVisible(false);
            this.frontend.remove((Dockable)singleCDockable.intern());
            this.register.removeSingleDockable(singleCDockable);
            singleCDockable.setControl(null);
            if (!this.missingStrategy.shouldStoreSingle(singleCDockable.getUniqueId()) && this.register.getBackupFactory().getFactory(singleCDockable.getUniqueId()) == null) {
                this.stateManager.remove(singleCDockable.intern());
            } else {
                this.stateManager.reduceToEmpty(singleCDockable.intern());
            }
            for (CControlListener cControlListener : this.listeners()) {
                cControlListener.removed(this, singleCDockable);
            }
            return true;
        }
        return false;
    }

    public void addSingleBackupFactory(String string, SingleCDockableBackupFactory singleCDockableBackupFactory) {
        SingleCDockable singleCDockable;
        this.register.getBackupFactory().add(string, singleCDockableBackupFactory);
        String string2 = this.register.toSingleId(string);
        this.stateManager.addEmpty(string2);
        this.frontend.addEmpty(string2);
        FrontendEntry frontendEntry = this.frontend.getFrontendEntry(string2);
        if (frontendEntry != null && frontendEntry.getDockable() == null && frontendEntry.isShown() && (singleCDockable = singleCDockableBackupFactory.createBackup(string)) != null) {
            this.add((MultipleCDockable)((Object)singleCDockable));
            if (frontendEntry.isShown() || !singleCDockable.isCloseable()) {
                singleCDockable.setVisible(true);
            }
        }
    }

    public SingleCDockableBackupFactory getSingleBackupFactory(String string) {
        return this.register.getBackupFactory().getFactory(string);
    }

    public void removeSingleBackupFactory(String string) {
        this.register.getBackupFactory().remove(string);
        if (!this.missingStrategy.shouldStoreSingle(string)) {
            string = this.register.toSingleId(string);
            this.stateManager.removeEmpty(string);
            this.frontend.removeEmpty(string);
        }
    }

    /*
     * WARNING - void declaration
     */
    public <F extends MultipleCDockable> F add(F f) {
        void var5_8;
        HashSet<String> hashSet = new HashSet<String>();
        String string = this.access.getFactoryId(f.getFactory());
        if (string == null) {
            throw new IllegalStateException("the factory for a MultipleCDockable is not registered: " + f.getFactory());
        }
        for (MultipleCDockable object2 : this.register.getMultipleDockables()) {
            if (!string.equals(this.access.getFactoryId(object2.getFactory()))) continue;
            hashSet.add(this.accesses.get(object2).getUniqueId());
        }
        int n = 0;
        String string2 = n + " " + string;
        while (hashSet.contains(this.register.toMultiId((String)var5_8))) {
            String string3 = ++n + " " + string;
        }
        return this.add(f, (String)var5_8);
    }

    public <M extends MultipleCDockable> M add(M m, String string) {
        if (m == null) {
            throw new NullPointerException("dockable must not be null");
        }
        if (string == null) {
            throw new NullPointerException("uniqueId must not be null");
        }
        String string2 = this.access.getFactoryId(m.getFactory());
        if (string2 == null) {
            throw new IllegalStateException("the factory for a MultipleCDockable is not registered: " + m.getFactory());
        }
        if (m.getControl() != null) {
            throw new IllegalStateException("dockable is already part of a control");
        }
        string = this.register.toMultiId(string);
        for (MultipleCDockable multipleCDockable : this.register.getMultipleDockables()) {
            String string3 = this.accesses.get(multipleCDockable).getUniqueId();
            if (!string.equals(string3)) continue;
            throw new IllegalArgumentException("The unique identifier is already in use: " + string);
        }
        m.setControl(this.access);
        this.accesses.get(m).setUniqueId(string);
        this.register.addMultipleDockable(m);
        for (CControlListener cControlListener : this.listeners()) {
            cControlListener.added(this, m);
        }
        return m;
    }

    public MultipleCDockable getMultipleDockable(String string) {
        string = this.register.toMultiId(string);
        for (MultipleCDockable multipleCDockable : this.register.getMultipleDockables()) {
            if (!this.accesses.get(multipleCDockable).getUniqueId().equals(string)) continue;
            return multipleCDockable;
        }
        return null;
    }

    private boolean shouldStore(String string) {
        if (this.register.isSingleId(string)) {
            return this.missingStrategy.shouldStoreSingle(this.register.singleToNormalId(string));
        }
        return this.missingStrategy.shouldStoreMulti(this.register.multiToNormalId(string));
    }

    private boolean shouldCreate(MultipleCDockableFactory<?, ?> multipleCDockableFactory) {
        String string = this.access.getFactoryId(multipleCDockableFactory);
        return this.missingStrategy.shouldCreate(string, multipleCDockableFactory);
    }

    private boolean shouldCreate(MultipleCDockableFactory<?, ?> multipleCDockableFactory, CommonDockableLayout commonDockableLayout) {
        String string = commonDockableLayout.getId();
        String string2 = this.register.toMultiId(string);
        for (MultipleCDockable object2 : this.register.getMultipleDockables()) {
            if (!this.accesses.get(object2).getUniqueId().equals(string2)) continue;
            return false;
        }
        String string3 = this.access.getFactoryId(multipleCDockableFactory);
        MultipleCDockableFactory<?, ?> multipleCDockableFactory2 = multipleCDockableFactory;
        return this.missingStrategy.shouldCreate(string3, multipleCDockableFactory2, string, commonDockableLayout.getLayout());
    }

    public void remove(MultipleCDockable multipleCDockable) {
        if (multipleCDockable == null) {
            throw new NullPointerException("dockable must not be null");
        }
        if (multipleCDockable.getControl() == this.access) {
            multipleCDockable.setVisible(false);
            this.frontend.remove((Dockable)multipleCDockable.intern());
            this.register.removeMultipleDockable(multipleCDockable);
            multipleCDockable.setControl(null);
            for (CControlListener cControlListener : this.listeners()) {
                cControlListener.removed(this, multipleCDockable);
            }
        }
    }

    public int getCDockableCount() {
        return this.register.getDockableCount();
    }

    public CDockable getCDockable(int n) {
        return this.register.getDockable(n);
    }

    @Deprecated
    public void add(String string, MultipleCDockableFactory<?, ?> multipleCDockableFactory) {
        if (string == null) {
            throw new NullPointerException("id must not be null");
        }
        if (multipleCDockableFactory == null) {
            throw new NullPointerException("factory must not be null");
        }
        if (this.register.getCommonMultipleDockableFactory(string) != null) {
            throw new IllegalArgumentException("there is already a factory named " + string);
        }
        if (this.access.getFactoryId(multipleCDockableFactory) != null) {
            throw new IllegalArgumentException("this factory-object is already in use and cannot be added a second time");
        }
        CommonMultipleDockableFactory commonMultipleDockableFactory = new CommonMultipleDockableFactory(string, multipleCDockableFactory, this.access);
        this.register.putCommonMultipleDockableFactory(string, commonMultipleDockableFactory);
        this.frontend.registerFactory((DockFactory)commonMultipleDockableFactory);
    }

    public void addMultipleDockableFactory(String string, MultipleCDockableFactory<?, ?> multipleCDockableFactory) {
        this.add(string, multipleCDockableFactory);
    }

    public MultipleCDockableFactory<?, ?> getMultipleDockableFactory(String string) {
        return this.register.getFactory(string);
    }

    public void removeMultipleDockableFactory(String string) {
        CommonMultipleDockableFactory commonMultipleDockableFactory = this.register.removeCommonMultipleDockableFactory(string);
        if (commonMultipleDockableFactory != null) {
            this.frontend.unregisterFactory((DockFactory)commonMultipleDockableFactory);
            ArrayList<MultipleCDockable> arrayList = new ArrayList<MultipleCDockable>();
            for (MultipleCDockable multipleCDockable : this.register.getMultipleDockables()) {
                if (multipleCDockable.getFactory() != commonMultipleDockableFactory.getFactory()) continue;
                arrayList.add(multipleCDockable);
            }
            for (MultipleCDockable multipleCDockable : arrayList) {
                this.remove(multipleCDockable);
            }
        }
    }

    public void setDefaultLocation(CLocation cLocation) {
        this.defaultLocation = cLocation;
    }

    public CLocation getDefaultLocation() {
        return this.defaultLocation;
    }

    public void setMaximizeArea(String string) {
        this.stateManager.setMaximizingStation(string);
    }

    public void setMaximizeBehavior(CMaximizeBehavior cMaximizeBehavior) {
        this.stateManager.setMaximizeBehavior(cMaximizeBehavior);
    }

    public CMaximizeBehavior getMaximizeBehavior() {
        return this.stateManager.getMaximizeBehavior();
    }

    @Deprecated
    public void setTheme(DockTheme dockTheme) {
        this.frontend.getController().setTheme(dockTheme);
    }

    public void setTheme(String string) {
        this.themes.select(string);
    }

    public ThemeMap getThemes() {
        return this.themes;
    }

    public void setRootWindow(WindowProvider windowProvider) {
        this.frontend.setOwner(windowProvider);
    }

    public WindowProvider getRootWindow() {
        return this.frontend.getOwner();
    }

    public PreferenceStorage getPreferences() {
        return this.preferences;
    }

    public void setPreferenceModel(PreferenceModel preferenceModel) {
        if (this.preferenceModel != null) {
            this.preferenceModel.read();
            this.preferences.store(this.preferenceModel);
        }
        this.preferenceModel = preferenceModel;
        if (preferenceModel != null) {
            this.preferences.load(preferenceModel, false);
            preferenceModel.write();
        }
    }

    public PreferenceModel getPreferenceModel() {
        return this.preferenceModel;
    }

    public void setMissingStrategy(MissingCDockableStrategy missingCDockableStrategy) {
        this.missingStrategy = missingCDockableStrategy == null ? MissingCDockableStrategy.PURGE : missingCDockableStrategy;
    }

    public MissingCDockableStrategy getMissingStrategy() {
        return this.missingStrategy;
    }

    public void addResizeRequestListener(ResizeRequestListener resizeRequestListener) {
        if (resizeRequestListener == null) {
            throw new NullPointerException("listener must not be null");
        }
        this.resizeListeners.add(resizeRequestListener);
    }

    public void removeResizeRequestListener(ResizeRequestListener resizeRequestListener) {
        this.resizeListeners.remove(resizeRequestListener);
    }

    public void handleResizeRequests() {
        ResizeRequestListener[] resizeRequestListenerArray = this.resizeListeners.toArray(new ResizeRequestListener[this.resizeListeners.size()]);
        for (ResizeRequestListener resizeRequestListener : resizeRequestListenerArray) {
            resizeRequestListener.handleResizeRequest(this);
        }
        for (CDockable cDockable : this.register.getDockables()) {
            cDockable.getAndClearResizeRequest();
        }
    }

    public DockFrontend intern() {
        return this.frontend;
    }

    public void write(File file) throws IOException {
        this.getResources().writeFile(file);
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        this.getResources().writeStream(dataOutputStream);
    }

    public void writeXML(XElement xElement) {
        this.getResources().writeXML(xElement);
    }

    public void writeXML(File file) throws IOException {
        XElement xElement = new XElement("root");
        this.getResources().writeXML(xElement);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        XIO.writeUTF((XElement)xElement, (OutputStream)bufferedOutputStream);
        bufferedOutputStream.close();
    }

    public void read(File file) throws IOException {
        this.getResources().readFile(file);
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        this.getResources().readStream(dataInputStream);
    }

    public void readXML(XElement xElement) {
        this.getResources().readXML(xElement);
    }

    public void readXML(File file) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        XElement xElement = XIO.readUTF((InputStream)bufferedInputStream);
        bufferedInputStream.close();
        this.readXML(xElement);
    }

    public void save(String string) {
        this.frontend.save(string);
    }

    public void load(String string) {
        this.frontend.load(string);
    }

    public void delete(String string) {
        this.frontend.delete(string);
    }

    public String[] layouts() {
        Set set = this.frontend.getSettings();
        return set.toArray(new String[set.size()]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Access
    implements CControlAccess {
        private CCloseAction closeAction;

        private Access() {
        }

        @Override
        public CControl getOwner() {
            return CControl.this;
        }

        public <F extends MultipleCDockable> F add(F f, String string) {
            return CControl.this.add(f, string);
        }

        @Override
        public void link(CDockable cDockable, CDockableAccess cDockableAccess) {
            if (cDockableAccess == null) {
                CControl.this.accesses.remove(cDockable);
                cDockable.removeCDockablePropertyListener(CControl.this.listenerCollection.getCDockablePropertyListener());
                cDockable.removeCDockableStateListener(CControl.this.listenerCollection.getCDockableStateListener());
            } else if (CControl.this.accesses.put(cDockable, cDockableAccess) == null) {
                cDockable.addCDockablePropertyListener(CControl.this.listenerCollection.getCDockablePropertyListener());
                cDockable.addCDockableStateListener(CControl.this.listenerCollection.getCDockableStateListener());
            }
        }

        @Override
        public CDockableAccess access(CDockable cDockable) {
            return (CDockableAccess)CControl.this.accesses.get(cDockable);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void hide(CDockable cDockable) {
            block4: {
                DockRegister dockRegister = CControl.this.frontend.getController().getRegister();
                dockRegister.setStalled(true);
                try {
                    List<CDockable> list = CControl.this.register.listDockablesInMode(CDockable.ExtendedMode.MAXIMIZED);
                    boolean bl = CControl.this.stateManager.ensureNothingMaximized();
                    CControl.this.frontend.hide((Dockable)cDockable.intern());
                    if (!bl) break block4;
                    for (CDockable cDockable2 : list) {
                        if (cDockable2 == cDockable || !cDockable2.isMaximizable() || !cDockable2.isVisible()) continue;
                        cDockable2.setExtendedMode(CDockable.ExtendedMode.MAXIMIZED);
                        break;
                    }
                }
                finally {
                    dockRegister.setStalled(false);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void show(CDockable cDockable) {
            DockRegister dockRegister = CControl.this.frontend.getController().getRegister();
            dockRegister.setStalled(true);
            try {
                CStation cStation = cDockable.getWorkingArea();
                if (cStation != null && cStation.asDockable() != null && !cStation.asDockable().isVisible()) {
                    throw new IllegalStateException("A dockable that wants to be on a CWorkingArea can't be made visible unless the CWorkingArea is visible.");
                }
                CDockableAccess cDockableAccess = this.access(cDockable);
                CLocation cLocation = null;
                if (cDockableAccess != null) {
                    cLocation = cDockableAccess.internalLocation();
                }
                if (cLocation == null && !CControl.this.frontend.hasLocation((Dockable)cDockable.intern())) {
                    cLocation = cStation != null ? cStation.getStationLocation() : CControl.this.defaultLocation;
                }
                boolean bl = CControl.this.stateManager.ensureNothingMaximized();
                if (cLocation == null) {
                    CControl.this.frontend.show((Dockable)cDockable.intern(), false);
                } else {
                    CControl.this.stateManager.setLocation(cDockable.intern(), cLocation);
                }
                CControl.this.stateManager.ensureValidLocation(cDockable);
                if (cLocation == null && bl && cDockable.isMaximizable()) {
                    cDockable.setExtendedMode(CDockable.ExtendedMode.MAXIMIZED);
                }
            }
            finally {
                dockRegister.setStalled(false);
            }
        }

        @Override
        public boolean isVisible(CDockable cDockable) {
            return CControl.this.frontend.isShown((Dockable)cDockable.intern());
        }

        @Override
        public String getFactoryId(MultipleCDockableFactory<?, ?> multipleCDockableFactory) {
            for (Map.Entry<String, MultipleCDockableFactory<?, ?>> entry : CControl.this.register.getFactories().entrySet()) {
                if (entry.getValue() != multipleCDockableFactory) continue;
                return entry.getKey();
            }
            return null;
        }

        @Override
        public CStateManager getStateManager() {
            return CControl.this.stateManager;
        }

        @Override
        public DockAction createCloseAction(CDockable cDockable) {
            if (this.closeAction == null) {
                this.closeAction = new CCloseAction(CControl.this);
            }
            return this.closeAction.intern();
        }

        @Override
        public MutableCControlRegister getRegister() {
            return CControl.this.register;
        }

        @Override
        public boolean shouldStore(String string) {
            return CControl.this.shouldStore(string);
        }

        @Override
        public void fillMultiFactories(CSetting cSetting) {
            CControl.this.fillMultiFactories(cSetting);
        }
    }
}

