/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common;

import bibliothek.gui.DockStation;
import bibliothek.gui.dock.FlapDockStation;
import bibliothek.gui.dock.SplitDockStation;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.CGrid;
import bibliothek.gui.dock.common.CLocation;
import bibliothek.gui.dock.common.CStation;
import bibliothek.gui.dock.common.event.ResizeRequestListener;
import bibliothek.gui.dock.common.intern.AbstractCStation;
import bibliothek.gui.dock.common.intern.CControlAccess;
import bibliothek.gui.dock.common.intern.station.FlapResizeRequestHandler;
import bibliothek.gui.dock.common.intern.station.SplitResizeRequestHandler;
import bibliothek.gui.dock.common.location.CBaseLocation;
import bibliothek.gui.dock.facile.state.MaximizeArea;
import bibliothek.gui.dock.facile.state.MaximizeSplitDockStation;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class CContentArea
extends JPanel {
    private SplitDockStation center;
    private FlapDockStation north;
    private FlapDockStation south;
    private FlapDockStation east;
    private FlapDockStation west;
    private JComponent northComponent;
    private JComponent southComponent;
    private JComponent eastComponent;
    private JComponent westComponent;
    private Component[] cornerComponents = new Component[8];
    private String uniqueId;
    private CControl control;
    private CStation[] stations;

    public CContentArea(CControl cControl, String string) {
        this.control = cControl;
        this.uniqueId = string;
        this.center = cControl.getFactory().createSplitDockStation();
        this.center.setExpandOnDoubleclick(false);
        this.northComponent = new JPanel(new BorderLayout());
        this.southComponent = new JPanel(new BorderLayout());
        this.eastComponent = new JPanel(new BorderLayout());
        this.westComponent = new JPanel(new BorderLayout());
        this.north = cControl.getFactory().createFlapDockStation(this.northComponent);
        this.south = cControl.getFactory().createFlapDockStation(this.southComponent);
        this.east = cControl.getFactory().createFlapDockStation(this.eastComponent);
        this.west = cControl.getFactory().createFlapDockStation(this.westComponent);
        this.north.setAutoDirection(false);
        this.north.setDirection(FlapDockStation.Direction.SOUTH);
        this.south.setAutoDirection(false);
        this.south.setDirection(FlapDockStation.Direction.NORTH);
        this.east.setAutoDirection(false);
        this.east.setDirection(FlapDockStation.Direction.WEST);
        this.west.setAutoDirection(false);
        this.west.setDirection(FlapDockStation.Direction.EAST);
        this.setLayout(new BorderLayout());
        this.northComponent.add(this.north.getComponent(), "Center");
        this.southComponent.add(this.south.getComponent(), "Center");
        this.eastComponent.add(this.east.getComponent(), "Center");
        this.westComponent.add(this.west.getComponent(), "Center");
        this.add((Component)this.center, "Center");
        this.add((Component)this.northComponent, "North");
        this.add((Component)this.southComponent, "South");
        this.add((Component)this.eastComponent, "East");
        this.add((Component)this.westComponent, "West");
        CBaseLocation cBaseLocation = new CBaseLocation(this);
        this.stations = new CStation[]{new CenterStation(this.center, this.getCenterIdentifier(), cBaseLocation.normal()), new MinimizeStation(this.north, this.getNorthIdentifier(), cBaseLocation.minimalNorth()), new MinimizeStation(this.south, this.getSouthIdentifier(), cBaseLocation.minimalSouth()), new MinimizeStation(this.east, this.getEastIdentifier(), cBaseLocation.minimalEast()), new MinimizeStation(this.west, this.getWestIdentifier(), cBaseLocation.minimalWest())};
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public CControl getControl() {
        return this.control;
    }

    public CStation[] getStations() {
        CStation[] cStationArray = new CStation[this.stations.length];
        System.arraycopy(this.stations, 0, cStationArray, 0, this.stations.length);
        return cStationArray;
    }

    public void deploy(CGrid cGrid) {
        this.getCenter().dropTree(cGrid.toTree());
    }

    public void setCornerComponent(Component component, Corner corner, boolean bl) {
        int n = corner.ordinal() * 2;
        if (bl) {
            ++n;
        }
        if (this.cornerComponents[n] != null) {
            switch (corner) {
                case NORTH_WEST: {
                    if (bl) {
                        this.northComponent.remove(this.cornerComponents[n]);
                        break;
                    }
                    this.westComponent.remove(this.cornerComponents[n]);
                    break;
                }
                case NORTH_EAST: {
                    if (bl) {
                        this.northComponent.remove(this.cornerComponents[n]);
                        break;
                    }
                    this.eastComponent.remove(this.cornerComponents[n]);
                    break;
                }
                case SOUTH_WEST: {
                    if (bl) {
                        this.southComponent.remove(this.cornerComponents[n]);
                        break;
                    }
                    this.westComponent.remove(this.cornerComponents[n]);
                    break;
                }
                case SOUTH_EAST: {
                    if (bl) {
                        this.southComponent.remove(this.cornerComponents[n]);
                        break;
                    }
                    this.eastComponent.remove(this.cornerComponents[n]);
                }
            }
        }
        this.cornerComponents[n] = component;
        if (component != null) {
            switch (corner) {
                case NORTH_WEST: {
                    if (bl) {
                        this.northComponent.add(component, "West");
                        break;
                    }
                    this.westComponent.add(component, "North");
                    break;
                }
                case NORTH_EAST: {
                    if (bl) {
                        this.northComponent.add(component, "East");
                        break;
                    }
                    this.eastComponent.add(component, "North");
                    break;
                }
                case SOUTH_WEST: {
                    if (bl) {
                        this.southComponent.add(component, "West");
                        break;
                    }
                    this.westComponent.add(component, "South");
                    break;
                }
                case SOUTH_EAST: {
                    if (bl) {
                        this.southComponent.add(component, "East");
                        break;
                    }
                    this.eastComponent.add(component, "South");
                }
            }
        }
    }

    public Component getCornerComponent(Corner corner, boolean bl) {
        int n = corner.ordinal() * 2;
        if (bl) {
            ++n;
        }
        return this.cornerComponents[n];
    }

    public SplitDockStation getCenter() {
        return this.center;
    }

    public FlapDockStation getNorth() {
        return this.north;
    }

    public FlapDockStation getSouth() {
        return this.south;
    }

    public FlapDockStation getEast() {
        return this.east;
    }

    public FlapDockStation getWest() {
        return this.west;
    }

    public String getCenterIdentifier() {
        return CContentArea.getCenterIdentifier(this.uniqueId);
    }

    public static String getCenterIdentifier(String string) {
        return string + " center";
    }

    public String getNorthIdentifier() {
        return CContentArea.getNorthIdentifier(this.uniqueId);
    }

    public static String getNorthIdentifier(String string) {
        return string + " north";
    }

    public String getSouthIdentifier() {
        return CContentArea.getSouthIdentifier(this.uniqueId);
    }

    public static String getSouthIdentifier(String string) {
        return string + " south";
    }

    public String getEastIdentifier() {
        return CContentArea.getEastIdentifier(this.uniqueId);
    }

    public static String getEastIdentifier(String string) {
        return string + " east";
    }

    public String getWestIdentifier() {
        return CContentArea.getWestIdentifier(this.uniqueId);
    }

    public static String getWestIdentifier(String string) {
        return string + " west";
    }

    private class CenterStation
    extends AbstractCStation {
        private SplitDockStation station;
        private ResizeRequestListener handler;
        private MaximizeArea area;

        public CenterStation(SplitDockStation splitDockStation, String string, CLocation cLocation) {
            super((DockStation)splitDockStation, string, cLocation);
            this.station = splitDockStation;
            this.handler = new SplitResizeRequestHandler(splitDockStation);
            this.area = new MaximizeSplitDockStation(string, splitDockStation);
        }

        protected void install(CControlAccess cControlAccess) {
            cControlAccess.getOwner().addResizeRequestListener(this.handler);
            cControlAccess.getStateManager().add(this.getUniqueId(), this.station);
            cControlAccess.getStateManager().addMaximizingArea(this.area);
        }

        protected void uninstall(CControlAccess cControlAccess) {
            cControlAccess.getOwner().removeResizeRequestListener(this.handler);
            cControlAccess.getStateManager().removeMaximizingArea(this.area);
            cControlAccess.getStateManager().remove(this.getUniqueId());
        }
    }

    private class MinimizeStation
    extends AbstractCStation {
        private FlapDockStation station;
        private ResizeRequestListener handler;

        public MinimizeStation(FlapDockStation flapDockStation, String string, CLocation cLocation) {
            super((DockStation)flapDockStation, string, cLocation);
            this.station = flapDockStation;
            this.handler = new FlapResizeRequestHandler(flapDockStation);
        }

        protected void install(CControlAccess cControlAccess) {
            cControlAccess.getOwner().addResizeRequestListener(this.handler);
            cControlAccess.getStateManager().add(this.getUniqueId(), this.station);
        }

        protected void uninstall(CControlAccess cControlAccess) {
            cControlAccess.getOwner().removeResizeRequestListener(this.handler);
            cControlAccess.getStateManager().remove(this.getUniqueId());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Corner {
        SOUTH_EAST,
        SOUTH_WEST,
        NORTH_EAST,
        NORTH_WEST;

    }
}

