/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.asndatacenter;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.IDType;
import net.commustru.util.BinaryString;

public class FStruDecoderFixUTC
extends Decoder {
    public static final int UNIVERSAL_TAG_VAL = 0;
    public static final int APPLICATION_TAG_VAL = 64;
    public static final int CONTEXT_TAG_VAL = 128;
    public static final int PRIVATE_TAG_VAL = 192;
    public static final int TAG_CLASS_MASK = 192;
    public static final int CONSTRUCTED_BIT = 32;
    public static final int BIG_TAG_VAL = 31;
    public static final int TAG_MASK = 31;
    public static final int MAX_SMALL_TAG = 30;
    public static final int UNCERTAIN_LEN = 128;
    private static final TimeZone GMT_TIME_ZONE = new SimpleTimeZone(0, "GMT");
    private int iOctetStringLen;
    private byte[] octetStringByteArray;
    private InputStream oInputStream;
    private DeserializeStack oCurrentStack = new DeserializeStack();
    private int iStackIndex;
    private int iStackPos;
    private int iReadOctetCount;
    private boolean bPushedBack;
    private int iImplicitTag;
    private int iTag;
    private boolean bConstructed;
    private int iValueLen;

    public FStruDecoderFixUTC(InputStream inputstream) {
        this(inputstream, 32);
    }

    public FStruDecoderFixUTC(InputStream inputstream, int i) {
        DeserializeStack.access$102(this.oCurrentStack, new int[2 * i]);
        this.oCurrentStack.prevStack = (this.oCurrentStack.nextStack = null);
        this.initInputStream(inputstream);
    }

    public FStruDecoderFixUTC(byte[] buf) {
        this(new ByteArrayInputStream(buf));
    }

    public FStruDecoderFixUTC(byte[] buf, int offset, int length) {
        this(new ByteArrayInputStream(buf, offset, length));
    }

    public String deserializeBMPString() throws FStruException {
        this.verifyNextTag(30);
        return this.deserializeString(true);
    }

    public BinaryString deserializeBinaryString() throws FStruException {
        this.verifyNextTag(3);
        byte[] value = new byte[Math.max(this.iValueLen * 8, 0)];
        int i = this.deserializeBinaryStringContents(value, 0);
        return new BinaryString(value, 0, i, true);
    }

    private int deserializeBinaryStringContents(byte[] value, int length) throws FStruException {
        if (!this.bConstructed) {
            int from = this.iValueLen * 8 - 8 - this.readOctetFromInput();
            int byteIndex = length / 8;
            int byteValue = value[byteIndex];
            int octetIndex = length % 8;
            while (from > 0) {
                byteValue = byteValue << 8 | this.readOctetFromInput();
                octetIndex += from > 8 ? 8 : from;
                from -= 8;
                while (octetIndex >= 8) {
                    value[byteIndex++] = (byte)(byteValue >> (octetIndex -= 8));
                }
            }
            if (octetIndex > 0) {
                value[byteIndex] = (byte)byteValue;
            }
            length = byteIndex * 8 + octetIndex;
        } else {
            while (this.deserializeTagAndLength()) {
                if (this.bConstructed) {
                    this.pushStack(this.iTag);
                }
                length = this.deserializeBinaryStringContents(value, length);
            }
            this.popStack();
        }
        return length;
    }

    public boolean deserializeBoolean() throws FStruException {
        this.verifyNextTag(1);
        return this.readOctetFromInput() != 0;
    }

    public int deserializeChoice(int[] ai) throws FStruException {
        return this.watchNextTag();
    }

    public int deserializeExplicit(int nextTag) throws FStruException {
        this.verifyNextTag(nextTag);
        return this.iStackPos;
    }

    public String deserializeGeneralString() throws FStruException {
        this.verifyNextTag(27);
        return this.deserializeString(false);
    }

    public Calendar deserializeGeneralizedTime() throws FStruException {
        this.verifyNextTag(24);
        int timeZoneOffset = 0;
        String timeString = this.deserializeString(false);
        int second = this.pick2Digits(timeString, 12);
        int minute = this.pick2Digits(timeString, 10);
        int hourOfDay = this.pick2Digits(timeString, 8);
        int date = this.pick2Digits(timeString, 6);
        int month = this.pick2Digits(timeString, 4);
        int year = this.pick2Digits(timeString, 0) * 100 + this.pick2Digits(timeString, 2);
        int millSecond = 0;
        int index = 14;
        if (timeString.charAt(14) == '.' || timeString.charAt(14) == ',') {
            char digit = timeString.charAt(index);
            while (digit >= '0' && digit <= '9') {
                millSecond = millSecond * 10 + digit - 48;
                digit = timeString.charAt(++index);
            }
        }
        GregorianCalendar gregoriancalendar = new GregorianCalendar();
        if (timeString.length() > index) {
            char zoneStart = timeString.charAt(index);
            if (timeString.length() == index + 1 && zoneStart == 'Z') {
                timeZoneOffset = 0;
            } else if (zoneStart == '-' || zoneStart == '+') {
                byte sign = (byte)(zoneStart == '-' ? -1 : 1);
                timeZoneOffset = this.pick2Digits(timeString, index + 1) * sign * 60 + this.pick2Digits(timeString, index + 3) * sign * 1000;
            } else {
                throw new FStruException("Confused Generalized Time: No terminal Z or time zone offset ");
            }
        }
        gregoriancalendar.set(year, month - 1, date, hourOfDay, minute, second);
        gregoriancalendar.set(14, millSecond);
        gregoriancalendar.setTimeZone(FStruDecoderFixUTC.buildTimeZone(timeZoneOffset));
        return gregoriancalendar;
    }

    public String deserializeGraphicString() throws FStruException {
        this.verifyNextTag(25);
        return this.deserializeString(false);
    }

    public String deserializeIA5String() throws FStruException {
        this.verifyNextTag(22);
        return this.deserializeString(false);
    }

    public BigInteger deserializeInteger() throws FStruException {
        this.verifyNextTag(2);
        byte[] value = new byte[this.iValueLen];
        for (int i = 0; i < this.iValueLen; ++i) {
            value[i] = (byte)this.readOctetFromInput();
        }
        return new BigInteger(value);
    }

    public int deserializeEnumeration() throws FStruException {
        this.verifyNextTag(10);
        int value = 0;
        for (int i = this.iValueLen; i > 0; --i) {
            value = (value << 8) + this.readOctetFromInput();
        }
        int mask = 32 - this.iValueLen * 8;
        mask = mask < 0 ? 0 : mask;
        return value << mask >> mask;
    }

    public int deserializeIntegerAsInt() throws FStruException {
        this.verifyNextTag(2);
        int value = 0;
        for (int i = this.iValueLen; i > 0; --i) {
            value = (value << 8) + this.readOctetFromInput();
        }
        int mask = 32 - this.iValueLen * 8;
        mask = mask < 0 ? 0 : mask;
        return value << mask >> mask;
    }

    public long deserializeIntegerAsLong() throws FStruException {
        this.verifyNextTag(2);
        long value = 0L;
        for (int i = this.iValueLen; i > 0; --i) {
            value = (value << 8) + (long)this.readOctetFromInput();
        }
        int mask = 64 - this.iValueLen * 8;
        mask = mask < 0 ? 0 : mask;
        return value << mask >> mask;
    }

    public void deserializeNull() throws FStruException {
        this.verifyNextTag(5);
        for (int i = this.iValueLen; i > 0; --i) {
            this.readOctetFromInput();
        }
    }

    public String deserializeNumericString() throws FStruException {
        this.verifyNextTag(18);
        return this.deserializeString(false);
    }

    public IDType deserializeIDType() throws FStruException {
        this.verifyNextTag(6);
        int byteValue = this.readOctetFromInput();
        int[] ids = new int[64];
        ids[0] = byteValue / 40;
        ids[1] = byteValue % 40;
        int length = 2;
        int idComponent = 0;
        for (int i = 1; i < this.iValueLen; ++i) {
            byteValue = this.readOctetFromInput();
            if (idComponent >= 0x10000000) {
                this.throwFStruException("ID Component doesn't fit into an int type");
            }
            idComponent = (idComponent << 7) + (byteValue & 0x7F);
            if ((byteValue & 0x80) != 0) continue;
            if (length >= ids.length) {
                this.throwFStruException("Object identifier has more than " + ids.length + " components");
            }
            ids[length++] = idComponent;
            idComponent = 0;
        }
        return new IDType(null, ids, 0, length);
    }

    public byte[] deserializeOctetString() throws FStruException {
        this.verifyNextTag(4);
        this.iOctetStringLen = 0;
        this.octetStringByteArray = new byte[Math.max(0, this.iValueLen)];
        this.deserializeOctetStringContents();
        if (this.iOctetStringLen != this.octetStringByteArray.length) {
            byte[] value = new byte[this.iOctetStringLen];
            System.arraycopy(this.octetStringByteArray, 0, value, 0, this.iOctetStringLen);
            return value;
        }
        return this.octetStringByteArray;
    }

    public int deserializeOctetString(byte[] value, int length) throws FStruException {
        this.verifyNextTag(4);
        this.iOctetStringLen = length;
        this.octetStringByteArray = value;
        this.deserializeOctetStringContents();
        if (value == this.octetStringByteArray) {
            return this.iOctetStringLen;
        }
        throw new ArrayIndexOutOfBoundsException("Byte array too small to hold ASN.1 octet string");
    }

    private synchronized void deserializeOctetStringContents() throws FStruException {
        if (!this.bConstructed) {
            if (this.iOctetStringLen + this.iValueLen > this.octetStringByteArray.length) {
                byte[] value = new byte[this.iOctetStringLen + this.iValueLen];
                if (this.iOctetStringLen > 0) {
                    System.arraycopy(this.octetStringByteArray, 0, value, 0, this.iOctetStringLen);
                }
                this.octetStringByteArray = value;
            }
            for (int i = this.iValueLen; i > 0; --i) {
                this.octetStringByteArray[this.iOctetStringLen++] = (byte)this.readOctetFromInput();
            }
        } else {
            while (this.deserializeTagAndLength()) {
                this.deserializeOctetStringContents();
                if (!this.bConstructed) continue;
                this.pushStack(this.iTag);
            }
            this.popStack();
        }
    }

    public String deserializePrintableString() throws FStruException {
        this.verifyNextTag(19);
        return this.deserializeString(false);
    }

    public double deserializeDouble() throws FStruException {
        throw new FStruException("Double type deserializing not yet implemented");
    }

    public int deserializeSequence() throws FStruException {
        this.verifyNextTag(16);
        return this.iStackPos;
    }

    public int deserializeSequenceOf() throws FStruException {
        return this.deserializeSequence();
    }

    public int deserializeSet() throws FStruException {
        this.verifyNextTag(17);
        return this.iStackPos;
    }

    public int deserializeSetOf() throws FStruException {
        return this.deserializeSet();
    }

    public Calendar deserializeUTCTime() throws FStruException {
        this.verifyNextTag(23);
        int timeZoneOffset = 0;
        String timeString = this.deserializeString(false);
        int second = 0;
        int minute = this.pick2Digits(timeString, 8);
        int hourOfDay = this.pick2Digits(timeString, 6);
        int dayOfMonth = this.pick2Digits(timeString, 4);
        int month = this.pick2Digits(timeString, 2);
        int year = this.pick2Digits(timeString, 0);
        year = year < 50 ? 2000 + year : 1900 + year;
        int charIndex = 10;
        char charVal = timeString.charAt(charIndex);
        if (charVal >= '0' && charVal <= '9') {
            second = this.pick2Digits(timeString, charIndex);
            charIndex = 12;
        }
        if ((charVal = timeString.charAt(charIndex)) == '+' || charVal == '-') {
            byte sign = (byte)(charVal == '-' ? -1 : 1);
            timeZoneOffset = this.pick2Digits(timeString, charIndex + 1) * sign * 60 + this.pick2Digits(timeString, charIndex + 3) * sign * 1000;
        } else if (charVal == 'Z') {
            timeZoneOffset = 0;
        } else {
            this.throwFStruException("Confused UTC Time: No terminal Z or time zone offset");
        }
        GregorianCalendar gregoriancalendar = new GregorianCalendar(year, month - 1, dayOfMonth, hourOfDay, minute, second);
        gregoriancalendar.setTimeZone(FStruDecoderFixUTC.buildTimeZone(timeZoneOffset));
        return gregoriancalendar;
    }

    public String deserializeT61String() throws FStruException {
        this.verifyNextTag(20);
        return this.deserializeString(false);
    }

    public String deserializeVideotexString() throws FStruException {
        this.verifyNextTag(21);
        return this.deserializeString(false);
    }

    public String deserializeVisibleString() throws FStruException {
        this.verifyNextTag(26);
        return this.deserializeString(false);
    }

    public String deserializeTeletexString() throws FStruException {
        return this.deserializeT61String();
    }

    public String deserializeISO646String() throws FStruException {
        return this.deserializeT61String();
    }

    public boolean finishedBy(int i) throws FStruException {
        if (i != this.iStackPos) {
            this.throwFStruException("Unexpected termination of constructed encodings");
        }
        if (!this.deserializeTagAndLength()) {
            this.popStack();
            return true;
        }
        this.setPushBackState();
        return false;
    }

    public int watchNextTag() throws FStruException {
        if (this.deserializeTagAndLength()) {
            this.setPushBackState();
            return this.iTag;
        }
        return 0;
    }

    public int watchNextValueLength() throws FStruException {
        if (this.bPushedBack) {
            return this.iValueLen;
        }
        if (this.deserializeTagAndLength()) {
            this.setPushBackState();
            return this.iValueLen;
        }
        return -1;
    }

    private String deserializeString(boolean bmpStr) throws FStruException {
        StringBuffer stringbuffer = this.iValueLen > 0 ? new StringBuffer(this.iValueLen / (bmpStr ? 2 : 1)) : new StringBuffer();
        this.deserializeStringContents(stringbuffer, bmpStr);
        return stringbuffer.toString();
    }

    private void deserializeStringContents(StringBuffer stringbuffer, boolean bmpStr) throws FStruException {
        if (this.bConstructed) {
            while (this.deserializeTagAndLength()) {
                this.deserializeStringContents(stringbuffer, bmpStr);
                if (!this.bConstructed) continue;
                this.pushStack(this.iTag);
            }
            this.popStack();
        } else if (bmpStr) {
            int i;
            for (i = this.iValueLen; i >= 2; i -= 2) {
                stringbuffer.append((char)(this.readOctetFromInput() << 8 | this.readOctetFromInput() & 0xFF));
            }
            if (i > 0) {
                this.readOctetFromInput();
                return;
            }
        } else {
            for (int i = this.iValueLen; i > 0; --i) {
                stringbuffer.append((char)this.readOctetFromInput());
            }
        }
    }

    private void verifyNextTag(int nextTag) throws FStruException {
        if (!this.deserializeTagAndLength()) {
            this.throwFStruException("Should has one more tag, but none");
        }
        if (this.iImplicitTag != 0) {
            if (this.iImplicitTag != this.iTag) {
                this.throwFStruException("Read a tag: " + FStruDecoderFixUTC.tag2String((int)this.iTag) + ", but should be (implicit): " + FStruDecoderFixUTC.tag2String((int)this.iImplicitTag) + " / original data tag " + FStruDecoderFixUTC.tag2String((int)nextTag));
            }
        } else if (this.iTag != nextTag) {
            this.throwFStruException("Read a tag: " + FStruDecoderFixUTC.tag2String((int)this.iTag) + " but should be: " + FStruDecoderFixUTC.tag2String((int)nextTag));
        }
        if (!this.bConstructed || FStruDecoderFixUTC.findTagClass((int)nextTag) == 0 && !FStruDecoderFixUTC.assertUniversalStringTag((int)nextTag)) {
            this.iImplicitTag = 0;
        }
        if (this.bConstructed) {
            this.pushStack(nextTag);
        }
    }

    private boolean deserializeTagAndLength() throws FStruException {
        if (this.bPushedBack) {
            this.bPushedBack = false;
            return true;
        }
        if (this.iTag == 0) {
            return false;
        }
        int i = this.oCurrentStack.stackVal[this.iStackIndex];
        if (i >= 0 && this.iReadOctetCount >= i) {
            return false;
        }
        int octet = this.readOctetFromInput();
        this.bConstructed = (octet & 0x20) != 0;
        int tagClass = 0;
        switch (octet & 0xC0) {
            case 0: {
                tagClass = 0;
                break;
            }
            case 64: {
                tagClass = 1;
                break;
            }
            case 128: {
                tagClass = 2;
                break;
            }
            case 192: {
                tagClass = 3;
            }
        }
        this.iTag = octet & 0x1F;
        if (this.iTag == 31) {
            int tagLength;
            long tagNumber = 0L;
            do {
                if ((tagNumber = (tagNumber << 7) + (long)((tagLength = this.readOctetFromInput()) & 0x7F)) <= 0x3FFFFFFFL) continue;
                this.throwFStruException("Tag number not valid");
            } while ((tagLength & 0x80) != 0);
            this.iTag = (int)tagNumber;
        }
        this.iTag = FStruDecoderFixUTC.buildTag((int)tagClass, (int)this.iTag);
        this.iValueLen = this.readOctetFromInput();
        if (this.iValueLen >= 128) {
            if (this.iValueLen == 128) {
                this.iValueLen = -1;
                return true;
            }
            long length = 0L;
            for (int lenComponentCount = this.iValueLen & 0x7F; lenComponentCount > 0; --lenComponentCount) {
                int lenComponent = this.readOctetFromInput();
                if ((length = length << 8 | (long)lenComponent) < 0x80000000L) continue;
                this.throwFStruException("Length value too big");
            }
            this.iValueLen = (int)length;
        }
        return this.iTag != 0;
    }

    private final int pick2Digits(String timeStr, int from) throws FStruException {
        char firstDigit = '\u0000';
        char secondDigit = '\u0000';
        if (from + 1 < timeStr.length()) {
            firstDigit = timeStr.charAt(from);
            secondDigit = timeStr.charAt(from + 1);
            if (firstDigit < '0' || firstDigit > '9' || secondDigit < '0' || secondDigit > '9') {
                this.throwFStruException("Confused time: should be digits but: " + firstDigit + secondDigit);
            }
        }
        return (firstDigit - 48) * 10 + (secondDigit - 48);
    }

    private int readOctetFromInput() throws FStruException {
        try {
            int octet = this.oInputStream.read();
            if (octet < 0) {
                throw new FStruException((Exception)new EOFException("The end of input data is unexpected"));
            }
            ++this.iReadOctetCount;
            return octet;
        }
        catch (IOException ioexception) {
            throw new FStruException((Exception)ioexception);
        }
    }

    private static TimeZone buildTimeZone(int rawOffset) {
        TimeZone timeZone = null;
        String[] ids = TimeZone.getAvailableIDs(rawOffset);
        if (ids == null || ids.length == 0 || !(timeZone = TimeZone.getTimeZone(ids[0])).getID().equals(ids[0])) {
            timeZone = rawOffset == 0 ? GMT_TIME_ZONE : new SimpleTimeZone(rawOffset, "???");
        }
        return timeZone;
    }

    public boolean isNextDefault(int tag) throws FStruException {
        return tag != this.watchNextTag();
    }

    public void setNextImplicit(int tag) {
        this.iImplicitTag = tag;
    }

    public boolean isNextOptional(int tag) throws FStruException {
        return this.isNextDefault(tag);
    }

    private void popStack() throws FStruException {
        int i = this.oCurrentStack.stackVal[this.iStackIndex];
        if (i < 0 && this.iTag != 0) {
            this.throwFStruException("Contents octets not used up");
        }
        if (i >= 0 && i != this.iReadOctetCount) {
            this.throwFStruException("Contents octets not used up");
        }
        if ((this.iStackIndex -= 2) < 0) {
            this.oCurrentStack = this.oCurrentStack.prevStack;
            this.iStackIndex = this.oCurrentStack.stackVal.length - 2;
        }
        this.iTag = -1;
        --this.iStackPos;
    }

    private void pushStack(int tag) {
        this.iStackIndex += 2;
        if (this.iStackIndex >= this.oCurrentStack.stackVal.length) {
            if (this.oCurrentStack.nextStack == null) {
                DeserializeStack nextDecodeStack = new DeserializeStack();
                this.oCurrentStack.nextStack = nextDecodeStack;
                nextDecodeStack.prevStack = this.oCurrentStack;
                DeserializeStack.access$102(nextDecodeStack, new int[this.oCurrentStack.stackVal.length]);
            }
            this.oCurrentStack = this.oCurrentStack.nextStack;
            this.iStackIndex = 0;
        }
        ((DeserializeStack)this.oCurrentStack).stackVal[this.iStackIndex] = this.iValueLen >= 0 ? this.iReadOctetCount + this.iValueLen : -1;
        ((DeserializeStack)this.oCurrentStack).stackVal[this.iStackIndex + 1] = tag;
        ++this.iStackPos;
    }

    private final void setPushBackState() {
        this.bPushedBack = true;
    }

    private void initInputStream(InputStream inputstream) {
        this.oInputStream = inputstream;
        this.bPushedBack = false;
        this.iReadOctetCount = 0;
        while (this.oCurrentStack.prevStack != null) {
            this.oCurrentStack = this.oCurrentStack.prevStack;
        }
        ((DeserializeStack)this.oCurrentStack).stackVal[0] = -1;
        ((DeserializeStack)this.oCurrentStack).stackVal[1] = 16;
        this.iStackPos = 0;
        this.iStackIndex = 0;
        this.iTag = 16;
        this.iImplicitTag = 0;
    }

    public void passOverNext() throws FStruException {
        if (!this.deserializeTagAndLength()) {
            this.throwFStruException("It is the end of (nested) encodings: can't skip next element");
        }
        if (this.iValueLen >= 0) {
            for (int i = this.iValueLen; i > 0; --i) {
                this.readOctetFromInput();
            }
        } else {
            this.pushStack(this.iTag);
            while (this.iStackPos > 0) {
                while (this.deserializeTagAndLength()) {
                    if (this.iValueLen < 0) {
                        this.pushStack(this.iTag);
                    }
                    for (int i = this.iValueLen; i > 0; --i) {
                        this.readOctetFromInput();
                    }
                }
                this.popStack();
            }
        }
    }

    private void throwFStruException(String s) throws FStruException {
        throw new FStruException(s + " (offset " + this.iReadOctetCount + ")");
    }

    private static final class DeserializeStack {
        private int[] stackVal;
        private DeserializeStack prevStack;
        private DeserializeStack nextStack;

        private DeserializeStack() {
        }

        static /* synthetic */ int[] access$102(DeserializeStack x0, int[] x1) {
            x0.stackVal = x1;
            return x1;
        }
    }
}

