/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.asndatacenter;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class AsnTaskRecoverElementInfo
implements FStruct {
    public BigInteger iDeviceID;
    public byte[] strFilePath;
    public boolean bDeliverToBoard;
    public BigInteger iSequenceId;
    public BigInteger iGroupID;

    public AsnTaskRecoverElementInfo() {
    }

    public AsnTaskRecoverElementInfo(AsnTaskRecoverElementInfo arg) {
        this.iDeviceID = arg.iDeviceID;
        this.strFilePath = new byte[arg.strFilePath.length];
        System.arraycopy(arg.strFilePath, 0, this.strFilePath, 0, arg.strFilePath.length);
        this.bDeliverToBoard = arg.bDeliverToBoard;
        this.iSequenceId = arg.iSequenceId;
        this.iGroupID = arg.iGroupID;
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeInteger(this.iDeviceID);
        enc.serializeOctetString(this.strFilePath);
        enc.serializeBoolean(this.bDeliverToBoard);
        enc.serializeInteger(this.iSequenceId);
        enc.serializeInteger(this.iGroupID);
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.iDeviceID = dec.deserializeInteger();
        this.strFilePath = dec.deserializeOctetString();
        this.bDeliverToBoard = dec.deserializeBoolean();
        this.iSequenceId = dec.deserializeInteger();
        this.iGroupID = dec.deserializeInteger();
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iDeviceID = ");
        os.print(this.iDeviceID.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("strFilePath = ");
        os.print(FStruFormat.convertToString((byte[])this.strFilePath));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("bDeliverToBoard = ");
        os.print(this.bDeliverToBoard);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iSequenceId = ");
        os.print(this.iSequenceId.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iGroupID = ");
        os.print(this.iGroupID.toString());
        os.println();
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

