/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.asndatacenter;

import com.huawei.dc.common.asndatacenter.AsnDCErrorCodeInfo;
import com.huawei.dc.common.asndatacenter.AsnDCNodeInfo;
import com.huawei.dc.common.asndatacenter.AsnLogTypeEnum;
import com.huawei.dc.common.asndatacenter.AsnStatusEnum;
import com.huawei.dc.common.asndatacenter.AsnTaskResource;
import com.huawei.dc.common.asndatacenter.AsnTaskResultEnum;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Calendar;
import java.util.GregorianCalendar;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class AsnTaskDetailsResultInfo
implements FStruct {
    public AsnTaskResource oAsnTaskResource = new AsnTaskResource();
    public AsnLogTypeEnum enAsnLogTypeEnum = new AsnLogTypeEnum();
    public Calendar ologTime = new GregorianCalendar();
    public AsnTaskResultEnum enAsnResult = new AsnTaskResultEnum();
    public AsnStatusEnum enAsnStatus = new AsnStatusEnum();
    public byte[] strOperationId;
    public byte[] strCheckTypeId = null;
    public byte[] strFileName = null;
    public AsnDCErrorCodeInfo oErrorCode = null;
    public AsnDCNodeInfo oAsnDCNodeInfo = null;

    public AsnTaskDetailsResultInfo() {
    }

    public AsnTaskDetailsResultInfo(AsnTaskDetailsResultInfo arg) {
        this.oAsnTaskResource = new AsnTaskResource(arg.oAsnTaskResource);
        this.enAsnLogTypeEnum = new AsnLogTypeEnum(arg.enAsnLogTypeEnum);
        this.ologTime = (Calendar)arg.ologTime.clone();
        this.enAsnResult = new AsnTaskResultEnum(arg.enAsnResult);
        this.enAsnStatus = new AsnStatusEnum(arg.enAsnStatus);
        this.strOperationId = new byte[arg.strOperationId.length];
        System.arraycopy(arg.strOperationId, 0, this.strOperationId, 0, arg.strOperationId.length);
        if (arg.strCheckTypeId != null) {
            this.strCheckTypeId = new byte[arg.strCheckTypeId.length];
            System.arraycopy(arg.strCheckTypeId, 0, this.strCheckTypeId, 0, arg.strCheckTypeId.length);
        }
        if (arg.strFileName != null) {
            this.strFileName = new byte[arg.strFileName.length];
            System.arraycopy(arg.strFileName, 0, this.strFileName, 0, arg.strFileName.length);
        }
        if (arg.oErrorCode != null) {
            this.oErrorCode = new AsnDCErrorCodeInfo(arg.oErrorCode);
        }
        if (arg.oAsnDCNodeInfo != null) {
            this.oAsnDCNodeInfo = new AsnDCNodeInfo(arg.oAsnDCNodeInfo);
        }
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        this.oAsnTaskResource.serialize(enc);
        this.enAsnLogTypeEnum.serialize(enc);
        enc.serializeUTCTime(this.ologTime);
        this.enAsnResult.serialize(enc);
        this.enAsnStatus.serialize(enc);
        enc.serializeOctetString(this.strOperationId);
        if (this.strCheckTypeId != null) {
            int ex_id_strCheckTypeId1 = enc.serializeExplicit(Encoder.buildTag((int)2, (int)0));
            enc.serializeOctetString(this.strCheckTypeId);
            enc.finishedBy(ex_id_strCheckTypeId1);
        }
        if (this.strFileName != null) {
            int ex_id_strFileName1 = enc.serializeExplicit(Encoder.buildTag((int)2, (int)1));
            enc.serializeOctetString(this.strFileName);
            enc.finishedBy(ex_id_strFileName1);
        }
        if (this.oErrorCode != null) {
            int ex_id_oErrorCode1 = enc.serializeExplicit(Encoder.buildTag((int)2, (int)2));
            this.oErrorCode.serialize(enc);
            enc.finishedBy(ex_id_oErrorCode1);
        }
        if (this.oAsnDCNodeInfo != null) {
            int ex_id_oAsnDCNodeInfo1 = enc.serializeExplicit(Encoder.buildTag((int)2, (int)3));
            this.oAsnDCNodeInfo.serialize(enc);
            enc.finishedBy(ex_id_oAsnDCNodeInfo1);
        }
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.oAsnTaskResource.deserialize(dec);
        this.enAsnLogTypeEnum.deserialize(dec);
        this.ologTime = dec.deserializeUTCTime();
        this.enAsnResult.deserialize(dec);
        this.enAsnStatus.deserialize(dec);
        this.strOperationId = dec.deserializeOctetString();
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)0))) {
            int ex_id_strCheckTypeId1 = dec.deserializeExplicit(Decoder.buildTag((int)2, (int)0));
            this.strCheckTypeId = dec.deserializeOctetString();
            dec.finishedBy(ex_id_strCheckTypeId1);
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)1))) {
            int ex_id_strFileName1 = dec.deserializeExplicit(Decoder.buildTag((int)2, (int)1));
            this.strFileName = dec.deserializeOctetString();
            dec.finishedBy(ex_id_strFileName1);
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)2))) {
            this.oErrorCode = new AsnDCErrorCodeInfo();
            int ex_id_oErrorCode1 = dec.deserializeExplicit(Decoder.buildTag((int)2, (int)2));
            this.oErrorCode.deserialize(dec);
            dec.finishedBy(ex_id_oErrorCode1);
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)3))) {
            this.oAsnDCNodeInfo = new AsnDCNodeInfo();
            int ex_id_oAsnDCNodeInfo1 = dec.deserializeExplicit(Decoder.buildTag((int)2, (int)3));
            this.oAsnDCNodeInfo.deserialize(dec);
            dec.finishedBy(ex_id_oAsnDCNodeInfo1);
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("oAsnTaskResource = ");
        this.oAsnTaskResource.print(os, indent + 2);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("enAsnLogTypeEnum = ");
        this.enAsnLogTypeEnum.print(os, indent + 2);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("ologTime = ");
        os.print(this.ologTime.getTime().toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("enAsnResult = ");
        this.enAsnResult.print(os, indent + 2);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("enAsnStatus = ");
        this.enAsnStatus.print(os, indent + 2);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("strOperationId = ");
        os.print(FStruFormat.convertToString((byte[])this.strOperationId));
        os.println(',');
        if (this.strCheckTypeId != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("strCheckTypeId = ");
            os.print(FStruFormat.convertToString((byte[])this.strCheckTypeId));
            os.println(',');
        }
        if (this.strFileName != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("strFileName = ");
            os.print(FStruFormat.convertToString((byte[])this.strFileName));
            os.println(',');
        }
        if (this.oErrorCode != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("oErrorCode = ");
            this.oErrorCode.print(os, indent + 2);
            os.println(',');
        }
        if (this.oAsnDCNodeInfo != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("oAsnDCNodeInfo = ");
            this.oAsnDCNodeInfo.print(os, indent + 2);
            os.println();
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

