/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.asndatacenter;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class AsnSWStatDevInfo
implements FStruct {
    public BigInteger iDevID;
    public byte[] strNEId;
    public byte[] strDevType;
    public byte[] strDevName;
    public byte[] strDevVersion = null;

    public AsnSWStatDevInfo() {
    }

    public AsnSWStatDevInfo(AsnSWStatDevInfo arg) {
        this.iDevID = arg.iDevID;
        this.strNEId = new byte[arg.strNEId.length];
        System.arraycopy(arg.strNEId, 0, this.strNEId, 0, arg.strNEId.length);
        this.strDevType = new byte[arg.strDevType.length];
        System.arraycopy(arg.strDevType, 0, this.strDevType, 0, arg.strDevType.length);
        this.strDevName = new byte[arg.strDevName.length];
        System.arraycopy(arg.strDevName, 0, this.strDevName, 0, arg.strDevName.length);
        if (arg.strDevVersion != null) {
            this.strDevVersion = new byte[arg.strDevVersion.length];
            System.arraycopy(arg.strDevVersion, 0, this.strDevVersion, 0, arg.strDevVersion.length);
        }
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeInteger(this.iDevID);
        enc.serializeOctetString(this.strNEId);
        enc.serializeOctetString(this.strDevType);
        enc.serializeOctetString(this.strDevName);
        if (this.strDevVersion != null) {
            enc.serializeOctetString(this.strDevVersion);
        }
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.iDevID = dec.deserializeInteger();
        this.strNEId = dec.deserializeOctetString();
        this.strDevType = dec.deserializeOctetString();
        this.strDevName = dec.deserializeOctetString();
        if (!dec.isNextOptional(Decoder.buildTag((int)0, (int)4))) {
            this.strDevVersion = dec.deserializeOctetString();
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iDevID = ");
        os.print(this.iDevID.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("strNEId = ");
        os.print(FStruFormat.convertToString((byte[])this.strNEId));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("strDevType = ");
        os.print(FStruFormat.convertToString((byte[])this.strDevType));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("strDevName = ");
        os.print(FStruFormat.convertToString((byte[])this.strDevName));
        os.println(',');
        if (this.strDevVersion != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("strDevVersion = ");
            os.print(FStruFormat.convertToString((byte[])this.strDevVersion));
            os.println();
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

