/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.asndatacenter;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class AsnSIBoardInfo
implements FStruct {
    public BigInteger iFrameId;
    public BigInteger iSlotId;
    public byte[] strSlotLabel;

    public AsnSIBoardInfo() {
    }

    public AsnSIBoardInfo(AsnSIBoardInfo arg) {
        this.iFrameId = arg.iFrameId;
        this.iSlotId = arg.iSlotId;
        this.strSlotLabel = new byte[arg.strSlotLabel.length];
        System.arraycopy(arg.strSlotLabel, 0, this.strSlotLabel, 0, arg.strSlotLabel.length);
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeInteger(this.iFrameId);
        enc.serializeInteger(this.iSlotId);
        enc.serializeOctetString(this.strSlotLabel);
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.iFrameId = dec.deserializeInteger();
        this.iSlotId = dec.deserializeInteger();
        this.strSlotLabel = dec.deserializeOctetString();
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iFrameId = ");
        os.print(this.iFrameId.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iSlotId = ");
        os.print(this.iSlotId.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("strSlotLabel = ");
        os.print(FStruFormat.convertToString((byte[])this.strSlotLabel));
        os.println();
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

