/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.asndatacenter;

import com.huawei.dc.common.asndatacenter.AsnDCBreakPacketResult;
import com.huawei.dc.common.asndatacenter.DCStringList;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class AsnSAMFileInfo
implements FStruct {
    public byte[] strFileName;
    public BigInteger iFileType;
    public byte[] strVersion;
    public byte[] strBDVersion;
    public byte[] strSize;
    public byte[] strDescription;
    public AsnDCBreakPacketResult oBreakPacketResult = null;
    public byte[] strPatchVersion = null;
    public DCStringList strMultiVersionLst = new DCStringList();

    public AsnSAMFileInfo() {
    }

    public AsnSAMFileInfo(AsnSAMFileInfo arg) {
        this.strFileName = new byte[arg.strFileName.length];
        System.arraycopy(arg.strFileName, 0, this.strFileName, 0, arg.strFileName.length);
        this.iFileType = arg.iFileType;
        this.strVersion = new byte[arg.strVersion.length];
        System.arraycopy(arg.strVersion, 0, this.strVersion, 0, arg.strVersion.length);
        this.strBDVersion = new byte[arg.strBDVersion.length];
        System.arraycopy(arg.strBDVersion, 0, this.strBDVersion, 0, arg.strBDVersion.length);
        this.strSize = new byte[arg.strSize.length];
        System.arraycopy(arg.strSize, 0, this.strSize, 0, arg.strSize.length);
        this.strDescription = new byte[arg.strDescription.length];
        System.arraycopy(arg.strDescription, 0, this.strDescription, 0, arg.strDescription.length);
        if (arg.oBreakPacketResult != null) {
            this.oBreakPacketResult = new AsnDCBreakPacketResult(arg.oBreakPacketResult);
        }
        if (arg.strPatchVersion != null) {
            this.strPatchVersion = new byte[arg.strPatchVersion.length];
            System.arraycopy(arg.strPatchVersion, 0, this.strPatchVersion, 0, arg.strPatchVersion.length);
        }
        this.strMultiVersionLst = new DCStringList(arg.strMultiVersionLst);
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeOctetString(this.strFileName);
        enc.serializeInteger(this.iFileType);
        enc.serializeOctetString(this.strVersion);
        enc.serializeOctetString(this.strBDVersion);
        enc.serializeOctetString(this.strSize);
        enc.serializeOctetString(this.strDescription);
        if (this.oBreakPacketResult != null) {
            int ex_id_oBreakPacketResult1 = enc.serializeExplicit(Encoder.buildTag((int)2, (int)0));
            this.oBreakPacketResult.serialize(enc);
            enc.finishedBy(ex_id_oBreakPacketResult1);
        }
        if (this.strPatchVersion != null) {
            int ex_id_strPatchVersion1 = enc.serializeExplicit(Encoder.buildTag((int)2, (int)1));
            enc.serializeOctetString(this.strPatchVersion);
            enc.finishedBy(ex_id_strPatchVersion1);
        }
        this.strMultiVersionLst.serialize(enc);
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.strFileName = dec.deserializeOctetString();
        this.iFileType = dec.deserializeInteger();
        this.strVersion = dec.deserializeOctetString();
        this.strBDVersion = dec.deserializeOctetString();
        this.strSize = dec.deserializeOctetString();
        this.strDescription = dec.deserializeOctetString();
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)0))) {
            this.oBreakPacketResult = new AsnDCBreakPacketResult();
            int ex_id_oBreakPacketResult1 = dec.deserializeExplicit(Decoder.buildTag((int)2, (int)0));
            this.oBreakPacketResult.deserialize(dec);
            dec.finishedBy(ex_id_oBreakPacketResult1);
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)1))) {
            int ex_id_strPatchVersion1 = dec.deserializeExplicit(Decoder.buildTag((int)2, (int)1));
            this.strPatchVersion = dec.deserializeOctetString();
            dec.finishedBy(ex_id_strPatchVersion1);
        }
        this.strMultiVersionLst.deserialize(dec);
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("strFileName = ");
        os.print(FStruFormat.convertToString((byte[])this.strFileName));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iFileType = ");
        os.print(this.iFileType.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("strVersion = ");
        os.print(FStruFormat.convertToString((byte[])this.strVersion));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("strBDVersion = ");
        os.print(FStruFormat.convertToString((byte[])this.strBDVersion));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("strSize = ");
        os.print(FStruFormat.convertToString((byte[])this.strSize));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("strDescription = ");
        os.print(FStruFormat.convertToString((byte[])this.strDescription));
        os.println(',');
        if (this.oBreakPacketResult != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("oBreakPacketResult = ");
            this.oBreakPacketResult.print(os, indent + 2);
            os.println(',');
        }
        if (this.strPatchVersion != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("strPatchVersion = ");
            os.print(FStruFormat.convertToString((byte[])this.strPatchVersion));
            os.println(',');
        }
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("strMultiVersionLst = ");
        this.strMultiVersionLst.print(os, indent + 2);
        os.println();
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

