/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.asndatacenter;

import com.huawei.dc.common.asndatacenter.AsnDCErrorCodeInfo;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class AsnPatchResultInfo
implements FStruct {
    public AsnDCErrorCodeInfo oErrorInfo = new AsnDCErrorCodeInfo();
    public BigInteger iFrameId;
    public BigInteger iSlotId;
    public BigInteger iBoardType = null;
    public BigInteger iSubSlotId = null;
    public byte[] strPatchName;

    public AsnPatchResultInfo() {
    }

    public AsnPatchResultInfo(AsnPatchResultInfo arg) {
        this.oErrorInfo = new AsnDCErrorCodeInfo(arg.oErrorInfo);
        this.iFrameId = arg.iFrameId;
        this.iSlotId = arg.iSlotId;
        if (arg.iBoardType != null) {
            this.iBoardType = arg.iBoardType;
        }
        if (arg.iSubSlotId != null) {
            this.iSubSlotId = arg.iSubSlotId;
        }
        this.strPatchName = new byte[arg.strPatchName.length];
        System.arraycopy(arg.strPatchName, 0, this.strPatchName, 0, arg.strPatchName.length);
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        this.oErrorInfo.serialize(enc);
        enc.serializeInteger(this.iFrameId);
        enc.serializeInteger(this.iSlotId);
        if (this.iBoardType != null) {
            int ex_id_iBoardType1 = enc.serializeExplicit(Encoder.buildTag((int)2, (int)0));
            enc.serializeInteger(this.iBoardType);
            enc.finishedBy(ex_id_iBoardType1);
        }
        if (this.iSubSlotId != null) {
            int ex_id_iSubSlotId1 = enc.serializeExplicit(Encoder.buildTag((int)2, (int)1));
            enc.serializeInteger(this.iSubSlotId);
            enc.finishedBy(ex_id_iSubSlotId1);
        }
        enc.serializeOctetString(this.strPatchName);
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.oErrorInfo.deserialize(dec);
        this.iFrameId = dec.deserializeInteger();
        this.iSlotId = dec.deserializeInteger();
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)0))) {
            int ex_id_iBoardType1 = dec.deserializeExplicit(Decoder.buildTag((int)2, (int)0));
            this.iBoardType = dec.deserializeInteger();
            dec.finishedBy(ex_id_iBoardType1);
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)1))) {
            int ex_id_iSubSlotId1 = dec.deserializeExplicit(Decoder.buildTag((int)2, (int)1));
            this.iSubSlotId = dec.deserializeInteger();
            dec.finishedBy(ex_id_iSubSlotId1);
        }
        this.strPatchName = dec.deserializeOctetString();
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("oErrorInfo = ");
        this.oErrorInfo.print(os, indent + 2);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iFrameId = ");
        os.print(this.iFrameId.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iSlotId = ");
        os.print(this.iSlotId.toString());
        os.println(',');
        if (this.iBoardType != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("iBoardType = ");
            os.print(this.iBoardType.toString());
            os.println(',');
        }
        if (this.iSubSlotId != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("iSubSlotId = ");
            os.print(this.iSubSlotId.toString());
            os.println(',');
        }
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("strPatchName = ");
        os.print(FStruFormat.convertToString((byte[])this.strPatchName));
        os.println();
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

