/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.asndatacenter;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class AsnOptionInfo
implements FStruct {
    public byte[] strOptId;
    public BigInteger iValue;
    public byte[] strDestination = null;

    public AsnOptionInfo() {
    }

    public AsnOptionInfo(AsnOptionInfo arg) {
        this.strOptId = new byte[arg.strOptId.length];
        System.arraycopy(arg.strOptId, 0, this.strOptId, 0, arg.strOptId.length);
        this.iValue = arg.iValue;
        if (arg.strDestination != null) {
            this.strDestination = new byte[arg.strDestination.length];
            System.arraycopy(arg.strDestination, 0, this.strDestination, 0, arg.strDestination.length);
        }
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeOctetString(this.strOptId);
        enc.serializeInteger(this.iValue);
        if (this.strDestination != null) {
            enc.serializeOctetString(this.strDestination);
        }
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.strOptId = dec.deserializeOctetString();
        this.iValue = dec.deserializeInteger();
        if (!dec.isNextOptional(Decoder.buildTag((int)0, (int)4))) {
            this.strDestination = dec.deserializeOctetString();
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("strOptId = ");
        os.print(FStruFormat.convertToString((byte[])this.strOptId));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iValue = ");
        os.print(this.iValue.toString());
        os.println(',');
        if (this.strDestination != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("strDestination = ");
            os.print(FStruFormat.convertToString((byte[])this.strDestination));
            os.println();
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

