/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.asndatacenter;

import com.huawei.dc.common.asndatacenter.AsnArea;
import com.huawei.dc.common.asndatacenter.AsnBoard;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class AsnGetProgramArea
implements FStruct {
    public AsnBoard iMainboardID = new AsnBoard();
    public AsnArea iProagramActiveArea = new AsnArea();
    public AsnArea iDataActiveArea = new AsnArea();
    public byte[] strProagramAreaAVersion;
    public byte[] strProagramAreaBVersion;
    public byte[] strDataAreaAVersion;
    public byte[] strDataAreaBVersion;

    public AsnGetProgramArea() {
    }

    public AsnGetProgramArea(AsnGetProgramArea arg) {
        this.iMainboardID = new AsnBoard(arg.iMainboardID);
        this.iProagramActiveArea = new AsnArea(arg.iProagramActiveArea);
        this.iDataActiveArea = new AsnArea(arg.iDataActiveArea);
        this.strProagramAreaAVersion = new byte[arg.strProagramAreaAVersion.length];
        System.arraycopy(arg.strProagramAreaAVersion, 0, this.strProagramAreaAVersion, 0, arg.strProagramAreaAVersion.length);
        this.strProagramAreaBVersion = new byte[arg.strProagramAreaBVersion.length];
        System.arraycopy(arg.strProagramAreaBVersion, 0, this.strProagramAreaBVersion, 0, arg.strProagramAreaBVersion.length);
        this.strDataAreaAVersion = new byte[arg.strDataAreaAVersion.length];
        System.arraycopy(arg.strDataAreaAVersion, 0, this.strDataAreaAVersion, 0, arg.strDataAreaAVersion.length);
        this.strDataAreaBVersion = new byte[arg.strDataAreaBVersion.length];
        System.arraycopy(arg.strDataAreaBVersion, 0, this.strDataAreaBVersion, 0, arg.strDataAreaBVersion.length);
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        this.iMainboardID.serialize(enc);
        this.iProagramActiveArea.serialize(enc);
        this.iDataActiveArea.serialize(enc);
        enc.serializeOctetString(this.strProagramAreaAVersion);
        enc.serializeOctetString(this.strProagramAreaBVersion);
        enc.serializeOctetString(this.strDataAreaAVersion);
        enc.serializeOctetString(this.strDataAreaBVersion);
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.iMainboardID.deserialize(dec);
        this.iProagramActiveArea.deserialize(dec);
        this.iDataActiveArea.deserialize(dec);
        this.strProagramAreaAVersion = dec.deserializeOctetString();
        this.strProagramAreaBVersion = dec.deserializeOctetString();
        this.strDataAreaAVersion = dec.deserializeOctetString();
        this.strDataAreaBVersion = dec.deserializeOctetString();
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iMainboardID = ");
        this.iMainboardID.print(os, indent + 2);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iProagramActiveArea = ");
        this.iProagramActiveArea.print(os, indent + 2);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iDataActiveArea = ");
        this.iDataActiveArea.print(os, indent + 2);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("strProagramAreaAVersion = ");
        os.print(FStruFormat.convertToString((byte[])this.strProagramAreaAVersion));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("strProagramAreaBVersion = ");
        os.print(FStruFormat.convertToString((byte[])this.strProagramAreaBVersion));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("strDataAreaAVersion = ");
        os.print(FStruFormat.convertToString((byte[])this.strDataAreaAVersion));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("strDataAreaBVersion = ");
        os.print(FStruFormat.convertToString((byte[])this.strDataAreaBVersion));
        os.println();
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

