/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.asndatacenter;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class AsnFileInfo
implements FStruct {
    public byte[] strFileName;
    public BigInteger iContentType;
    public boolean bIsExist;

    public AsnFileInfo() {
    }

    public AsnFileInfo(AsnFileInfo arg) {
        this.strFileName = new byte[arg.strFileName.length];
        System.arraycopy(arg.strFileName, 0, this.strFileName, 0, arg.strFileName.length);
        this.iContentType = arg.iContentType;
        this.bIsExist = arg.bIsExist;
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeOctetString(this.strFileName);
        enc.serializeInteger(this.iContentType);
        enc.serializeBoolean(this.bIsExist);
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.strFileName = dec.deserializeOctetString();
        this.iContentType = dec.deserializeInteger();
        this.bIsExist = dec.deserializeBoolean();
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("strFileName = ");
        os.print(FStruFormat.convertToString((byte[])this.strFileName));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iContentType = ");
        os.print(this.iContentType.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("bIsExist = ");
        os.print(this.bIsExist);
        os.println();
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

