/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.asndatacenter;

import com.huawei.dc.common.asndatacenter.AsnFileOnDevList;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class AsnDirectory
implements FStruct {
    public byte[] strDirectoryName;
    public BigInteger iStorageSpaceSize;
    public BigInteger iStorageFreeSpaceSize;
    public AsnFileOnDevList oFilelist = new AsnFileOnDevList();

    public AsnDirectory() {
    }

    public AsnDirectory(AsnDirectory arg) {
        this.strDirectoryName = new byte[arg.strDirectoryName.length];
        System.arraycopy(arg.strDirectoryName, 0, this.strDirectoryName, 0, arg.strDirectoryName.length);
        this.iStorageSpaceSize = arg.iStorageSpaceSize;
        this.iStorageFreeSpaceSize = arg.iStorageFreeSpaceSize;
        this.oFilelist = new AsnFileOnDevList(arg.oFilelist);
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeOctetString(this.strDirectoryName);
        enc.serializeInteger(this.iStorageSpaceSize);
        enc.serializeInteger(this.iStorageFreeSpaceSize);
        this.oFilelist.serialize(enc);
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.strDirectoryName = dec.deserializeOctetString();
        this.iStorageSpaceSize = dec.deserializeInteger();
        this.iStorageFreeSpaceSize = dec.deserializeInteger();
        this.oFilelist.deserialize(dec);
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("strDirectoryName = ");
        os.print(FStruFormat.convertToString((byte[])this.strDirectoryName));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iStorageSpaceSize = ");
        os.print(this.iStorageSpaceSize.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iStorageFreeSpaceSize = ");
        os.print(this.iStorageFreeSpaceSize.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("oFilelist = ");
        this.oFilelist.print(os, indent + 2);
        os.println();
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

