/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.asndatacenter;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class AsnDCTKOperLogReq
implements FStruct {
    public BigInteger iUserID;
    public BigInteger iOperType;
    public BigInteger iModuleID;
    public BigInteger iErrorCode;
    public byte[] sOperObject;
    public byte[] sLogText;
    public byte[] sTimeInfo;

    public AsnDCTKOperLogReq() {
    }

    public AsnDCTKOperLogReq(AsnDCTKOperLogReq arg) {
        this.iUserID = arg.iUserID;
        this.iOperType = arg.iOperType;
        this.iModuleID = arg.iModuleID;
        this.iErrorCode = arg.iErrorCode;
        this.sOperObject = new byte[arg.sOperObject.length];
        System.arraycopy(arg.sOperObject, 0, this.sOperObject, 0, arg.sOperObject.length);
        this.sLogText = new byte[arg.sLogText.length];
        System.arraycopy(arg.sLogText, 0, this.sLogText, 0, arg.sLogText.length);
        this.sTimeInfo = new byte[arg.sTimeInfo.length];
        System.arraycopy(arg.sTimeInfo, 0, this.sTimeInfo, 0, arg.sTimeInfo.length);
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeInteger(this.iUserID);
        enc.serializeInteger(this.iOperType);
        enc.serializeInteger(this.iModuleID);
        enc.serializeInteger(this.iErrorCode);
        enc.serializeOctetString(this.sOperObject);
        enc.serializeOctetString(this.sLogText);
        enc.serializeOctetString(this.sTimeInfo);
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.iUserID = dec.deserializeInteger();
        this.iOperType = dec.deserializeInteger();
        this.iModuleID = dec.deserializeInteger();
        this.iErrorCode = dec.deserializeInteger();
        this.sOperObject = dec.deserializeOctetString();
        this.sLogText = dec.deserializeOctetString();
        this.sTimeInfo = dec.deserializeOctetString();
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iUserID = ");
        os.print(this.iUserID.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iOperType = ");
        os.print(this.iOperType.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iModuleID = ");
        os.print(this.iModuleID.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iErrorCode = ");
        os.print(this.iErrorCode.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("sOperObject = ");
        os.print(FStruFormat.convertToString((byte[])this.sOperObject));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("sLogText = ");
        os.print(FStruFormat.convertToString((byte[])this.sLogText));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("sTimeInfo = ");
        os.print(FStruFormat.convertToString((byte[])this.sTimeInfo));
        os.println();
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

