/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.asndatacenter;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class AsnDCSubSlotInfo
implements FStruct {
    public BigInteger iSubSlotId;
    public byte[] strSubSlotLabel = null;
    public BigInteger iSubSlotType;
    public byte[] strBoardVersion = null;

    public AsnDCSubSlotInfo() {
    }

    public AsnDCSubSlotInfo(AsnDCSubSlotInfo arg) {
        this.iSubSlotId = arg.iSubSlotId;
        if (arg.strSubSlotLabel != null) {
            this.strSubSlotLabel = new byte[arg.strSubSlotLabel.length];
            System.arraycopy(arg.strSubSlotLabel, 0, this.strSubSlotLabel, 0, arg.strSubSlotLabel.length);
        }
        this.iSubSlotType = arg.iSubSlotType;
        if (arg.strBoardVersion != null) {
            this.strBoardVersion = new byte[arg.strBoardVersion.length];
            System.arraycopy(arg.strBoardVersion, 0, this.strBoardVersion, 0, arg.strBoardVersion.length);
        }
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeInteger(this.iSubSlotId);
        if (this.strSubSlotLabel != null) {
            enc.serializeOctetString(this.strSubSlotLabel);
        }
        enc.serializeInteger(this.iSubSlotType);
        if (this.strBoardVersion != null) {
            enc.serializeOctetString(this.strBoardVersion);
        }
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.iSubSlotId = dec.deserializeInteger();
        if (!dec.isNextOptional(Decoder.buildTag((int)0, (int)4))) {
            this.strSubSlotLabel = dec.deserializeOctetString();
        }
        this.iSubSlotType = dec.deserializeInteger();
        if (!dec.isNextOptional(Decoder.buildTag((int)0, (int)4))) {
            this.strBoardVersion = dec.deserializeOctetString();
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iSubSlotId = ");
        os.print(this.iSubSlotId.toString());
        os.println(',');
        if (this.strSubSlotLabel != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("strSubSlotLabel = ");
            os.print(FStruFormat.convertToString((byte[])this.strSubSlotLabel));
            os.println(',');
        }
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iSubSlotType = ");
        os.print(this.iSubSlotType.toString());
        os.println(',');
        if (this.strBoardVersion != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("strBoardVersion = ");
            os.print(FStruFormat.convertToString((byte[])this.strBoardVersion));
            os.println();
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

