/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.asndatacenter;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;

public class AsnDCProgressNotify
implements FStruct {
    public BigInteger iDeviceId;
    public BigInteger iPercentageProgress;
    public BigInteger iFailureReasonOpt = null;

    public AsnDCProgressNotify() {
    }

    public AsnDCProgressNotify(AsnDCProgressNotify arg) {
        this.iDeviceId = arg.iDeviceId;
        this.iPercentageProgress = arg.iPercentageProgress;
        if (arg.iFailureReasonOpt != null) {
            this.iFailureReasonOpt = arg.iFailureReasonOpt;
        }
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeInteger(this.iDeviceId);
        enc.serializeInteger(this.iPercentageProgress);
        if (this.iFailureReasonOpt != null) {
            enc.serializeInteger(this.iFailureReasonOpt);
        }
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.iDeviceId = dec.deserializeInteger();
        this.iPercentageProgress = dec.deserializeInteger();
        if (!dec.isNextOptional(Decoder.buildTag((int)0, (int)2))) {
            this.iFailureReasonOpt = dec.deserializeInteger();
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iDeviceId = ");
        os.print(this.iDeviceId.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iPercentageProgress = ");
        os.print(this.iPercentageProgress.toString());
        os.println(',');
        if (this.iFailureReasonOpt != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("iFailureReasonOpt = ");
            os.print(this.iFailureReasonOpt.toString());
            os.println();
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

