/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.asndatacenter;

import com.huawei.dc.common.asndatacenter.AsnCheckResultTypeEnum;
import com.huawei.dc.common.asndatacenter.AsnDCErrorCodeInfo;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Calendar;
import java.util.GregorianCalendar;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class AsnDCNodeAttrEx
implements FStruct {
    public AsnDCErrorCodeInfo oErrorInfo = null;
    public AsnCheckResultTypeEnum oCheckResultTypeEnum = new AsnCheckResultTypeEnum();
    public byte[] strCmdResult = null;
    public Calendar oStartTime = null;
    public Calendar oEndTime = null;

    public AsnDCNodeAttrEx() {
    }

    public AsnDCNodeAttrEx(AsnDCNodeAttrEx arg) {
        if (arg.oErrorInfo != null) {
            this.oErrorInfo = new AsnDCErrorCodeInfo(arg.oErrorInfo);
        }
        this.oCheckResultTypeEnum = new AsnCheckResultTypeEnum(arg.oCheckResultTypeEnum);
        if (arg.strCmdResult != null) {
            this.strCmdResult = new byte[arg.strCmdResult.length];
            System.arraycopy(arg.strCmdResult, 0, this.strCmdResult, 0, arg.strCmdResult.length);
        }
        if (arg.oStartTime != null) {
            this.oStartTime = (Calendar)arg.oStartTime.clone();
        }
        if (arg.oEndTime != null) {
            this.oEndTime = (Calendar)arg.oEndTime.clone();
        }
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        if (this.oErrorInfo != null) {
            this.oErrorInfo.serialize(enc);
        }
        this.oCheckResultTypeEnum.serialize(enc);
        if (this.strCmdResult != null) {
            enc.serializeOctetString(this.strCmdResult);
        }
        if (this.oStartTime != null) {
            int ex_id_oStartTime1 = enc.serializeExplicit(Encoder.buildTag((int)2, (int)0));
            enc.serializeUTCTime(this.oStartTime);
            enc.finishedBy(ex_id_oStartTime1);
        }
        if (this.oEndTime != null) {
            int ex_id_oEndTime1 = enc.serializeExplicit(Encoder.buildTag((int)2, (int)1));
            enc.serializeUTCTime(this.oEndTime);
            enc.finishedBy(ex_id_oEndTime1);
        }
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        if (!dec.isNextOptional(Decoder.buildTag((int)0, (int)16))) {
            this.oErrorInfo = new AsnDCErrorCodeInfo();
            this.oErrorInfo.deserialize(dec);
        }
        this.oCheckResultTypeEnum.deserialize(dec);
        if (!dec.isNextOptional(Decoder.buildTag((int)0, (int)4))) {
            this.strCmdResult = dec.deserializeOctetString();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)0))) {
            this.oStartTime = new GregorianCalendar();
            int ex_id_oStartTime1 = dec.deserializeExplicit(Decoder.buildTag((int)2, (int)0));
            this.oStartTime = dec.deserializeUTCTime();
            dec.finishedBy(ex_id_oStartTime1);
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)1))) {
            this.oEndTime = new GregorianCalendar();
            int ex_id_oEndTime1 = dec.deserializeExplicit(Decoder.buildTag((int)2, (int)1));
            this.oEndTime = dec.deserializeUTCTime();
            dec.finishedBy(ex_id_oEndTime1);
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        if (this.oErrorInfo != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("oErrorInfo = ");
            this.oErrorInfo.print(os, indent + 2);
            os.println(',');
        }
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("oCheckResultTypeEnum = ");
        this.oCheckResultTypeEnum.print(os, indent + 2);
        os.println(',');
        if (this.strCmdResult != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("strCmdResult = ");
            os.print(FStruFormat.convertToString((byte[])this.strCmdResult));
            os.println(',');
        }
        if (this.oStartTime != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("oStartTime = ");
            os.print(this.oStartTime.getTime().toString());
            os.println(',');
        }
        if (this.oEndTime != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("oEndTime = ");
            os.print(this.oEndTime.getTime().toString());
            os.println();
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

