/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.asndatacenter;

import com.huawei.dc.common.asndatacenter.AsnActivationTypeEnum;
import com.huawei.dc.common.asndatacenter.AsnBoard;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.GregorianCalendar;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class AsnDCManualRecoverInfo
implements FStruct {
    public BigInteger iDeviceId;
    public BigInteger iContentType = null;
    public byte[] strFileName;
    public BigInteger iUserId = null;
    public AsnActivationTypeEnum enReboot = new AsnActivationTypeEnum();
    public AsnBoard oBoard = null;
    public Calendar oSchRebootTime = null;
    public boolean bDeliverToBoardReboot;
    public boolean bIsSupportFolder;
    public boolean bIsByAgent;
    public boolean _bIsByAgent = false;
    public byte[] strServerName;

    public AsnDCManualRecoverInfo() {
    }

    public AsnDCManualRecoverInfo(AsnDCManualRecoverInfo arg) {
        this.iDeviceId = arg.iDeviceId;
        if (arg.iContentType != null) {
            this.iContentType = arg.iContentType;
        }
        this.strFileName = new byte[arg.strFileName.length];
        System.arraycopy(arg.strFileName, 0, this.strFileName, 0, arg.strFileName.length);
        if (arg.iUserId != null) {
            this.iUserId = arg.iUserId;
        }
        this.enReboot = new AsnActivationTypeEnum(arg.enReboot);
        if (arg.oBoard != null) {
            this.oBoard = new AsnBoard(arg.oBoard);
        }
        if (arg.oSchRebootTime != null) {
            this.oSchRebootTime = (Calendar)arg.oSchRebootTime.clone();
        }
        this.bDeliverToBoardReboot = arg.bDeliverToBoardReboot;
        this.bIsSupportFolder = arg.bIsSupportFolder;
        this._bIsByAgent = arg._bIsByAgent;
        this.bIsByAgent = arg.bIsByAgent;
        this.strServerName = new byte[arg.strServerName.length];
        System.arraycopy(arg.strServerName, 0, this.strServerName, 0, arg.strServerName.length);
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeInteger(this.iDeviceId);
        if (this.iContentType != null) {
            enc.serializeInteger(this.iContentType);
        }
        enc.serializeOctetString(this.strFileName);
        if (this.iUserId != null) {
            enc.serializeInteger(this.iUserId);
        }
        this.enReboot.serialize(enc);
        if (this.oBoard != null) {
            this.oBoard.serialize(enc);
        }
        if (this.oSchRebootTime != null) {
            enc.serializeUTCTime(this.oSchRebootTime);
        }
        enc.serializeBoolean(this.bDeliverToBoardReboot);
        enc.serializeBoolean(this.bIsSupportFolder);
        if (this._bIsByAgent) {
            enc.serializeBoolean(this.bIsByAgent);
        }
        enc.serializeOctetString(this.strServerName);
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.iDeviceId = dec.deserializeInteger();
        if (!dec.isNextOptional(Decoder.buildTag((int)0, (int)2))) {
            this.iContentType = dec.deserializeInteger();
        }
        this.strFileName = dec.deserializeOctetString();
        if (!dec.isNextOptional(Decoder.buildTag((int)0, (int)2))) {
            this.iUserId = dec.deserializeInteger();
        }
        this.enReboot.deserialize(dec);
        if (!dec.isNextOptional(Decoder.buildTag((int)0, (int)10))) {
            this.oBoard = new AsnBoard();
            this.oBoard.deserialize(dec);
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)0, (int)23))) {
            this.oSchRebootTime = new GregorianCalendar();
            this.oSchRebootTime = dec.deserializeUTCTime();
        }
        this.bDeliverToBoardReboot = dec.deserializeBoolean();
        this.bIsSupportFolder = dec.deserializeBoolean();
        if (!dec.isNextOptional(Decoder.buildTag((int)0, (int)1))) {
            this.bIsByAgent = dec.deserializeBoolean();
        }
        this.strServerName = dec.deserializeOctetString();
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iDeviceId = ");
        os.print(this.iDeviceId.toString());
        os.println(',');
        if (this.iContentType != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("iContentType = ");
            os.print(this.iContentType.toString());
            os.println(',');
        }
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("strFileName = ");
        os.print(FStruFormat.convertToString((byte[])this.strFileName));
        os.println(',');
        if (this.iUserId != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("iUserId = ");
            os.print(this.iUserId.toString());
            os.println(',');
        }
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("enReboot = ");
        this.enReboot.print(os, indent + 2);
        os.println(',');
        if (this.oBoard != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("oBoard = ");
            this.oBoard.print(os, indent + 2);
            os.println(',');
        }
        if (this.oSchRebootTime != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("oSchRebootTime = ");
            os.print(this.oSchRebootTime.getTime().toString());
            os.println(',');
        }
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("bDeliverToBoardReboot = ");
        os.print(this.bDeliverToBoardReboot);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("bIsSupportFolder = ");
        os.print(this.bIsSupportFolder);
        os.println(',');
        if (this._bIsByAgent) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("bIsByAgent = ");
            os.print(this.bIsByAgent);
            os.println(',');
        }
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("strServerName = ");
        os.print(FStruFormat.convertToString((byte[])this.strServerName));
        os.println();
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

