/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.asndatacenter;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;

public class AsnDCManualBackupInfo
implements FStruct {
    public BigInteger iDeviceID;
    public BigInteger iContentType = null;
    public boolean bSaveBeforeBackup;
    public boolean _bSaveBeforeBackup = false;

    public AsnDCManualBackupInfo() {
    }

    public AsnDCManualBackupInfo(AsnDCManualBackupInfo arg) {
        this.iDeviceID = arg.iDeviceID;
        if (arg.iContentType != null) {
            this.iContentType = arg.iContentType;
        }
        this._bSaveBeforeBackup = arg._bSaveBeforeBackup;
        this.bSaveBeforeBackup = arg.bSaveBeforeBackup;
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeInteger(this.iDeviceID);
        if (this.iContentType != null) {
            enc.serializeInteger(this.iContentType);
        }
        if (this._bSaveBeforeBackup) {
            enc.serializeBoolean(this.bSaveBeforeBackup);
        }
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.iDeviceID = dec.deserializeInteger();
        if (!dec.isNextOptional(Decoder.buildTag((int)0, (int)2))) {
            this.iContentType = dec.deserializeInteger();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)0, (int)1))) {
            this.bSaveBeforeBackup = dec.deserializeBoolean();
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iDeviceID = ");
        os.print(this.iDeviceID.toString());
        os.println(',');
        if (this.iContentType != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("iContentType = ");
            os.print(this.iContentType.toString());
            os.println(',');
        }
        if (this._bSaveBeforeBackup) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("bSaveBeforeBackup = ");
            os.print(this.bSaveBeforeBackup);
            os.println();
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

