/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.asndatacenter;

import com.huawei.dc.common.asndatacenter.AsnDCDeviceOperationEnum;
import com.huawei.dc.common.asndatacenter.AsnDCDeviceOpertionResultEnum;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.GregorianCalendar;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class AsnDCLogInfo
implements FStruct {
    public BigInteger iId;
    public BigInteger iDeviceId;
    public byte[] strDeviceName;
    public byte[] strDeviceIPAddress;
    public byte[] strDeviceType;
    public byte[] strDeviceTypeVersion;
    public byte[] strUserName;
    public byte[] strClientIp;
    public AsnDCDeviceOperationEnum oDeviceOperationType = new AsnDCDeviceOperationEnum();
    public byte[] strCustomOperID = null;
    public Calendar oStartTime = new GregorianCalendar();
    public Calendar oEndTime = new GregorianCalendar();
    public AsnDCDeviceOpertionResultEnum oResult = new AsnDCDeviceOpertionResultEnum();
    public BigInteger iReasonId;
    public byte[] strFilePath;
    public byte[] strFaliureReason = null;

    public AsnDCLogInfo() {
    }

    public AsnDCLogInfo(AsnDCLogInfo arg) {
        this.iId = arg.iId;
        this.iDeviceId = arg.iDeviceId;
        this.strDeviceName = new byte[arg.strDeviceName.length];
        System.arraycopy(arg.strDeviceName, 0, this.strDeviceName, 0, arg.strDeviceName.length);
        this.strDeviceIPAddress = new byte[arg.strDeviceIPAddress.length];
        System.arraycopy(arg.strDeviceIPAddress, 0, this.strDeviceIPAddress, 0, arg.strDeviceIPAddress.length);
        this.strDeviceType = new byte[arg.strDeviceType.length];
        System.arraycopy(arg.strDeviceType, 0, this.strDeviceType, 0, arg.strDeviceType.length);
        this.strDeviceTypeVersion = new byte[arg.strDeviceTypeVersion.length];
        System.arraycopy(arg.strDeviceTypeVersion, 0, this.strDeviceTypeVersion, 0, arg.strDeviceTypeVersion.length);
        this.strUserName = new byte[arg.strUserName.length];
        System.arraycopy(arg.strUserName, 0, this.strUserName, 0, arg.strUserName.length);
        this.strClientIp = new byte[arg.strClientIp.length];
        System.arraycopy(arg.strClientIp, 0, this.strClientIp, 0, arg.strClientIp.length);
        this.oDeviceOperationType = new AsnDCDeviceOperationEnum(arg.oDeviceOperationType);
        if (arg.strCustomOperID != null) {
            this.strCustomOperID = new byte[arg.strCustomOperID.length];
            System.arraycopy(arg.strCustomOperID, 0, this.strCustomOperID, 0, arg.strCustomOperID.length);
        }
        this.oStartTime = (Calendar)arg.oStartTime.clone();
        this.oEndTime = (Calendar)arg.oEndTime.clone();
        this.oResult = new AsnDCDeviceOpertionResultEnum(arg.oResult);
        this.iReasonId = arg.iReasonId;
        this.strFilePath = new byte[arg.strFilePath.length];
        System.arraycopy(arg.strFilePath, 0, this.strFilePath, 0, arg.strFilePath.length);
        if (arg.strFaliureReason != null) {
            this.strFaliureReason = new byte[arg.strFaliureReason.length];
            System.arraycopy(arg.strFaliureReason, 0, this.strFaliureReason, 0, arg.strFaliureReason.length);
        }
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeInteger(this.iId);
        enc.serializeInteger(this.iDeviceId);
        enc.serializeOctetString(this.strDeviceName);
        enc.serializeOctetString(this.strDeviceIPAddress);
        enc.serializeOctetString(this.strDeviceType);
        enc.serializeOctetString(this.strDeviceTypeVersion);
        enc.serializeOctetString(this.strUserName);
        enc.serializeOctetString(this.strClientIp);
        this.oDeviceOperationType.serialize(enc);
        if (this.strCustomOperID != null) {
            enc.serializeOctetString(this.strCustomOperID);
        }
        enc.serializeUTCTime(this.oStartTime);
        enc.serializeUTCTime(this.oEndTime);
        this.oResult.serialize(enc);
        enc.serializeInteger(this.iReasonId);
        enc.serializeOctetString(this.strFilePath);
        if (this.strFaliureReason != null) {
            enc.serializeOctetString(this.strFaliureReason);
        }
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.iId = dec.deserializeInteger();
        this.iDeviceId = dec.deserializeInteger();
        this.strDeviceName = dec.deserializeOctetString();
        this.strDeviceIPAddress = dec.deserializeOctetString();
        this.strDeviceType = dec.deserializeOctetString();
        this.strDeviceTypeVersion = dec.deserializeOctetString();
        this.strUserName = dec.deserializeOctetString();
        this.strClientIp = dec.deserializeOctetString();
        this.oDeviceOperationType.deserialize(dec);
        if (!dec.isNextOptional(Decoder.buildTag((int)0, (int)4))) {
            this.strCustomOperID = dec.deserializeOctetString();
        }
        this.oStartTime = dec.deserializeUTCTime();
        this.oEndTime = dec.deserializeUTCTime();
        this.oResult.deserialize(dec);
        this.iReasonId = dec.deserializeInteger();
        this.strFilePath = dec.deserializeOctetString();
        if (!dec.isNextOptional(Decoder.buildTag((int)0, (int)4))) {
            this.strFaliureReason = dec.deserializeOctetString();
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iId = ");
        os.print(this.iId.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iDeviceId = ");
        os.print(this.iDeviceId.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("strDeviceName = ");
        os.print(FStruFormat.convertToString((byte[])this.strDeviceName));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("strDeviceIPAddress = ");
        os.print(FStruFormat.convertToString((byte[])this.strDeviceIPAddress));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("strDeviceType = ");
        os.print(FStruFormat.convertToString((byte[])this.strDeviceType));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("strDeviceTypeVersion = ");
        os.print(FStruFormat.convertToString((byte[])this.strDeviceTypeVersion));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("strUserName = ");
        os.print(FStruFormat.convertToString((byte[])this.strUserName));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("strClientIp = ");
        os.print(FStruFormat.convertToString((byte[])this.strClientIp));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("oDeviceOperationType = ");
        this.oDeviceOperationType.print(os, indent + 2);
        os.println(',');
        if (this.strCustomOperID != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("strCustomOperID = ");
            os.print(FStruFormat.convertToString((byte[])this.strCustomOperID));
            os.println(',');
        }
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("oStartTime = ");
        os.print(this.oStartTime.getTime().toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("oEndTime = ");
        os.print(this.oEndTime.getTime().toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("oResult = ");
        this.oResult.print(os, indent + 2);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iReasonId = ");
        os.print(this.iReasonId.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("strFilePath = ");
        os.print(FStruFormat.convertToString((byte[])this.strFilePath));
        os.println(',');
        if (this.strFaliureReason != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("strFaliureReason = ");
            os.print(FStruFormat.convertToString((byte[])this.strFaliureReason));
            os.println();
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

