/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.asndatacenter;

import com.huawei.dc.common.asndatacenter.AsnDCErrorCodeInfo;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class AsnDCLoadBoardInfo
implements FStruct {
    public BigInteger iFrameId;
    public BigInteger iSlotId;
    public byte[] strBoardName;
    public AsnDCErrorCodeInfo result = null;
    public byte[] strFaliureReason = null;

    public AsnDCLoadBoardInfo() {
    }

    public AsnDCLoadBoardInfo(AsnDCLoadBoardInfo arg) {
        this.iFrameId = arg.iFrameId;
        this.iSlotId = arg.iSlotId;
        this.strBoardName = new byte[arg.strBoardName.length];
        System.arraycopy(arg.strBoardName, 0, this.strBoardName, 0, arg.strBoardName.length);
        if (arg.result != null) {
            this.result = new AsnDCErrorCodeInfo(arg.result);
        }
        if (arg.strFaliureReason != null) {
            this.strFaliureReason = new byte[arg.strFaliureReason.length];
            System.arraycopy(arg.strFaliureReason, 0, this.strFaliureReason, 0, arg.strFaliureReason.length);
        }
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeInteger(this.iFrameId);
        enc.serializeInteger(this.iSlotId);
        enc.serializeOctetString(this.strBoardName);
        if (this.result != null) {
            int ex_id_result1 = enc.serializeExplicit(Encoder.buildTag((int)2, (int)1));
            this.result.serialize(enc);
            enc.finishedBy(ex_id_result1);
        }
        if (this.strFaliureReason != null) {
            int ex_id_strFaliureReason1 = enc.serializeExplicit(Encoder.buildTag((int)2, (int)2));
            enc.serializeOctetString(this.strFaliureReason);
            enc.finishedBy(ex_id_strFaliureReason1);
        }
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.iFrameId = dec.deserializeInteger();
        this.iSlotId = dec.deserializeInteger();
        this.strBoardName = dec.deserializeOctetString();
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)1))) {
            this.result = new AsnDCErrorCodeInfo();
            int ex_id_result1 = dec.deserializeExplicit(Decoder.buildTag((int)2, (int)1));
            this.result.deserialize(dec);
            dec.finishedBy(ex_id_result1);
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)2))) {
            int ex_id_strFaliureReason1 = dec.deserializeExplicit(Decoder.buildTag((int)2, (int)2));
            this.strFaliureReason = dec.deserializeOctetString();
            dec.finishedBy(ex_id_strFaliureReason1);
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iFrameId = ");
        os.print(this.iFrameId.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iSlotId = ");
        os.print(this.iSlotId.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("strBoardName = ");
        os.print(FStruFormat.convertToString((byte[])this.strBoardName));
        os.println(',');
        if (this.result != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("result = ");
            this.result.print(os, indent + 2);
            os.println(',');
        }
        if (this.strFaliureReason != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("strFaliureReason = ");
            os.print(FStruFormat.convertToString((byte[])this.strFaliureReason));
            os.println();
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

