/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.asndatacenter;

import com.huawei.dc.common.asndatacenter.AsnDCBoardList;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class AsnDCFrameInfo
implements FStruct {
    public BigInteger iFrameId;
    public byte[] strFrameLabel = null;
    public BigInteger iFrameType;
    public AsnDCBoardList oBoardList = new AsnDCBoardList();

    public AsnDCFrameInfo() {
    }

    public AsnDCFrameInfo(AsnDCFrameInfo arg) {
        this.iFrameId = arg.iFrameId;
        if (arg.strFrameLabel != null) {
            this.strFrameLabel = new byte[arg.strFrameLabel.length];
            System.arraycopy(arg.strFrameLabel, 0, this.strFrameLabel, 0, arg.strFrameLabel.length);
        }
        this.iFrameType = arg.iFrameType;
        this.oBoardList = new AsnDCBoardList(arg.oBoardList);
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeInteger(this.iFrameId);
        if (this.strFrameLabel != null) {
            enc.serializeOctetString(this.strFrameLabel);
        }
        enc.serializeInteger(this.iFrameType);
        this.oBoardList.serialize(enc);
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.iFrameId = dec.deserializeInteger();
        if (!dec.isNextOptional(Decoder.buildTag((int)0, (int)4))) {
            this.strFrameLabel = dec.deserializeOctetString();
        }
        this.iFrameType = dec.deserializeInteger();
        this.oBoardList.deserialize(dec);
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iFrameId = ");
        os.print(this.iFrameId.toString());
        os.println(',');
        if (this.strFrameLabel != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("strFrameLabel = ");
            os.print(FStruFormat.convertToString((byte[])this.strFrameLabel));
            os.println(',');
        }
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iFrameType = ");
        os.print(this.iFrameType.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("oBoardList = ");
        this.oBoardList.print(os, indent + 2);
        os.println();
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

