/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.asndatacenter;

import com.huawei.dc.common.asndatacenter.AsnBackUpFileList;
import com.huawei.dc.common.asndatacenter.AsnDCDeviceOperationEnum;
import com.huawei.dc.common.asndatacenter.AsnDCErrorCodeInfo;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class AsnDCFileTransferNotification
implements FStruct {
    public AsnDCErrorCodeInfo oErrorInfo = new AsnDCErrorCodeInfo();
    public BigInteger oReqID;
    public BigInteger iDeviceID = null;
    public AsnDCDeviceOperationEnum oDeviceOperationType = null;
    public BigInteger iFileCount = null;
    public BigInteger iCompletedFile = null;
    public AsnBackUpFileList oAsnFilesPathLst = null;
    public byte[] strClientPath = null;
    public BigInteger iContentType = null;

    public AsnDCFileTransferNotification() {
    }

    public AsnDCFileTransferNotification(AsnDCFileTransferNotification arg) {
        this.oErrorInfo = new AsnDCErrorCodeInfo(arg.oErrorInfo);
        this.oReqID = arg.oReqID;
        if (arg.iDeviceID != null) {
            this.iDeviceID = arg.iDeviceID;
        }
        if (arg.oDeviceOperationType != null) {
            this.oDeviceOperationType = new AsnDCDeviceOperationEnum(arg.oDeviceOperationType);
        }
        if (arg.iFileCount != null) {
            this.iFileCount = arg.iFileCount;
        }
        if (arg.iCompletedFile != null) {
            this.iCompletedFile = arg.iCompletedFile;
        }
        if (arg.oAsnFilesPathLst != null) {
            this.oAsnFilesPathLst = new AsnBackUpFileList(arg.oAsnFilesPathLst);
        }
        if (arg.strClientPath != null) {
            this.strClientPath = new byte[arg.strClientPath.length];
            System.arraycopy(arg.strClientPath, 0, this.strClientPath, 0, arg.strClientPath.length);
        }
        if (arg.iContentType != null) {
            this.iContentType = arg.iContentType;
        }
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        this.oErrorInfo.serialize(enc);
        enc.serializeInteger(this.oReqID);
        if (this.iDeviceID != null) {
            enc.serializeInteger(this.iDeviceID);
        }
        if (this.oDeviceOperationType != null) {
            this.oDeviceOperationType.serialize(enc);
        }
        if (this.iFileCount != null) {
            int ex_id_iFileCount1 = enc.serializeExplicit(Encoder.buildTag((int)2, (int)0));
            enc.serializeInteger(this.iFileCount);
            enc.finishedBy(ex_id_iFileCount1);
        }
        if (this.iCompletedFile != null) {
            int ex_id_iCompletedFile1 = enc.serializeExplicit(Encoder.buildTag((int)2, (int)1));
            enc.serializeInteger(this.iCompletedFile);
            enc.finishedBy(ex_id_iCompletedFile1);
        }
        if (this.oAsnFilesPathLst != null) {
            int ex_id_oAsnFilesPathLst1 = enc.serializeExplicit(Encoder.buildTag((int)2, (int)2));
            this.oAsnFilesPathLst.serialize(enc);
            enc.finishedBy(ex_id_oAsnFilesPathLst1);
        }
        if (this.strClientPath != null) {
            int ex_id_strClientPath1 = enc.serializeExplicit(Encoder.buildTag((int)2, (int)3));
            enc.serializeOctetString(this.strClientPath);
            enc.finishedBy(ex_id_strClientPath1);
        }
        if (this.iContentType != null) {
            int ex_id_iContentType1 = enc.serializeExplicit(Encoder.buildTag((int)2, (int)4));
            enc.serializeInteger(this.iContentType);
            enc.finishedBy(ex_id_iContentType1);
        }
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.oErrorInfo.deserialize(dec);
        this.oReqID = dec.deserializeInteger();
        if (!dec.isNextOptional(Decoder.buildTag((int)0, (int)2))) {
            this.iDeviceID = dec.deserializeInteger();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)0, (int)10))) {
            this.oDeviceOperationType = new AsnDCDeviceOperationEnum();
            this.oDeviceOperationType.deserialize(dec);
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)0))) {
            int ex_id_iFileCount1 = dec.deserializeExplicit(Decoder.buildTag((int)2, (int)0));
            this.iFileCount = dec.deserializeInteger();
            dec.finishedBy(ex_id_iFileCount1);
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)1))) {
            int ex_id_iCompletedFile1 = dec.deserializeExplicit(Decoder.buildTag((int)2, (int)1));
            this.iCompletedFile = dec.deserializeInteger();
            dec.finishedBy(ex_id_iCompletedFile1);
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)2))) {
            this.oAsnFilesPathLst = new AsnBackUpFileList();
            int ex_id_oAsnFilesPathLst1 = dec.deserializeExplicit(Decoder.buildTag((int)2, (int)2));
            this.oAsnFilesPathLst.deserialize(dec);
            dec.finishedBy(ex_id_oAsnFilesPathLst1);
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)3))) {
            int ex_id_strClientPath1 = dec.deserializeExplicit(Decoder.buildTag((int)2, (int)3));
            this.strClientPath = dec.deserializeOctetString();
            dec.finishedBy(ex_id_strClientPath1);
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)4))) {
            int ex_id_iContentType1 = dec.deserializeExplicit(Decoder.buildTag((int)2, (int)4));
            this.iContentType = dec.deserializeInteger();
            dec.finishedBy(ex_id_iContentType1);
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("oErrorInfo = ");
        this.oErrorInfo.print(os, indent + 2);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("oReqID = ");
        os.print(this.oReqID.toString());
        os.println(',');
        if (this.iDeviceID != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("iDeviceID = ");
            os.print(this.iDeviceID.toString());
            os.println(',');
        }
        if (this.oDeviceOperationType != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("oDeviceOperationType = ");
            this.oDeviceOperationType.print(os, indent + 2);
            os.println(',');
        }
        if (this.iFileCount != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("iFileCount = ");
            os.print(this.iFileCount.toString());
            os.println(',');
        }
        if (this.iCompletedFile != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("iCompletedFile = ");
            os.print(this.iCompletedFile.toString());
            os.println(',');
        }
        if (this.oAsnFilesPathLst != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("oAsnFilesPathLst = ");
            this.oAsnFilesPathLst.print(os, indent + 2);
            os.println(',');
        }
        if (this.strClientPath != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("strClientPath = ");
            os.print(FStruFormat.convertToString((byte[])this.strClientPath));
            os.println(',');
        }
        if (this.iContentType != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("iContentType = ");
            os.print(this.iContentType.toString());
            os.println();
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

