/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.asndatacenter;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.GregorianCalendar;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class AsnDCFile
implements FStruct {
    public BigInteger iContentType = null;
    public byte[] strTimeOrFileName;
    public BigInteger iBoardType = null;
    public BigInteger iSequenceNo = null;
    public BigInteger iFileSize = null;
    public Calendar time = null;
    public byte[] strVersion = null;
    public byte[] strContentType = null;
    public BigInteger iDevType = null;
    public BigInteger iDevTypeVer = null;
    public BigInteger iFileType = null;

    public AsnDCFile() {
    }

    public AsnDCFile(AsnDCFile arg) {
        if (arg.iContentType != null) {
            this.iContentType = arg.iContentType;
        }
        this.strTimeOrFileName = new byte[arg.strTimeOrFileName.length];
        System.arraycopy(arg.strTimeOrFileName, 0, this.strTimeOrFileName, 0, arg.strTimeOrFileName.length);
        if (arg.iBoardType != null) {
            this.iBoardType = arg.iBoardType;
        }
        if (arg.iSequenceNo != null) {
            this.iSequenceNo = arg.iSequenceNo;
        }
        if (arg.iFileSize != null) {
            this.iFileSize = arg.iFileSize;
        }
        if (arg.time != null) {
            this.time = (Calendar)arg.time.clone();
        }
        if (arg.strVersion != null) {
            this.strVersion = new byte[arg.strVersion.length];
            System.arraycopy(arg.strVersion, 0, this.strVersion, 0, arg.strVersion.length);
        }
        if (arg.strContentType != null) {
            this.strContentType = new byte[arg.strContentType.length];
            System.arraycopy(arg.strContentType, 0, this.strContentType, 0, arg.strContentType.length);
        }
        if (arg.iDevType != null) {
            this.iDevType = arg.iDevType;
        }
        if (arg.iDevTypeVer != null) {
            this.iDevTypeVer = arg.iDevTypeVer;
        }
        if (arg.iFileType != null) {
            this.iFileType = arg.iFileType;
        }
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        if (this.iContentType != null) {
            enc.serializeInteger(this.iContentType);
        }
        enc.serializeOctetString(this.strTimeOrFileName);
        if (this.iBoardType != null) {
            int ex_id_iBoardType1 = enc.serializeExplicit(Encoder.buildTag((int)2, (int)0));
            enc.serializeInteger(this.iBoardType);
            enc.finishedBy(ex_id_iBoardType1);
        }
        if (this.iSequenceNo != null) {
            int ex_id_iSequenceNo1 = enc.serializeExplicit(Encoder.buildTag((int)2, (int)1));
            enc.serializeInteger(this.iSequenceNo);
            enc.finishedBy(ex_id_iSequenceNo1);
        }
        if (this.iFileSize != null) {
            int ex_id_iFileSize1 = enc.serializeExplicit(Encoder.buildTag((int)2, (int)2));
            enc.serializeInteger(this.iFileSize);
            enc.finishedBy(ex_id_iFileSize1);
        }
        if (this.time != null) {
            int ex_id_time1 = enc.serializeExplicit(Encoder.buildTag((int)2, (int)3));
            enc.serializeUTCTime(this.time);
            enc.finishedBy(ex_id_time1);
        }
        if (this.strVersion != null) {
            int ex_id_strVersion1 = enc.serializeExplicit(Encoder.buildTag((int)2, (int)4));
            enc.serializeOctetString(this.strVersion);
            enc.finishedBy(ex_id_strVersion1);
        }
        if (this.strContentType != null) {
            int ex_id_strContentType1 = enc.serializeExplicit(Encoder.buildTag((int)2, (int)5));
            enc.serializeOctetString(this.strContentType);
            enc.finishedBy(ex_id_strContentType1);
        }
        if (this.iDevType != null) {
            int ex_id_iDevType1 = enc.serializeExplicit(Encoder.buildTag((int)2, (int)6));
            enc.serializeInteger(this.iDevType);
            enc.finishedBy(ex_id_iDevType1);
        }
        if (this.iDevTypeVer != null) {
            int ex_id_iDevTypeVer1 = enc.serializeExplicit(Encoder.buildTag((int)2, (int)7));
            enc.serializeInteger(this.iDevTypeVer);
            enc.finishedBy(ex_id_iDevTypeVer1);
        }
        if (this.iFileType != null) {
            int ex_id_iFileType1 = enc.serializeExplicit(Encoder.buildTag((int)2, (int)8));
            enc.serializeInteger(this.iFileType);
            enc.finishedBy(ex_id_iFileType1);
        }
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        if (!dec.isNextOptional(Decoder.buildTag((int)0, (int)2))) {
            this.iContentType = dec.deserializeInteger();
        }
        this.strTimeOrFileName = dec.deserializeOctetString();
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)0))) {
            int ex_id_iBoardType1 = dec.deserializeExplicit(Decoder.buildTag((int)2, (int)0));
            this.iBoardType = dec.deserializeInteger();
            dec.finishedBy(ex_id_iBoardType1);
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)1))) {
            int ex_id_iSequenceNo1 = dec.deserializeExplicit(Decoder.buildTag((int)2, (int)1));
            this.iSequenceNo = dec.deserializeInteger();
            dec.finishedBy(ex_id_iSequenceNo1);
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)2))) {
            int ex_id_iFileSize1 = dec.deserializeExplicit(Decoder.buildTag((int)2, (int)2));
            this.iFileSize = dec.deserializeInteger();
            dec.finishedBy(ex_id_iFileSize1);
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)3))) {
            this.time = new GregorianCalendar();
            int ex_id_time1 = dec.deserializeExplicit(Decoder.buildTag((int)2, (int)3));
            this.time = dec.deserializeUTCTime();
            dec.finishedBy(ex_id_time1);
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)4))) {
            int ex_id_strVersion1 = dec.deserializeExplicit(Decoder.buildTag((int)2, (int)4));
            this.strVersion = dec.deserializeOctetString();
            dec.finishedBy(ex_id_strVersion1);
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)5))) {
            int ex_id_strContentType1 = dec.deserializeExplicit(Decoder.buildTag((int)2, (int)5));
            this.strContentType = dec.deserializeOctetString();
            dec.finishedBy(ex_id_strContentType1);
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)6))) {
            int ex_id_iDevType1 = dec.deserializeExplicit(Decoder.buildTag((int)2, (int)6));
            this.iDevType = dec.deserializeInteger();
            dec.finishedBy(ex_id_iDevType1);
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)7))) {
            int ex_id_iDevTypeVer1 = dec.deserializeExplicit(Decoder.buildTag((int)2, (int)7));
            this.iDevTypeVer = dec.deserializeInteger();
            dec.finishedBy(ex_id_iDevTypeVer1);
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)8))) {
            int ex_id_iFileType1 = dec.deserializeExplicit(Decoder.buildTag((int)2, (int)8));
            this.iFileType = dec.deserializeInteger();
            dec.finishedBy(ex_id_iFileType1);
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        if (this.iContentType != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("iContentType = ");
            os.print(this.iContentType.toString());
            os.println(',');
        }
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("strTimeOrFileName = ");
        os.print(FStruFormat.convertToString((byte[])this.strTimeOrFileName));
        os.println(',');
        if (this.iBoardType != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("iBoardType = ");
            os.print(this.iBoardType.toString());
            os.println(',');
        }
        if (this.iSequenceNo != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("iSequenceNo = ");
            os.print(this.iSequenceNo.toString());
            os.println(',');
        }
        if (this.iFileSize != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("iFileSize = ");
            os.print(this.iFileSize.toString());
            os.println(',');
        }
        if (this.time != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("time = ");
            os.print(this.time.getTime().toString());
            os.println(',');
        }
        if (this.strVersion != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("strVersion = ");
            os.print(FStruFormat.convertToString((byte[])this.strVersion));
            os.println(',');
        }
        if (this.strContentType != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("strContentType = ");
            os.print(FStruFormat.convertToString((byte[])this.strContentType));
            os.println(',');
        }
        if (this.iDevType != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("iDevType = ");
            os.print(this.iDevType.toString());
            os.println(',');
        }
        if (this.iDevTypeVer != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("iDevTypeVer = ");
            os.print(this.iDevTypeVer.toString());
            os.println(',');
        }
        if (this.iFileType != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("iFileType = ");
            os.print(this.iFileType.toString());
            os.println();
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

