/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.asndatacenter;

import com.huawei.dc.common.asndatacenter.AsnResultType;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class AsnDCErrorCodeInfo
implements FStruct {
    public BigInteger iErrorNo;
    public byte[] strResult = null;
    public AsnResultType oResultType = new AsnResultType();

    public AsnDCErrorCodeInfo() {
    }

    public AsnDCErrorCodeInfo(AsnDCErrorCodeInfo arg) {
        this.iErrorNo = arg.iErrorNo;
        if (arg.strResult != null) {
            this.strResult = new byte[arg.strResult.length];
            System.arraycopy(arg.strResult, 0, this.strResult, 0, arg.strResult.length);
        }
        this.oResultType = new AsnResultType(arg.oResultType);
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeInteger(this.iErrorNo);
        if (this.strResult != null) {
            enc.serializeOctetString(this.strResult);
        }
        this.oResultType.serialize(enc);
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.iErrorNo = dec.deserializeInteger();
        if (!dec.isNextOptional(Decoder.buildTag((int)0, (int)4))) {
            this.strResult = dec.deserializeOctetString();
        }
        this.oResultType.deserialize(dec);
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iErrorNo = ");
        os.print(this.iErrorNo.toString());
        os.println(',');
        if (this.strResult != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("strResult = ");
            os.print(FStruFormat.convertToString((byte[])this.strResult));
            os.println(',');
        }
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("oResultType = ");
        this.oResultType.print(os, indent + 2);
        os.println();
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

