/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.asndatacenter;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class AsnDCDeviceVersion
implements FStruct {
    public BigInteger iDeviceId;
    public byte[] strVersion;
    public BigInteger iSupportDelayReboot;
    public byte[] strPatchVersion = null;
    public byte[] strBoard = null;

    public AsnDCDeviceVersion() {
    }

    public AsnDCDeviceVersion(AsnDCDeviceVersion arg) {
        this.iDeviceId = arg.iDeviceId;
        this.strVersion = new byte[arg.strVersion.length];
        System.arraycopy(arg.strVersion, 0, this.strVersion, 0, arg.strVersion.length);
        this.iSupportDelayReboot = arg.iSupportDelayReboot;
        if (arg.strPatchVersion != null) {
            this.strPatchVersion = new byte[arg.strPatchVersion.length];
            System.arraycopy(arg.strPatchVersion, 0, this.strPatchVersion, 0, arg.strPatchVersion.length);
        }
        if (arg.strBoard != null) {
            this.strBoard = new byte[arg.strBoard.length];
            System.arraycopy(arg.strBoard, 0, this.strBoard, 0, arg.strBoard.length);
        }
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeInteger(this.iDeviceId);
        enc.serializeOctetString(this.strVersion);
        enc.serializeInteger(this.iSupportDelayReboot);
        if (this.strPatchVersion != null) {
            int ex_id_strPatchVersion1 = enc.serializeExplicit(Encoder.buildTag((int)2, (int)0));
            enc.serializeOctetString(this.strPatchVersion);
            enc.finishedBy(ex_id_strPatchVersion1);
        }
        if (this.strBoard != null) {
            int ex_id_strBoard1 = enc.serializeExplicit(Encoder.buildTag((int)2, (int)1));
            enc.serializeOctetString(this.strBoard);
            enc.finishedBy(ex_id_strBoard1);
        }
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.iDeviceId = dec.deserializeInteger();
        this.strVersion = dec.deserializeOctetString();
        this.iSupportDelayReboot = dec.deserializeInteger();
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)0))) {
            int ex_id_strPatchVersion1 = dec.deserializeExplicit(Decoder.buildTag((int)2, (int)0));
            this.strPatchVersion = dec.deserializeOctetString();
            dec.finishedBy(ex_id_strPatchVersion1);
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)1))) {
            int ex_id_strBoard1 = dec.deserializeExplicit(Decoder.buildTag((int)2, (int)1));
            this.strBoard = dec.deserializeOctetString();
            dec.finishedBy(ex_id_strBoard1);
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iDeviceId = ");
        os.print(this.iDeviceId.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("strVersion = ");
        os.print(FStruFormat.convertToString((byte[])this.strVersion));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iSupportDelayReboot = ");
        os.print(this.iSupportDelayReboot.toString());
        os.println(',');
        if (this.strPatchVersion != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("strPatchVersion = ");
            os.print(FStruFormat.convertToString((byte[])this.strPatchVersion));
            os.println(',');
        }
        if (this.strBoard != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("strBoard = ");
            os.print(FStruFormat.convertToString((byte[])this.strBoard));
            os.println();
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

