/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.asndatacenter;

import com.huawei.dc.common.asndatacenter.AsnDCRebootTypeEnum;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.GregorianCalendar;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;

public class AsnDCDeviceOprReq
implements FStruct {
    public BigInteger iDevId;
    public boolean bReboot;
    public boolean _bReboot = false;
    public AsnDCRebootTypeEnum rebootType = new AsnDCRebootTypeEnum();
    public Calendar scheduledReboot = null;

    public AsnDCDeviceOprReq() {
    }

    public AsnDCDeviceOprReq(AsnDCDeviceOprReq arg) {
        this.iDevId = arg.iDevId;
        this._bReboot = arg._bReboot;
        this.bReboot = arg.bReboot;
        this.rebootType = new AsnDCRebootTypeEnum(arg.rebootType);
        if (arg.scheduledReboot != null) {
            this.scheduledReboot = (Calendar)arg.scheduledReboot.clone();
        }
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeInteger(this.iDevId);
        if (this._bReboot) {
            enc.serializeBoolean(this.bReboot);
        }
        this.rebootType.serialize(enc);
        if (this.scheduledReboot != null) {
            enc.serializeUTCTime(this.scheduledReboot);
        }
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.iDevId = dec.deserializeInteger();
        if (!dec.isNextOptional(Decoder.buildTag((int)0, (int)1))) {
            this.bReboot = dec.deserializeBoolean();
        }
        this.rebootType.deserialize(dec);
        if (!dec.isNextOptional(Decoder.buildTag((int)0, (int)23))) {
            this.scheduledReboot = new GregorianCalendar();
            this.scheduledReboot = dec.deserializeUTCTime();
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iDevId = ");
        os.print(this.iDevId.toString());
        os.println(',');
        if (this._bReboot) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("bReboot = ");
            os.print(this.bReboot);
            os.println(',');
        }
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("rebootType = ");
        this.rebootType.print(os, indent + 2);
        os.println(',');
        if (this.scheduledReboot != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("scheduledReboot = ");
            os.print(this.scheduledReboot.getTime().toString());
            os.println();
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

