/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.asndatacenter;

import com.huawei.dc.common.asndatacenter.AsnDCDeviceBoards;
import com.huawei.dc.common.asndatacenter.AsnDCDeviceVersion;
import com.huawei.dc.common.asndatacenter.AsnDCErrorCodeInfo;
import com.huawei.dc.common.asndatacenter.AsnDCMultiRequestProgressInfo;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;

public class AsnDCDeviceBoardNotification
implements FStruct {
    public BigInteger oReqID;
    public AsnDCErrorCodeInfo oErrorInfo = new AsnDCErrorCodeInfo();
    public AsnDCErrorCodeInfo oPatchErrorInfo = null;
    public AsnDCDeviceBoards oBoardsInfo = null;
    public boolean bIsFinal;
    public AsnDCDeviceVersion oVersionInfo = null;
    public AsnDCMultiRequestProgressInfo oProgressInfo = new AsnDCMultiRequestProgressInfo();

    public AsnDCDeviceBoardNotification() {
    }

    public AsnDCDeviceBoardNotification(AsnDCDeviceBoardNotification arg) {
        this.oReqID = arg.oReqID;
        this.oErrorInfo = new AsnDCErrorCodeInfo(arg.oErrorInfo);
        if (arg.oPatchErrorInfo != null) {
            this.oPatchErrorInfo = new AsnDCErrorCodeInfo(arg.oPatchErrorInfo);
        }
        if (arg.oBoardsInfo != null) {
            this.oBoardsInfo = new AsnDCDeviceBoards(arg.oBoardsInfo);
        }
        this.bIsFinal = arg.bIsFinal;
        if (arg.oVersionInfo != null) {
            this.oVersionInfo = new AsnDCDeviceVersion(arg.oVersionInfo);
        }
        this.oProgressInfo = new AsnDCMultiRequestProgressInfo(arg.oProgressInfo);
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeInteger(this.oReqID);
        this.oErrorInfo.serialize(enc);
        if (this.oPatchErrorInfo != null) {
            this.oPatchErrorInfo.serialize(enc);
        }
        if (this.oBoardsInfo != null) {
            int ex_id_oBoardsInfo1 = enc.serializeExplicit(Encoder.buildTag((int)2, (int)0));
            this.oBoardsInfo.serialize(enc);
            enc.finishedBy(ex_id_oBoardsInfo1);
        }
        enc.serializeBoolean(this.bIsFinal);
        if (this.oVersionInfo != null) {
            int ex_id_oVersionInfo1 = enc.serializeExplicit(Encoder.buildTag((int)2, (int)1));
            this.oVersionInfo.serialize(enc);
            enc.finishedBy(ex_id_oVersionInfo1);
        }
        this.oProgressInfo.serialize(enc);
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.oReqID = dec.deserializeInteger();
        this.oErrorInfo.deserialize(dec);
        if (!dec.isNextOptional(Decoder.buildTag((int)0, (int)16))) {
            this.oPatchErrorInfo = new AsnDCErrorCodeInfo();
            this.oPatchErrorInfo.deserialize(dec);
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)0))) {
            this.oBoardsInfo = new AsnDCDeviceBoards();
            int ex_id_oBoardsInfo1 = dec.deserializeExplicit(Decoder.buildTag((int)2, (int)0));
            this.oBoardsInfo.deserialize(dec);
            dec.finishedBy(ex_id_oBoardsInfo1);
        }
        this.bIsFinal = dec.deserializeBoolean();
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)1))) {
            this.oVersionInfo = new AsnDCDeviceVersion();
            int ex_id_oVersionInfo1 = dec.deserializeExplicit(Decoder.buildTag((int)2, (int)1));
            this.oVersionInfo.deserialize(dec);
            dec.finishedBy(ex_id_oVersionInfo1);
        }
        this.oProgressInfo.deserialize(dec);
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("oReqID = ");
        os.print(this.oReqID.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("oErrorInfo = ");
        this.oErrorInfo.print(os, indent + 2);
        os.println(',');
        if (this.oPatchErrorInfo != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("oPatchErrorInfo = ");
            this.oPatchErrorInfo.print(os, indent + 2);
            os.println(',');
        }
        if (this.oBoardsInfo != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("oBoardsInfo = ");
            this.oBoardsInfo.print(os, indent + 2);
            os.println(',');
        }
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("bIsFinal = ");
        os.print(this.bIsFinal);
        os.println(',');
        if (this.oVersionInfo != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("oVersionInfo = ");
            this.oVersionInfo.print(os, indent + 2);
            os.println(',');
        }
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("oProgressInfo = ");
        this.oProgressInfo.print(os, indent + 2);
        os.println();
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

