/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.asndatacenter;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class AsnDCConnInfo
implements FStruct {
    public BigInteger iDevId;
    public BigInteger iCheckMode;
    public byte[] strContent;

    public AsnDCConnInfo() {
    }

    public AsnDCConnInfo(AsnDCConnInfo arg) {
        this.iDevId = arg.iDevId;
        this.iCheckMode = arg.iCheckMode;
        this.strContent = new byte[arg.strContent.length];
        System.arraycopy(arg.strContent, 0, this.strContent, 0, arg.strContent.length);
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeInteger(this.iDevId);
        enc.serializeInteger(this.iCheckMode);
        enc.serializeOctetString(this.strContent);
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.iDevId = dec.deserializeInteger();
        this.iCheckMode = dec.deserializeInteger();
        this.strContent = dec.deserializeOctetString();
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iDevId = ");
        os.print(this.iDevId.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iCheckMode = ");
        os.print(this.iCheckMode.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("strContent = ");
        os.print(FStruFormat.convertToString((byte[])this.strContent));
        os.println();
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

