/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.asndatacenter;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.GregorianCalendar;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class AsnDCBackUpFileInfo
implements FStruct {
    public byte[] strFileName;
    public BigInteger iFileSize = null;
    public Calendar strTime = null;

    public AsnDCBackUpFileInfo() {
    }

    public AsnDCBackUpFileInfo(AsnDCBackUpFileInfo arg) {
        this.strFileName = new byte[arg.strFileName.length];
        System.arraycopy(arg.strFileName, 0, this.strFileName, 0, arg.strFileName.length);
        if (arg.iFileSize != null) {
            this.iFileSize = arg.iFileSize;
        }
        if (arg.strTime != null) {
            this.strTime = (Calendar)arg.strTime.clone();
        }
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeOctetString(this.strFileName);
        if (this.iFileSize != null) {
            enc.serializeInteger(this.iFileSize);
        }
        if (this.strTime != null) {
            enc.serializeUTCTime(this.strTime);
        }
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.strFileName = dec.deserializeOctetString();
        if (!dec.isNextOptional(Decoder.buildTag((int)0, (int)2))) {
            this.iFileSize = dec.deserializeInteger();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)0, (int)23))) {
            this.strTime = new GregorianCalendar();
            this.strTime = dec.deserializeUTCTime();
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("strFileName = ");
        os.print(FStruFormat.convertToString((byte[])this.strFileName));
        os.println(',');
        if (this.iFileSize != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("iFileSize = ");
            os.print(this.iFileSize.toString());
            os.println(',');
        }
        if (this.strTime != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("strTime = ");
            os.print(this.strTime.getTime().toString());
            os.println();
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

