/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.asndatacenter;

import com.huawei.dc.common.asndatacenter.AsnDCActivationGroupLst;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.GregorianCalendar;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class AsnDCActivationGroupInfo
implements FStruct {
    public AsnDCActivationGroupLst oActiveGroupLst = new AsnDCActivationGroupLst();
    public byte[] strActiveFilePath = null;
    public Calendar oActivationTime = null;
    public BigInteger iCurrentGroup = null;

    public AsnDCActivationGroupInfo() {
    }

    public AsnDCActivationGroupInfo(AsnDCActivationGroupInfo arg) {
        this.oActiveGroupLst = new AsnDCActivationGroupLst(arg.oActiveGroupLst);
        if (arg.strActiveFilePath != null) {
            this.strActiveFilePath = new byte[arg.strActiveFilePath.length];
            System.arraycopy(arg.strActiveFilePath, 0, this.strActiveFilePath, 0, arg.strActiveFilePath.length);
        }
        if (arg.oActivationTime != null) {
            this.oActivationTime = (Calendar)arg.oActivationTime.clone();
        }
        if (arg.iCurrentGroup != null) {
            this.iCurrentGroup = arg.iCurrentGroup;
        }
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        this.oActiveGroupLst.serialize(enc);
        if (this.strActiveFilePath != null) {
            int ex_id_strActiveFilePath1 = enc.serializeExplicit(Encoder.buildTag((int)2, (int)0));
            enc.serializeOctetString(this.strActiveFilePath);
            enc.finishedBy(ex_id_strActiveFilePath1);
        }
        if (this.oActivationTime != null) {
            int ex_id_oActivationTime1 = enc.serializeExplicit(Encoder.buildTag((int)2, (int)1));
            enc.serializeUTCTime(this.oActivationTime);
            enc.finishedBy(ex_id_oActivationTime1);
        }
        if (this.iCurrentGroup != null) {
            int ex_id_iCurrentGroup1 = enc.serializeExplicit(Encoder.buildTag((int)2, (int)2));
            enc.serializeInteger(this.iCurrentGroup);
            enc.finishedBy(ex_id_iCurrentGroup1);
        }
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.oActiveGroupLst.deserialize(dec);
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)0))) {
            int ex_id_strActiveFilePath1 = dec.deserializeExplicit(Decoder.buildTag((int)2, (int)0));
            this.strActiveFilePath = dec.deserializeOctetString();
            dec.finishedBy(ex_id_strActiveFilePath1);
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)1))) {
            this.oActivationTime = new GregorianCalendar();
            int ex_id_oActivationTime1 = dec.deserializeExplicit(Decoder.buildTag((int)2, (int)1));
            this.oActivationTime = dec.deserializeUTCTime();
            dec.finishedBy(ex_id_oActivationTime1);
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)2))) {
            int ex_id_iCurrentGroup1 = dec.deserializeExplicit(Decoder.buildTag((int)2, (int)2));
            this.iCurrentGroup = dec.deserializeInteger();
            dec.finishedBy(ex_id_iCurrentGroup1);
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("oActiveGroupLst = ");
        this.oActiveGroupLst.print(os, indent + 2);
        os.println(',');
        if (this.strActiveFilePath != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("strActiveFilePath = ");
            os.print(FStruFormat.convertToString((byte[])this.strActiveFilePath));
            os.println(',');
        }
        if (this.oActivationTime != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("oActivationTime = ");
            os.print(this.oActivationTime.getTime().toString());
            os.println(',');
        }
        if (this.iCurrentGroup != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("iCurrentGroup = ");
            os.print(this.iCurrentGroup.toString());
            os.println();
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

