/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.asndatacenter;

import com.huawei.dc.common.asndatacenter.AsnDCNodeInfo;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class AsnContentTypeInfo
implements FStruct {
    public BigInteger iContentType;
    public byte[] strDestination = null;
    public BigInteger iSequence = null;
    public AsnDCNodeInfo oAsnDCNodeInfo = null;

    public AsnContentTypeInfo() {
    }

    public AsnContentTypeInfo(AsnContentTypeInfo arg) {
        this.iContentType = arg.iContentType;
        if (arg.strDestination != null) {
            this.strDestination = new byte[arg.strDestination.length];
            System.arraycopy(arg.strDestination, 0, this.strDestination, 0, arg.strDestination.length);
        }
        if (arg.iSequence != null) {
            this.iSequence = arg.iSequence;
        }
        if (arg.oAsnDCNodeInfo != null) {
            this.oAsnDCNodeInfo = new AsnDCNodeInfo(arg.oAsnDCNodeInfo);
        }
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeInteger(this.iContentType);
        if (this.strDestination != null) {
            enc.serializeOctetString(this.strDestination);
        }
        if (this.iSequence != null) {
            enc.serializeInteger(this.iSequence);
        }
        if (this.oAsnDCNodeInfo != null) {
            this.oAsnDCNodeInfo.serialize(enc);
        }
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.iContentType = dec.deserializeInteger();
        if (!dec.isNextOptional(Decoder.buildTag((int)0, (int)4))) {
            this.strDestination = dec.deserializeOctetString();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)0, (int)2))) {
            this.iSequence = dec.deserializeInteger();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)0, (int)16))) {
            this.oAsnDCNodeInfo = new AsnDCNodeInfo();
            this.oAsnDCNodeInfo.deserialize(dec);
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iContentType = ");
        os.print(this.iContentType.toString());
        os.println(',');
        if (this.strDestination != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("strDestination = ");
            os.print(FStruFormat.convertToString((byte[])this.strDestination));
            os.println(',');
        }
        if (this.iSequence != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("iSequence = ");
            os.print(this.iSequence.toString());
            os.println(',');
        }
        if (this.oAsnDCNodeInfo != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("oAsnDCNodeInfo = ");
            this.oAsnDCNodeInfo.print(os, indent + 2);
            os.println();
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

