/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.asndatacenter;

import com.huawei.dc.common.asndatacenter.AsnPatchInfoLst;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class AsnBoardPatchInfo
implements FStruct {
    public BigInteger iFrameId;
    public BigInteger iSlotId;
    public BigInteger iSubSlotId = null;
    public BigInteger iBoardType;
    public AsnPatchInfoLst oPatchInfoLst = new AsnPatchInfoLst();
    public byte[] strSlotName;

    public AsnBoardPatchInfo() {
    }

    public AsnBoardPatchInfo(AsnBoardPatchInfo arg) {
        this.iFrameId = arg.iFrameId;
        this.iSlotId = arg.iSlotId;
        if (arg.iSubSlotId != null) {
            this.iSubSlotId = arg.iSubSlotId;
        }
        this.iBoardType = arg.iBoardType;
        this.oPatchInfoLst = new AsnPatchInfoLst(arg.oPatchInfoLst);
        this.strSlotName = new byte[arg.strSlotName.length];
        System.arraycopy(arg.strSlotName, 0, this.strSlotName, 0, arg.strSlotName.length);
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeInteger(this.iFrameId);
        enc.serializeInteger(this.iSlotId);
        if (this.iSubSlotId != null) {
            int ex_id_iSubSlotId1 = enc.serializeExplicit(Encoder.buildTag((int)2, (int)0));
            enc.serializeInteger(this.iSubSlotId);
            enc.finishedBy(ex_id_iSubSlotId1);
        }
        enc.serializeInteger(this.iBoardType);
        this.oPatchInfoLst.serialize(enc);
        enc.serializeOctetString(this.strSlotName);
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.iFrameId = dec.deserializeInteger();
        this.iSlotId = dec.deserializeInteger();
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)0))) {
            int ex_id_iSubSlotId1 = dec.deserializeExplicit(Decoder.buildTag((int)2, (int)0));
            this.iSubSlotId = dec.deserializeInteger();
            dec.finishedBy(ex_id_iSubSlotId1);
        }
        this.iBoardType = dec.deserializeInteger();
        this.oPatchInfoLst.deserialize(dec);
        this.strSlotName = dec.deserializeOctetString();
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iFrameId = ");
        os.print(this.iFrameId.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iSlotId = ");
        os.print(this.iSlotId.toString());
        os.println(',');
        if (this.iSubSlotId != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("iSubSlotId = ");
            os.print(this.iSubSlotId.toString());
            os.println(',');
        }
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iBoardType = ");
        os.print(this.iBoardType.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("oPatchInfoLst = ");
        this.oPatchInfoLst.print(os, indent + 2);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("strSlotName = ");
        os.print(FStruFormat.convertToString((byte[])this.strSlotName));
        os.println();
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

