/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.asndatacenter;

import com.huawei.dc.common.asndatacenter.AsnActivationTypeEnum;
import com.huawei.dc.common.asndatacenter.AsnOperationModeEnum;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.GregorianCalendar;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class AsnActivateOpInfo
implements FStruct {
    public AsnActivationTypeEnum oActivationType = null;
    public boolean bBoardLevel;
    public AsnOperationModeEnum oAsnOperationModeEnum = null;
    public Calendar oActivationTime = null;
    public Calendar oScheduledActivateTime = null;
    public byte[] strLogFile = null;
    public BigInteger iDelayRebootTime = null;

    public AsnActivateOpInfo() {
    }

    public AsnActivateOpInfo(AsnActivateOpInfo arg) {
        if (arg.oActivationType != null) {
            this.oActivationType = new AsnActivationTypeEnum(arg.oActivationType);
        }
        this.bBoardLevel = arg.bBoardLevel;
        if (arg.oAsnOperationModeEnum != null) {
            this.oAsnOperationModeEnum = new AsnOperationModeEnum(arg.oAsnOperationModeEnum);
        }
        if (arg.oActivationTime != null) {
            this.oActivationTime = (Calendar)arg.oActivationTime.clone();
        }
        if (arg.oScheduledActivateTime != null) {
            this.oScheduledActivateTime = (Calendar)arg.oScheduledActivateTime.clone();
        }
        if (arg.strLogFile != null) {
            this.strLogFile = new byte[arg.strLogFile.length];
            System.arraycopy(arg.strLogFile, 0, this.strLogFile, 0, arg.strLogFile.length);
        }
        if (arg.iDelayRebootTime != null) {
            this.iDelayRebootTime = arg.iDelayRebootTime;
        }
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        if (this.oActivationType != null) {
            this.oActivationType.serialize(enc);
        }
        enc.serializeBoolean(this.bBoardLevel);
        if (this.oAsnOperationModeEnum != null) {
            this.oAsnOperationModeEnum.serialize(enc);
        }
        if (this.oActivationTime != null) {
            int ex_id_oActivationTime1 = enc.serializeExplicit(Encoder.buildTag((int)2, (int)0));
            enc.serializeUTCTime(this.oActivationTime);
            enc.finishedBy(ex_id_oActivationTime1);
        }
        if (this.oScheduledActivateTime != null) {
            int ex_id_oScheduledActivateTime1 = enc.serializeExplicit(Encoder.buildTag((int)2, (int)1));
            enc.serializeUTCTime(this.oScheduledActivateTime);
            enc.finishedBy(ex_id_oScheduledActivateTime1);
        }
        if (this.strLogFile != null) {
            int ex_id_strLogFile1 = enc.serializeExplicit(Encoder.buildTag((int)2, (int)2));
            enc.serializeOctetString(this.strLogFile);
            enc.finishedBy(ex_id_strLogFile1);
        }
        if (this.iDelayRebootTime != null) {
            enc.serializeInteger(this.iDelayRebootTime);
        }
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        if (!dec.isNextOptional(Decoder.buildTag((int)0, (int)10))) {
            this.oActivationType = new AsnActivationTypeEnum();
            this.oActivationType.deserialize(dec);
        }
        this.bBoardLevel = dec.deserializeBoolean();
        if (!dec.isNextOptional(Decoder.buildTag((int)0, (int)10))) {
            this.oAsnOperationModeEnum = new AsnOperationModeEnum();
            this.oAsnOperationModeEnum.deserialize(dec);
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)0))) {
            this.oActivationTime = new GregorianCalendar();
            int ex_id_oActivationTime1 = dec.deserializeExplicit(Decoder.buildTag((int)2, (int)0));
            this.oActivationTime = dec.deserializeUTCTime();
            dec.finishedBy(ex_id_oActivationTime1);
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)1))) {
            this.oScheduledActivateTime = new GregorianCalendar();
            int ex_id_oScheduledActivateTime1 = dec.deserializeExplicit(Decoder.buildTag((int)2, (int)1));
            this.oScheduledActivateTime = dec.deserializeUTCTime();
            dec.finishedBy(ex_id_oScheduledActivateTime1);
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)2))) {
            int ex_id_strLogFile1 = dec.deserializeExplicit(Decoder.buildTag((int)2, (int)2));
            this.strLogFile = dec.deserializeOctetString();
            dec.finishedBy(ex_id_strLogFile1);
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)0, (int)2))) {
            this.iDelayRebootTime = dec.deserializeInteger();
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        if (this.oActivationType != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("oActivationType = ");
            this.oActivationType.print(os, indent + 2);
            os.println(',');
        }
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("bBoardLevel = ");
        os.print(this.bBoardLevel);
        os.println(',');
        if (this.oAsnOperationModeEnum != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("oAsnOperationModeEnum = ");
            this.oAsnOperationModeEnum.print(os, indent + 2);
            os.println(',');
        }
        if (this.oActivationTime != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("oActivationTime = ");
            os.print(this.oActivationTime.getTime().toString());
            os.println(',');
        }
        if (this.oScheduledActivateTime != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("oScheduledActivateTime = ");
            os.print(this.oScheduledActivateTime.getTime().toString());
            os.println(',');
        }
        if (this.strLogFile != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("strLogFile = ");
            os.print(FStruFormat.convertToString((byte[])this.strLogFile));
            os.println(',');
        }
        if (this.iDelayRebootTime != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("iDelayRebootTime = ");
            os.print(this.iDelayRebootTime.toString());
            os.println();
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

