/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.asndatacenter;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.GregorianCalendar;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class ASNDCFileInfoStruct
implements FStruct {
    public byte[] strFilename;
    public byte[] strVersion = null;
    public BigInteger iContent = null;
    public BigInteger iFileSize = null;
    public BigInteger iDevType = null;
    public BigInteger iDevTypeVersion = null;
    public Calendar strTime = null;

    public ASNDCFileInfoStruct() {
    }

    public ASNDCFileInfoStruct(ASNDCFileInfoStruct arg) {
        this.strFilename = new byte[arg.strFilename.length];
        System.arraycopy(arg.strFilename, 0, this.strFilename, 0, arg.strFilename.length);
        if (arg.strVersion != null) {
            this.strVersion = new byte[arg.strVersion.length];
            System.arraycopy(arg.strVersion, 0, this.strVersion, 0, arg.strVersion.length);
        }
        if (arg.iContent != null) {
            this.iContent = arg.iContent;
        }
        if (arg.iFileSize != null) {
            this.iFileSize = arg.iFileSize;
        }
        if (arg.iDevType != null) {
            this.iDevType = arg.iDevType;
        }
        if (arg.iDevTypeVersion != null) {
            this.iDevTypeVersion = arg.iDevTypeVersion;
        }
        if (arg.strTime != null) {
            this.strTime = (Calendar)arg.strTime.clone();
        }
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        int ex_id_strFilename1 = enc.serializeExplicit(Encoder.buildTag((int)2, (int)0));
        enc.serializeOctetString(this.strFilename);
        enc.finishedBy(ex_id_strFilename1);
        if (this.strVersion != null) {
            int ex_id_strVersion1 = enc.serializeExplicit(Encoder.buildTag((int)2, (int)1));
            enc.serializeOctetString(this.strVersion);
            enc.finishedBy(ex_id_strVersion1);
        }
        if (this.iContent != null) {
            int ex_id_iContent1 = enc.serializeExplicit(Encoder.buildTag((int)2, (int)2));
            enc.serializeInteger(this.iContent);
            enc.finishedBy(ex_id_iContent1);
        }
        if (this.iFileSize != null) {
            int ex_id_iFileSize1 = enc.serializeExplicit(Encoder.buildTag((int)2, (int)3));
            enc.serializeInteger(this.iFileSize);
            enc.finishedBy(ex_id_iFileSize1);
        }
        if (this.iDevType != null) {
            int ex_id_iDevType1 = enc.serializeExplicit(Encoder.buildTag((int)2, (int)4));
            enc.serializeInteger(this.iDevType);
            enc.finishedBy(ex_id_iDevType1);
        }
        if (this.iDevTypeVersion != null) {
            int ex_id_iDevTypeVersion1 = enc.serializeExplicit(Encoder.buildTag((int)2, (int)5));
            enc.serializeInteger(this.iDevTypeVersion);
            enc.finishedBy(ex_id_iDevTypeVersion1);
        }
        if (this.strTime != null) {
            int ex_id_strTime1 = enc.serializeExplicit(Encoder.buildTag((int)2, (int)6));
            enc.serializeUTCTime(this.strTime);
            enc.finishedBy(ex_id_strTime1);
        }
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        int ex_id_strFilename1 = dec.deserializeExplicit(Decoder.buildTag((int)2, (int)0));
        this.strFilename = dec.deserializeOctetString();
        dec.finishedBy(ex_id_strFilename1);
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)1))) {
            int ex_id_strVersion1 = dec.deserializeExplicit(Decoder.buildTag((int)2, (int)1));
            this.strVersion = dec.deserializeOctetString();
            dec.finishedBy(ex_id_strVersion1);
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)2))) {
            int ex_id_iContent1 = dec.deserializeExplicit(Decoder.buildTag((int)2, (int)2));
            this.iContent = dec.deserializeInteger();
            dec.finishedBy(ex_id_iContent1);
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)3))) {
            int ex_id_iFileSize1 = dec.deserializeExplicit(Decoder.buildTag((int)2, (int)3));
            this.iFileSize = dec.deserializeInteger();
            dec.finishedBy(ex_id_iFileSize1);
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)4))) {
            int ex_id_iDevType1 = dec.deserializeExplicit(Decoder.buildTag((int)2, (int)4));
            this.iDevType = dec.deserializeInteger();
            dec.finishedBy(ex_id_iDevType1);
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)5))) {
            int ex_id_iDevTypeVersion1 = dec.deserializeExplicit(Decoder.buildTag((int)2, (int)5));
            this.iDevTypeVersion = dec.deserializeInteger();
            dec.finishedBy(ex_id_iDevTypeVersion1);
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)6))) {
            this.strTime = new GregorianCalendar();
            int ex_id_strTime1 = dec.deserializeExplicit(Decoder.buildTag((int)2, (int)6));
            this.strTime = dec.deserializeUTCTime();
            dec.finishedBy(ex_id_strTime1);
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("strFilename = ");
        os.print(FStruFormat.convertToString((byte[])this.strFilename));
        os.println(',');
        if (this.strVersion != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("strVersion = ");
            os.print(FStruFormat.convertToString((byte[])this.strVersion));
            os.println(',');
        }
        if (this.iContent != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("iContent = ");
            os.print(this.iContent.toString());
            os.println(',');
        }
        if (this.iFileSize != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("iFileSize = ");
            os.print(this.iFileSize.toString());
            os.println(',');
        }
        if (this.iDevType != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("iDevType = ");
            os.print(this.iDevType.toString());
            os.println(',');
        }
        if (this.iDevTypeVersion != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("iDevTypeVersion = ");
            os.print(this.iDevTypeVersion.toString());
            os.println(',');
        }
        if (this.strTime != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("strTime = ");
            os.print(this.strTime.getTime().toString());
            os.println();
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

